/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.enclosing.EnclosingBall;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.enclosing.WelzlEncloser;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Rotation;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.RotationConvention;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.SphereGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.AbstractRegion;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTree;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BoundaryProjection;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.RegionFactory;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.Sphere1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.Circle;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.Edge;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.EdgesBuilder;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.PropertiesComputer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.S2Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.Sphere2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.Vertex;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SphericalPolygonsSet
extends AbstractRegion<Sphere2D, Sphere1D> {
    private List<Vertex> loops;

    public SphericalPolygonsSet(double d2) {
        super(d2);
    }

    public SphericalPolygonsSet(Vector3D vector3D, double d2) {
        super(new BSPTree<Sphere2D>(new Circle(vector3D, d2).wholeHyperplane(), new BSPTree(Boolean.FALSE), new BSPTree(Boolean.TRUE), null), d2);
    }

    public SphericalPolygonsSet(Vector3D vector3D, Vector3D vector3D2, double d2, int n, double d3) {
        this(d3, SphericalPolygonsSet.createRegularPolygonVertices(vector3D, vector3D2, d2, n));
    }

    public SphericalPolygonsSet(BSPTree<Sphere2D> bSPTree, double d2) {
        super(bSPTree, d2);
    }

    public SphericalPolygonsSet(Collection<SubHyperplane<Sphere2D>> collection, double d2) {
        super(collection, d2);
    }

    public SphericalPolygonsSet(double d2, S2Point ... s2PointArray) {
        super(SphericalPolygonsSet.verticesToTree(d2, s2PointArray), d2);
    }

    private static S2Point[] createRegularPolygonVertices(Vector3D serializable, Vector3D serializable2, double d2, int n) {
        S2Point[] s2PointArray = new S2Point[n];
        serializable2 = new Rotation(Vector3D.crossProduct((Vector3D)serializable, (Vector3D)serializable2), d2, RotationConvention.VECTOR_OPERATOR);
        s2PointArray[0] = new S2Point(((Rotation)serializable2).applyTo((Vector3D)serializable));
        serializable = new Rotation((Vector3D)serializable, Math.PI * 2 / (double)n, RotationConvention.VECTOR_OPERATOR);
        for (int i2 = 1; i2 < n; ++i2) {
            s2PointArray[i2] = new S2Point(((Rotation)serializable).applyTo(s2PointArray[i2 - 1].getVector()));
        }
        return s2PointArray;
    }

    private static BSPTree<Sphere2D> verticesToTree(double d2, S2Point ... object) {
        int n = ((S2Point[])object).length;
        if (n == 0) {
            return new BSPTree<Sphere2D>(Boolean.TRUE);
        }
        Vertex[] vertexArray = new Vertex[n];
        for (int i2 = 0; i2 < n; ++i2) {
            vertexArray[i2] = new Vertex(object[i2]);
        }
        ArrayList<Edge> arrayList = new ArrayList<Edge>(n);
        object = vertexArray[n - 1];
        for (int i3 = 0; i3 < n; ++i3) {
            Object object2 = object;
            Circle circle = ((Vertex)object2).sharedCircleWith((Vertex)(object = vertexArray[i3]));
            if (circle == null) {
                circle = new Circle(((Vertex)object2).getLocation(), ((Vertex)object).getLocation(), d2);
            }
            arrayList.add(new Edge((Vertex)object2, (Vertex)object, Vector3D.angle(((Vertex)object2).getLocation().getVector(), ((Vertex)object).getLocation().getVector()), circle));
            Vertex[] vertexArray2 = vertexArray;
            int n2 = vertexArray.length;
            for (int i4 = 0; i4 < n2; ++i4) {
                Vertex vertex = vertexArray2[i4];
                if (vertex == object2 || vertex == object || !(FastMath.abs(circle.getOffset(vertex.getLocation())) <= d2)) continue;
                vertex.bindWith(circle);
            }
        }
        BSPTree<Sphere2D> bSPTree = new BSPTree<Sphere2D>();
        SphericalPolygonsSet.insertEdges(d2, bSPTree, arrayList);
        return bSPTree;
    }

    private static void insertEdges(double d2, BSPTree<Sphere2D> bSPTree, List<Edge> object) {
        int n = 0;
        Edge edge = null;
        while (edge == null && n < object.size()) {
            if (bSPTree.insertCut((edge = object.get(n++)).getCircle())) continue;
            edge = null;
        }
        if (edge == null) {
            BSPTree<Sphere2D> bSPTree2 = bSPTree.getParent();
            if (bSPTree2 == null || bSPTree == bSPTree2.getMinus()) {
                bSPTree.setAttribute(Boolean.TRUE);
                return;
            }
            bSPTree.setAttribute(Boolean.FALSE);
            return;
        }
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        ArrayList<Edge> arrayList2 = new ArrayList<Edge>();
        object = object.iterator();
        while (object.hasNext()) {
            Edge edge2 = (Edge)object.next();
            if (edge2 == edge) continue;
            edge2.split(edge.getCircle(), arrayList, arrayList2);
        }
        if (!arrayList.isEmpty()) {
            SphericalPolygonsSet.insertEdges(d2, bSPTree.getPlus(), arrayList);
        } else {
            bSPTree.getPlus().setAttribute(Boolean.FALSE);
        }
        if (!arrayList2.isEmpty()) {
            SphericalPolygonsSet.insertEdges(d2, bSPTree.getMinus(), arrayList2);
            return;
        }
        bSPTree.getMinus().setAttribute(Boolean.TRUE);
    }

    public SphericalPolygonsSet buildNew(BSPTree<Sphere2D> bSPTree) {
        return new SphericalPolygonsSet(bSPTree, this.getTolerance());
    }

    @Override
    protected void computeGeometricalProperties() {
        BSPTree<Sphere2D> bSPTree = this.getTree(true);
        if (bSPTree.getCut() == null) {
            if (bSPTree.getCut() == null && ((Boolean)bSPTree.getAttribute()).booleanValue()) {
                this.setSize(Math.PI * 4);
                this.setBarycenter(new S2Point(0.0, 0.0));
                return;
            }
            this.setSize(0.0);
            this.setBarycenter(S2Point.NaN);
            return;
        }
        PropertiesComputer propertiesComputer = new PropertiesComputer(this.getTolerance());
        bSPTree.visit(propertiesComputer);
        this.setSize(propertiesComputer.getArea());
        this.setBarycenter(propertiesComputer.getBarycenter());
    }

    public List<Vertex> getBoundaryLoops() {
        if (this.loops == null) {
            if (this.getTree(false).getCut() == null) {
                this.loops = Collections.emptyList();
            } else {
                Object object = this.getTree(true);
                Object object2 = new EdgesBuilder((BSPTree<Sphere2D>)object, this.getTolerance());
                ((BSPTree)object).visit((BSPTreeVisitor<Sphere2D>)object2);
                object = ((EdgesBuilder)object2).getEdges();
                this.loops = new ArrayList<Vertex>();
                while (!object.isEmpty()) {
                    object2 = (Edge)object.get(0);
                    Vertex vertex = ((Edge)object2).getStart();
                    this.loops.add(vertex);
                    block1: do {
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            if (iterator.next() != object2) continue;
                            iterator.remove();
                            continue block1;
                        }
                    } while (((Edge)(object2 = ((Edge)object2).getEnd().getOutgoing())).getStart() != vertex);
                }
            }
        }
        return Collections.unmodifiableList(this.loops);
    }

    public EnclosingBall<Sphere2D, S2Point> getEnclosingCap() {
        double d2;
        Object object;
        if (this.isEmpty()) {
            return new EnclosingBall((Point)S2Point.PLUS_K, Double.NEGATIVE_INFINITY, (Point[])new S2Point[0]);
        }
        if (this.isFull()) {
            return new EnclosingBall((Point)S2Point.PLUS_K, Double.POSITIVE_INFINITY, (Point[])new S2Point[0]);
        }
        Object object3 = this.getTree(false);
        if (this.isEmpty(((BSPTree)object3).getMinus()) && this.isFull(((BSPTree)object3).getPlus())) {
            object3 = (Circle)((BSPTree)object3).getCut().getHyperplane();
            return new EnclosingBall((Point)new S2Point(((Circle)object3).getPole()).negate(), 1.5707963267948966, (Point[])new S2Point[0]);
        }
        if (this.isFull(((BSPTree)object3).getMinus()) && this.isEmpty(((BSPTree)object3).getPlus())) {
            object3 = (Circle)((BSPTree)object3).getCut().getHyperplane();
            return new EnclosingBall((Point)new S2Point(((Circle)object3).getPole()), 1.5707963267948966, (Point[])new S2Point[0]);
        }
        object3 = this.getInsidePoints();
        Iterator<Vector3D> iterator = this.getBoundaryLoops();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Vector3D[] object22 = (Vector3D[])iterator.next();
            object = object22;
            for (int i2 = 0; i2 == 0 || object != object22; ++i2) {
                object3.add(object.getLocation().getVector());
                object = object.getOutgoing().getEnd();
            }
        }
        iterator = new SphereGenerator();
        WelzlEncloser welzlEncloser = new WelzlEncloser(this.getTolerance(), iterator);
        BoundaryProjection<Sphere2D> boundaryProjection = welzlEncloser.enclose(object3);
        object = (Vector3D[])boundaryProjection.getSupport();
        double d3 = ((EnclosingBall)((Object)boundaryProjection)).getRadius();
        double d4 = ((Vector3D)((EnclosingBall)((Object)boundaryProjection)).getCenter()).getNorm();
        if (d2 < this.getTolerance()) {
            object3 = new EnclosingBall((Point)S2Point.PLUS_K, Double.POSITIVE_INFINITY, (Point[])new S2Point[0]);
            for (Vector3D vector3D : this.getOutsidePoints()) {
                S2Point s2Point = new S2Point(vector3D);
                boundaryProjection = this.projectToBoundary(s2Point);
                if (!(Math.PI - boundaryProjection.getOffset() < ((EnclosingBall)object3).getRadius())) continue;
                object3 = new EnclosingBall((Point)s2Point.negate(), Math.PI - boundaryProjection.getOffset(), (Point[])new S2Point[]{(S2Point)boundaryProjection.getProjected()});
            }
            return object3;
        }
        object3 = new S2Point[((Vector3D[])object).length];
        for (int i3 = 0; i3 < ((Vector3D[])object).length; ++i3) {
            object3[i3] = new S2Point(object[i3]);
        }
        double d5 = d4;
        double d6 = d3;
        EnclosingBall enclosingBall = new EnclosingBall((Point)new S2Point((Vector3D)((EnclosingBall)((Object)boundaryProjection)).getCenter()), FastMath.acos((1.0 + d5 * d5 - d6 * d6) / (d4 * 2.0)), (Point[])object3);
        return enclosingBall;
    }

    private List<Vector3D> getInsidePoints() {
        PropertiesComputer propertiesComputer = new PropertiesComputer(this.getTolerance());
        this.getTree(true).visit(propertiesComputer);
        return propertiesComputer.getConvexCellsInsidePoints();
    }

    private List<Vector3D> getOutsidePoints() {
        SphericalPolygonsSet sphericalPolygonsSet = (SphericalPolygonsSet)new RegionFactory<Sphere2D>().getComplement(this);
        PropertiesComputer propertiesComputer = new PropertiesComputer(this.getTolerance());
        sphericalPolygonsSet.getTree(true).visit(propertiesComputer);
        return propertiesComputer.getConvexCellsInsidePoints();
    }
}

