/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Space;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.Sphere2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2Point
implements Point<Sphere2D> {
    public static final S2Point PLUS_I = new S2Point(0.0, 1.5707963267948966, Vector3D.PLUS_I);
    public static final S2Point PLUS_J = new S2Point(1.5707963267948966, 1.5707963267948966, Vector3D.PLUS_J);
    public static final S2Point PLUS_K = new S2Point(0.0, 0.0, Vector3D.PLUS_K);
    public static final S2Point MINUS_I = new S2Point(Math.PI, 1.5707963267948966, Vector3D.MINUS_I);
    public static final S2Point MINUS_J = new S2Point(4.71238898038469, 1.5707963267948966, Vector3D.MINUS_J);
    public static final S2Point MINUS_K = new S2Point(0.0, Math.PI, Vector3D.MINUS_K);
    public static final S2Point NaN = new S2Point(Double.NaN, Double.NaN, Vector3D.NaN);
    private static final long serialVersionUID = 20131218L;
    private final double theta;
    private final double phi;
    private final Vector3D vector;

    public S2Point(double d2, double d3) {
        this(d2, d3, S2Point.vector(d2, d3));
    }

    public S2Point(Vector3D vector3D) {
        this(FastMath.atan2(vector3D.getY(), vector3D.getX()), Vector3D.angle(Vector3D.PLUS_K, vector3D), vector3D.normalize());
    }

    private S2Point(double d2, double d3, Vector3D vector3D) {
        this.theta = d2;
        this.phi = d3;
        this.vector = vector3D;
    }

    private static Vector3D vector(double d2, double d3) {
        if (d3 < 0.0 || d3 > Math.PI) {
            throw new OutOfRangeException(d3, (Number)0, Math.PI);
        }
        double d4 = FastMath.cos(d2);
        double d5 = FastMath.sin(d2);
        double d6 = FastMath.cos(d3);
        double d7 = FastMath.sin(d3);
        return new Vector3D(d4 * d7, d5 * d7, d6);
    }

    public double getTheta() {
        return this.theta;
    }

    public double getPhi() {
        return this.phi;
    }

    public Vector3D getVector() {
        return this.vector;
    }

    @Override
    public Space getSpace() {
        return Sphere2D.getInstance();
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.theta) || Double.isNaN(this.phi);
    }

    public S2Point negate() {
        return new S2Point(-this.theta, Math.PI - this.phi, this.vector.negate());
    }

    @Override
    public double distance(Point<Sphere2D> point) {
        return S2Point.distance(this, (S2Point)point);
    }

    public static double distance(S2Point s2Point, S2Point s2Point2) {
        return Vector3D.angle(s2Point.vector, s2Point2.vector);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof S2Point) {
            if (((S2Point)(object = (S2Point)object)).isNaN()) {
                return this.isNaN();
            }
            return this.theta == ((S2Point)object).theta && this.phi == ((S2Point)object).phi;
        }
        return false;
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 542;
        }
        return 134 * (37 * MathUtils.hash(this.theta) + MathUtils.hash(this.phi));
    }
}

