/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTree;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTreeVisitor$Order;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.Edge;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.S2Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.Sphere2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.SphericalPolygonsSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.Vertex;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertiesComputer
implements BSPTreeVisitor<Sphere2D> {
    private final double tolerance;
    private double summedArea;
    private Vector3D summedBarycenter;
    private final List<Vector3D> convexCellsInsidePoints;

    PropertiesComputer(double d2) {
        this.tolerance = d2;
        this.summedArea = 0.0;
        this.summedBarycenter = Vector3D.ZERO;
        this.convexCellsInsidePoints = new ArrayList<Vector3D>();
    }

    @Override
    public BSPTreeVisitor$Order visitOrder(BSPTree<Sphere2D> bSPTree) {
        return BSPTreeVisitor$Order.MINUS_SUB_PLUS;
    }

    @Override
    public void visitInternalNode(BSPTree<Sphere2D> bSPTree) {
    }

    @Override
    public void visitLeafNode(BSPTree<Sphere2D> object) {
        if (((Boolean)((BSPTree)object).getAttribute()).booleanValue()) {
            object = new SphericalPolygonsSet(((BSPTree)object).pruneAroundConvexCell(Boolean.TRUE, Boolean.FALSE, null), this.tolerance);
            if ((object = ((SphericalPolygonsSet)object).getBoundaryLoops()).size() != 1) {
                throw new MathInternalError();
            }
            double d2 = this.convexCellArea(object.get(0));
            object = this.convexCellBarycenter(object.get(0));
            this.convexCellsInsidePoints.add((Vector3D)object);
            this.summedArea += d2;
            this.summedBarycenter = new Vector3D(1.0, this.summedBarycenter, d2, (Vector3D)object);
        }
    }

    private double convexCellArea(Vertex vertex) {
        int n;
        double d2 = 0.0;
        Edge edge = vertex.getOutgoing();
        for (n = 0; n == 0 || edge.getStart() != vertex; ++n) {
            double d3;
            Vector3D vector3D = edge.getCircle().getPole();
            Vector3D vector3D2 = edge.getEnd().getOutgoing().getCircle().getPole();
            Vector3D vector3D3 = edge.getEnd().getLocation().getVector();
            double d4 = FastMath.atan2(Vector3D.dotProduct(vector3D2, Vector3D.crossProduct(vector3D3, vector3D)), -Vector3D.dotProduct(vector3D2, vector3D));
            if (d3 < 0.0) {
                d4 += Math.PI * 2;
            }
            d2 += d4;
            edge = edge.getEnd().getOutgoing();
        }
        return d2 - (double)(n - 2) * Math.PI;
    }

    private Vector3D convexCellBarycenter(Vertex vertex) {
        Vector3D vector3D = Vector3D.ZERO;
        Edge edge = vertex.getOutgoing();
        for (int i2 = 0; i2 == 0 || edge.getStart() != vertex; ++i2) {
            vector3D = new Vector3D(1.0, vector3D, edge.getLength(), edge.getCircle().getPole());
            edge = edge.getEnd().getOutgoing();
        }
        return vector3D.normalize();
    }

    public double getArea() {
        return this.summedArea;
    }

    public S2Point getBarycenter() {
        if (this.summedBarycenter.getNormSq() == 0.0) {
            return S2Point.NaN;
        }
        return new S2Point(this.summedBarycenter);
    }

    public List<Vector3D> getConvexCellsInsidePoints() {
        return this.convexCellsInsidePoints;
    }
}

