/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalStateException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.AbstractSubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTree;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTreeVisitor$Order;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BoundaryAttribute;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.Arc;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.ArcsSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.S1Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.Circle;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.Edge;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.S2Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.Sphere2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.SubCircle;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.Vertex;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EdgesBuilder
implements BSPTreeVisitor<Sphere2D> {
    private final BSPTree<Sphere2D> root;
    private final double tolerance;
    private final Map<Edge, BSPTree<Sphere2D>> edgeToNode;
    private final Map<BSPTree<Sphere2D>, List<Edge>> nodeToEdgesList;

    EdgesBuilder(BSPTree<Sphere2D> bSPTree, double d2) {
        this.root = bSPTree;
        this.tolerance = d2;
        this.edgeToNode = new IdentityHashMap<Edge, BSPTree<Sphere2D>>();
        this.nodeToEdgesList = new IdentityHashMap<BSPTree<Sphere2D>, List<Edge>>();
    }

    @Override
    public BSPTreeVisitor$Order visitOrder(BSPTree<Sphere2D> bSPTree) {
        return BSPTreeVisitor$Order.MINUS_SUB_PLUS;
    }

    @Override
    public void visitInternalNode(BSPTree<Sphere2D> bSPTree) {
        this.nodeToEdgesList.put(bSPTree, new ArrayList());
        BoundaryAttribute boundaryAttribute = (BoundaryAttribute)bSPTree.getAttribute();
        if (boundaryAttribute.getPlusOutside() != null) {
            this.addContribution((SubCircle)boundaryAttribute.getPlusOutside(), false, bSPTree);
        }
        if (boundaryAttribute.getPlusInside() != null) {
            this.addContribution((SubCircle)boundaryAttribute.getPlusInside(), true, bSPTree);
        }
    }

    @Override
    public void visitLeafNode(BSPTree<Sphere2D> bSPTree) {
    }

    private void addContribution(SubCircle iterator, boolean bl, BSPTree<Sphere2D> bSPTree) {
        Circle circle = (Circle)((AbstractSubHyperplane)((Object)iterator)).getHyperplane();
        iterator = ((ArcsSet)((AbstractSubHyperplane)((Object)iterator)).getRemainingRegion()).asList();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Vertex vertex = new Vertex((S2Point)circle.toSpace((Point)new S1Point(((Arc)object).getInf())));
            Vertex vertex2 = new Vertex((S2Point)circle.toSpace((Point)new S1Point(((Arc)object).getSup())));
            vertex.bindWith(circle);
            vertex2.bindWith(circle);
            object = bl ? new Edge(vertex2, vertex, ((Arc)object).getSize(), circle.getReverse()) : new Edge(vertex, vertex2, ((Arc)object).getSize(), circle);
            this.edgeToNode.put((Edge)object, bSPTree);
            this.nodeToEdgesList.get(bSPTree).add((Edge)object);
        }
    }

    private Edge getFollowingEdge(Edge edge) {
        S2Point s2Point = edge.getEnd().getLocation();
        Object object = this.root.getCloseCuts(s2Point, this.tolerance);
        double d2 = this.tolerance;
        Edge edge2 = null;
        object = object.iterator();
        while (object.hasNext()) {
            BSPTree bSPTree = (BSPTree)object.next();
            for (Edge edge3 : this.nodeToEdgesList.get(bSPTree)) {
                double d3;
                if (edge3 == edge || edge3.getStart().getIncoming() != null) continue;
                Vector3D vector3D = edge3.getStart().getLocation().getVector();
                double d4 = Vector3D.angle(s2Point.getVector(), vector3D);
                if (!(d3 <= d2)) continue;
                d2 = d4;
                edge2 = edge3;
            }
        }
        if (edge2 == null) {
            object = edge.getStart().getLocation().getVector();
            if (Vector3D.angle(s2Point.getVector(), (Vector3D)object) <= this.tolerance) {
                return edge;
            }
            throw new MathIllegalStateException(LocalizedFormats.OUTLINE_BOUNDARY_LOOP_OPEN, new Object[0]);
        }
        return edge2;
    }

    public List<Edge> getEdges() {
        for (Edge edge : this.edgeToNode.keySet()) {
            edge.setNextEdge(this.getFollowingEdge(edge));
        }
        return new ArrayList<Edge>(this.edgeToNode.keySet());
    }
}

