/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.Arc;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.Circle;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.S2Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.Vertex;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Edge {
    private final Vertex start;
    private Vertex end;
    private final double length;
    private final Circle circle;

    Edge(Vertex vertex, Vertex vertex2, double d2, Circle circle) {
        this.start = vertex;
        this.end = vertex2;
        this.length = d2;
        this.circle = circle;
        vertex.setOutgoing(this);
        vertex2.setIncoming(this);
    }

    public Vertex getStart() {
        return this.start;
    }

    public Vertex getEnd() {
        return this.end;
    }

    public double getLength() {
        return this.length;
    }

    public Circle getCircle() {
        return this.circle;
    }

    public Vector3D getPointAt(double d2) {
        return this.circle.getPointAt(d2 + this.circle.getPhase(this.start.getLocation().getVector()));
    }

    void setNextEdge(Edge edge) {
        this.end = edge.getStart();
        this.end.setIncoming(this);
        this.end.bindWith(this.getCircle());
    }

    void split(Circle circle, List<Edge> list, List<Edge> list2) {
        double d2 = this.circle.getPhase(this.start.getLocation().getVector());
        Object object = this.circle.getInsideArc(circle);
        double d3 = MathUtils.normalizeAngle(((Arc)object).getInf(), d2 + Math.PI) - d2;
        double d4 = d3 + ((Arc)object).getSize();
        double d5 = d4 - Math.PI * 2;
        double d6 = this.circle.getTolerance();
        object = this.start;
        if (d5 >= this.length - d6) {
            list2.add(this);
            return;
        }
        double d7 = 0.0;
        if (d5 >= 0.0) {
            object = this.addSubEdge((Vertex)object, new Vertex(new S2Point(this.circle.getPointAt(d2 + d5))), d5, list2, circle);
            d7 = d5;
        }
        if (d3 >= this.length - d6) {
            if (d5 >= 0.0) {
                this.addSubEdge((Vertex)object, this.end, this.length - d7, list, circle);
                return;
            }
            list.add(this);
            return;
        }
        object = this.addSubEdge((Vertex)object, new Vertex(new S2Point(this.circle.getPointAt(d2 + d3))), d3 - d7, list, circle);
        d7 = d3;
        if (d4 >= this.length - d6) {
            this.addSubEdge((Vertex)object, this.end, this.length - d7, list2, circle);
            return;
        }
        object = this.addSubEdge((Vertex)object, new Vertex(new S2Point(this.circle.getPointAt(d2 + d3))), d3 - d7, list2, circle);
        d7 = d3;
        this.addSubEdge((Vertex)object, this.end, this.length - d7, list, circle);
    }

    private Vertex addSubEdge(Vertex object, Vertex vertex, double d2, List<Edge> list, Circle circle) {
        if (d2 <= this.circle.getTolerance()) {
            return object;
        }
        vertex.bindWith(circle);
        object = new Edge((Vertex)object, vertex, d2, this.circle);
        list.add((Edge)object);
        return vertex;
    }
}

