/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Rotation;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Embedding;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Hyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Transform;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.Arc;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.ArcsSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.S1Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.Sphere1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.Circle$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.Circle$CircleTransform;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.S2Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.Sphere2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.SphericalPolygonsSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.twod.SubCircle;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Circle
implements Embedding<Sphere2D, Sphere1D>,
Hyperplane<Sphere2D> {
    private Vector3D pole;
    private Vector3D x;
    private Vector3D y;
    private final double tolerance;

    public Circle(Vector3D vector3D, double d2) {
        this.reset(vector3D);
        this.tolerance = d2;
    }

    public Circle(S2Point s2Point, S2Point s2Point2, double d2) {
        this.reset(s2Point.getVector().crossProduct(s2Point2.getVector()));
        this.tolerance = d2;
    }

    private Circle(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, double d2) {
        this.pole = vector3D;
        this.x = vector3D2;
        this.y = vector3D3;
        this.tolerance = d2;
    }

    public Circle(Circle circle) {
        this(circle.pole, circle.x, circle.y, circle.tolerance);
    }

    public Circle copySelf() {
        return new Circle(this);
    }

    public void reset(Vector3D vector3D) {
        this.pole = vector3D.normalize();
        this.x = vector3D.orthogonal();
        this.y = Vector3D.crossProduct(vector3D, this.x).normalize();
    }

    public void revertSelf() {
        this.y = this.y.negate();
        this.pole = this.pole.negate();
    }

    public Circle getReverse() {
        return new Circle(this.pole.negate(), this.x, this.y.negate(), this.tolerance);
    }

    @Override
    public Point<Sphere2D> project(Point<Sphere2D> point) {
        Circle circle = this;
        return circle.toSpace(circle.toSubSpace((Point)point));
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    public S1Point toSubSpace(Point<Sphere2D> point) {
        return new S1Point(this.getPhase(((S2Point)point).getVector()));
    }

    public double getPhase(Vector3D vector3D) {
        return Math.PI + FastMath.atan2(-vector3D.dotProduct(this.y), -vector3D.dotProduct(this.x));
    }

    public S2Point toSpace(Point<Sphere1D> point) {
        return new S2Point(this.getPointAt(((S1Point)point).getAlpha()));
    }

    public Vector3D getPointAt(double d2) {
        return new Vector3D(FastMath.cos(d2), this.x, FastMath.sin(d2), this.y);
    }

    public Vector3D getXAxis() {
        return this.x;
    }

    public Vector3D getYAxis() {
        return this.y;
    }

    public Vector3D getPole() {
        return this.pole;
    }

    public Arc getInsideArc(Circle circle) {
        double d2 = this.getPhase(circle.pole);
        return new Arc(d2 - 1.5707963267948966, d2 + 1.5707963267948966, this.tolerance);
    }

    public SubCircle wholeHyperplane() {
        return new SubCircle(this, new ArcsSet(this.tolerance));
    }

    public SphericalPolygonsSet wholeSpace() {
        return new SphericalPolygonsSet(this.tolerance);
    }

    @Override
    public double getOffset(Point<Sphere2D> point) {
        return this.getOffset(((S2Point)point).getVector());
    }

    public double getOffset(Vector3D vector3D) {
        return Vector3D.angle(this.pole, vector3D) - 1.5707963267948966;
    }

    @Override
    public boolean sameOrientationAs(Hyperplane<Sphere2D> circle) {
        circle = circle;
        return Vector3D.dotProduct(this.pole, circle.pole) >= 0.0;
    }

    public static Transform<Sphere2D, Sphere1D> getTransform(Rotation rotation) {
        return new Circle$CircleTransform(rotation);
    }

    static /* synthetic */ Vector3D access$000(Circle circle) {
        return circle.pole;
    }

    static /* synthetic */ Vector3D access$100(Circle circle) {
        return circle.x;
    }

    static /* synthetic */ Vector3D access$200(Circle circle) {
        return circle.y;
    }

    static /* synthetic */ double access$300(Circle circle) {
        return circle.tolerance;
    }

    /* synthetic */ Circle(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, double d2, Circle$1 circle$1) {
        this(vector3D, vector3D2, vector3D3, d2);
    }
}

