/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Space;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.Sphere1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S1Point
implements Point<Sphere1D> {
    public static final S1Point NaN = new S1Point(Double.NaN, Vector2D.NaN);
    private static final long serialVersionUID = 20131218L;
    private final double alpha;
    private final Vector2D vector;

    public S1Point(double d2) {
        this(MathUtils.normalizeAngle(d2, Math.PI), new Vector2D(FastMath.cos(d2), FastMath.sin(d2)));
    }

    private S1Point(double d2, Vector2D vector2D) {
        this.alpha = d2;
        this.vector = vector2D;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public Vector2D getVector() {
        return this.vector;
    }

    @Override
    public Space getSpace() {
        return Sphere1D.getInstance();
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.alpha);
    }

    @Override
    public double distance(Point<Sphere1D> point) {
        return S1Point.distance(this, (S1Point)point);
    }

    public static double distance(S1Point s1Point, S1Point s1Point2) {
        return Vector2D.angle(s1Point.vector, s1Point2.vector);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof S1Point) {
            if (((S1Point)(object = (S1Point)object)).isNaN()) {
                return this.isNaN();
            }
            return this.alpha == ((S1Point)object).alpha;
        }
        return false;
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 542;
        }
        return 1759 * MathUtils.hash(this.alpha);
    }
}

