/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Hyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.ArcsSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.S1Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.Sphere1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.SubLimitAngle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitAngle
implements Hyperplane<Sphere1D> {
    private S1Point location;
    private boolean direct;
    private final double tolerance;

    public LimitAngle(S1Point s1Point, boolean bl, double d2) {
        this.location = s1Point;
        this.direct = bl;
        this.tolerance = d2;
    }

    public LimitAngle copySelf() {
        return this;
    }

    @Override
    public double getOffset(Point<Sphere1D> point) {
        double d2 = ((S1Point)point).getAlpha() - this.location.getAlpha();
        if (this.direct) {
            return d2;
        }
        return -d2;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public LimitAngle getReverse() {
        return new LimitAngle(this.location, !this.direct, this.tolerance);
    }

    public SubLimitAngle wholeHyperplane() {
        return new SubLimitAngle(this, null);
    }

    public ArcsSet wholeSpace() {
        return new ArcsSet(this.tolerance);
    }

    @Override
    public boolean sameOrientationAs(Hyperplane<Sphere1D> hyperplane) {
        return !(this.direct ^ ((LimitAngle)hyperplane).direct);
    }

    public S1Point getLocation() {
        return this.location;
    }

    @Override
    public Point<Sphere1D> project(Point<Sphere1D> point) {
        return this.location;
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }
}

