/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.AbstractRegion;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTree;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BoundaryProjection;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Side;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.Arc;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.ArcsSet$InconsistentStateAt2PiWrapping;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.ArcsSet$Split;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.ArcsSet$SubArcsIterator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.LimitAngle;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.S1Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.Sphere1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned.SubLimitAngle;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArcsSet
extends AbstractRegion<Sphere1D, Sphere1D>
implements Iterable<double[]> {
    public ArcsSet(double d2) {
        super(d2);
    }

    public ArcsSet(double d2, double d3, double d4) {
        super(ArcsSet.buildTree(d2, d3, d4), d4);
    }

    public ArcsSet(BSPTree<Sphere1D> bSPTree, double d2) {
        super(bSPTree, d2);
        this.check2PiConsistency();
    }

    public ArcsSet(Collection<SubHyperplane<Sphere1D>> collection, double d2) {
        super(collection, d2);
        this.check2PiConsistency();
    }

    private static BSPTree<Sphere1D> buildTree(double d2, double d3, double d4) {
        if (Precision.equals(d2, d3, 0) || d3 - d2 >= Math.PI * 2) {
            return new BSPTree<Sphere1D>(Boolean.TRUE);
        }
        if (d2 > d3) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.ENDPOINTS_NOT_AN_INTERVAL, (Number)d2, d3, true);
        }
        double d5 = MathUtils.normalizeAngle(d2, Math.PI);
        double d6 = d5 + (d3 - d2);
        SubLimitAngle subLimitAngle = new LimitAngle(new S1Point(d5), false, d4).wholeHyperplane();
        if (d6 <= Math.PI * 2) {
            SubLimitAngle subLimitAngle2 = new LimitAngle(new S1Point(d6), true, d4).wholeHyperplane();
            return new BSPTree<Sphere1D>(subLimitAngle, new BSPTree(Boolean.FALSE), new BSPTree<Sphere1D>(subLimitAngle2, new BSPTree(Boolean.FALSE), new BSPTree(Boolean.TRUE), null), null);
        }
        SubLimitAngle subLimitAngle3 = new LimitAngle(new S1Point(d6 - Math.PI * 2), true, d4).wholeHyperplane();
        return new BSPTree<Sphere1D>(subLimitAngle, new BSPTree<Sphere1D>(subLimitAngle3, new BSPTree(Boolean.FALSE), new BSPTree(Boolean.TRUE), null), new BSPTree(Boolean.TRUE), null);
    }

    private void check2PiConsistency() {
        BSPTree<Sphere1D> bSPTree = this.getTree(false);
        if (bSPTree.getCut() == null) {
            return;
        }
        Boolean bl = (Boolean)this.getFirstLeaf(bSPTree).getAttribute();
        bSPTree = (Boolean)this.getLastLeaf(bSPTree).getAttribute();
        if (bl ^ (Boolean)((Object)bSPTree)) {
            throw new ArcsSet$InconsistentStateAt2PiWrapping();
        }
    }

    private BSPTree<Sphere1D> getFirstLeaf(BSPTree<Sphere1D> bSPTree) {
        if (bSPTree.getCut() == null) {
            return bSPTree;
        }
        BSPTree<Sphere1D> bSPTree2 = null;
        while (bSPTree != null) {
            bSPTree2 = bSPTree;
            bSPTree = this.previousInternalNode(bSPTree);
        }
        return this.leafBefore(bSPTree2);
    }

    private BSPTree<Sphere1D> getLastLeaf(BSPTree<Sphere1D> bSPTree) {
        if (bSPTree.getCut() == null) {
            return bSPTree;
        }
        BSPTree<Sphere1D> bSPTree2 = null;
        while (bSPTree != null) {
            bSPTree2 = bSPTree;
            bSPTree = this.nextInternalNode(bSPTree);
        }
        return this.leafAfter(bSPTree2);
    }

    private BSPTree<Sphere1D> getFirstArcStart() {
        BSPTree<Sphere1D> bSPTree = this.getTree(false);
        if (bSPTree.getCut() == null) {
            return null;
        }
        bSPTree = this.getFirstLeaf(bSPTree).getParent();
        while (bSPTree != null && !this.isArcStart(bSPTree)) {
            bSPTree = this.nextInternalNode(bSPTree);
        }
        return bSPTree;
    }

    private boolean isArcStart(BSPTree<Sphere1D> bSPTree) {
        if (((Boolean)this.leafBefore(bSPTree).getAttribute()).booleanValue()) {
            return false;
        }
        return (Boolean)this.leafAfter(bSPTree).getAttribute() != false;
    }

    private boolean isArcEnd(BSPTree<Sphere1D> bSPTree) {
        if (!((Boolean)this.leafBefore(bSPTree).getAttribute()).booleanValue()) {
            return false;
        }
        return (Boolean)this.leafAfter(bSPTree).getAttribute() == false;
    }

    private BSPTree<Sphere1D> nextInternalNode(BSPTree<Sphere1D> bSPTree) {
        if (this.childAfter(bSPTree).getCut() != null) {
            return this.leafAfter(bSPTree).getParent();
        }
        while (this.isAfterParent(bSPTree)) {
            bSPTree = bSPTree.getParent();
        }
        return bSPTree.getParent();
    }

    private BSPTree<Sphere1D> previousInternalNode(BSPTree<Sphere1D> bSPTree) {
        if (this.childBefore(bSPTree).getCut() != null) {
            return this.leafBefore(bSPTree).getParent();
        }
        while (this.isBeforeParent(bSPTree)) {
            bSPTree = bSPTree.getParent();
        }
        return bSPTree.getParent();
    }

    private BSPTree<Sphere1D> leafBefore(BSPTree<Sphere1D> bSPTree) {
        bSPTree = this.childBefore(bSPTree);
        while (bSPTree.getCut() != null) {
            bSPTree = this.childAfter(bSPTree);
        }
        return bSPTree;
    }

    private BSPTree<Sphere1D> leafAfter(BSPTree<Sphere1D> bSPTree) {
        bSPTree = this.childAfter(bSPTree);
        while (bSPTree.getCut() != null) {
            bSPTree = this.childBefore(bSPTree);
        }
        return bSPTree;
    }

    private boolean isBeforeParent(BSPTree<Sphere1D> bSPTree) {
        BSPTree<Sphere1D> bSPTree2 = bSPTree.getParent();
        if (bSPTree2 == null) {
            return false;
        }
        return bSPTree == this.childBefore(bSPTree2);
    }

    private boolean isAfterParent(BSPTree<Sphere1D> bSPTree) {
        BSPTree<Sphere1D> bSPTree2 = bSPTree.getParent();
        if (bSPTree2 == null) {
            return false;
        }
        return bSPTree == this.childAfter(bSPTree2);
    }

    private BSPTree<Sphere1D> childBefore(BSPTree<Sphere1D> bSPTree) {
        if (this.isDirect(bSPTree)) {
            return bSPTree.getMinus();
        }
        return bSPTree.getPlus();
    }

    private BSPTree<Sphere1D> childAfter(BSPTree<Sphere1D> bSPTree) {
        if (this.isDirect(bSPTree)) {
            return bSPTree.getPlus();
        }
        return bSPTree.getMinus();
    }

    private boolean isDirect(BSPTree<Sphere1D> bSPTree) {
        return ((LimitAngle)bSPTree.getCut().getHyperplane()).isDirect();
    }

    private double getAngle(BSPTree<Sphere1D> bSPTree) {
        return ((LimitAngle)bSPTree.getCut().getHyperplane()).getLocation().getAlpha();
    }

    public ArcsSet buildNew(BSPTree<Sphere1D> bSPTree) {
        return new ArcsSet(bSPTree, this.getTolerance());
    }

    @Override
    protected void computeGeometricalProperties() {
        if (this.getTree(false).getCut() == null) {
            this.setBarycenter(S1Point.NaN);
            ArcsSet arcsSet = this;
            arcsSet.setSize((Boolean)arcsSet.getTree(false).getAttribute() != false ? Math.PI * 2 : 0.0);
            return;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        for (double[] dArray : this) {
            double d4 = dArray[1] - dArray[0];
            d2 += d4;
            d3 += d4 * (dArray[0] + dArray[1]);
        }
        this.setSize(d2);
        if (Precision.equals(d2, Math.PI * 2, 0)) {
            this.setBarycenter(S1Point.NaN);
            return;
        }
        if (d2 >= Precision.SAFE_MIN) {
            this.setBarycenter(new S1Point(d3 / (d2 * 2.0)));
            return;
        }
        LimitAngle limitAngle = (LimitAngle)this.getTree(false).getCut().getHyperplane();
        this.setBarycenter(limitAngle.getLocation());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public BoundaryProjection<Sphere1D> projectToBoundary(Point<Sphere1D> point) {
        double d2 = ((S1Point)point).getAlpha();
        boolean bl = false;
        double d3 = Double.NaN;
        double d4 = Double.NaN;
        for (double[] dArray : this) {
            block13: {
                if (Double.isNaN(d3)) {
                    d3 = dArray[0];
                }
                if (!bl) {
                    if (d2 < dArray[0]) {
                        if (Double.isNaN(d4)) {
                            bl = true;
                            break block13;
                        } else {
                            double d5 = d2 - d4;
                            double d6 = dArray[0] - d2;
                            if (d5 < d6) {
                                return new BoundaryProjection<Sphere1D>(point, new S1Point(d4), d5);
                            }
                            return new BoundaryProjection<Sphere1D>(point, new S1Point(dArray[0]), d6);
                        }
                    }
                    if (d2 <= dArray[1]) {
                        double d7 = dArray[0] - d2;
                        double d8 = d2 - dArray[1];
                        if (d7 < d8) {
                            return new BoundaryProjection<Sphere1D>(point, new S1Point(dArray[1]), d8);
                        }
                        return new BoundaryProjection<Sphere1D>(point, new S1Point(dArray[0]), d7);
                    }
                }
            }
            d4 = dArray[1];
        }
        if (Double.isNaN(d4)) {
            return new BoundaryProjection<Sphere1D>(point, null, Math.PI * 2);
        }
        if (bl) {
            double d9 = d2 - (d4 - Math.PI * 2);
            double d10 = d3 - d2;
            if (d9 < d10) {
                return new BoundaryProjection<Sphere1D>(point, new S1Point(d4), d9);
            }
            return new BoundaryProjection<Sphere1D>(point, new S1Point(d3), d10);
        }
        double d11 = d2 - d4;
        double d12 = d3 + Math.PI * 2 - d2;
        if (d11 < d12) {
            return new BoundaryProjection<Sphere1D>(point, new S1Point(d4), d11);
        }
        return new BoundaryProjection<Sphere1D>(point, new S1Point(d3), d12);
    }

    public List<Arc> asList() {
        ArrayList<Arc> arrayList = new ArrayList<Arc>();
        for (double[] dArray : this) {
            arrayList.add(new Arc(dArray[0], dArray[1], this.getTolerance()));
        }
        return arrayList;
    }

    @Override
    public Iterator<double[]> iterator() {
        return new ArcsSet$SubArcsIterator(this);
    }

    @Deprecated
    public Side side(Arc arc) {
        return this.split(arc).getSide();
    }

    public ArcsSet$Split split(Arc arc) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        double d2 = Math.PI + arc.getInf();
        double d3 = arc.getSup() - arc.getInf();
        for (double[] dArray : this) {
            double d4;
            double d5;
            double d6 = MathUtils.normalizeAngle(dArray[0], d2) - arc.getInf();
            double d7 = dArray[0] - d6;
            double d8 = dArray[1] - d7;
            if (d6 < d3) {
                arrayList.add(dArray[0]);
                if (d8 > d3) {
                    d5 = d3 + d7;
                    arrayList.add(d5);
                    arrayList2.add(d5);
                    if (d8 > Math.PI * 2) {
                        d4 = d7 + Math.PI * 2;
                        arrayList2.add(d4);
                        arrayList.add(d4);
                        arrayList.add(dArray[1]);
                        continue;
                    }
                    arrayList2.add(dArray[1]);
                    continue;
                }
                arrayList.add(dArray[1]);
                continue;
            }
            arrayList2.add(dArray[0]);
            if (d8 > Math.PI * 2) {
                d5 = d7 + Math.PI * 2;
                arrayList2.add(d5);
                arrayList.add(d5);
                if (d8 > d3 + Math.PI * 2) {
                    d4 = d3 + Math.PI * 2 + d7;
                    arrayList.add(d4);
                    arrayList2.add(d4);
                    arrayList2.add(dArray[1]);
                    continue;
                }
                arrayList.add(dArray[1]);
                continue;
            }
            arrayList2.add(dArray[1]);
        }
        return new ArcsSet$Split(this.createSplitPart(arrayList2), this.createSplitPart(arrayList), null);
    }

    private void addArcLimit(BSPTree<Sphere1D> bSPTree, double d2, boolean bl) {
        LimitAngle limitAngle = new LimitAngle(new S1Point(d2), !bl, this.getTolerance());
        if ((bSPTree = bSPTree.getCell(limitAngle.getLocation(), this.getTolerance())).getCut() != null) {
            throw new MathInternalError();
        }
        bSPTree.insertCut(limitAngle);
        bSPTree.setAttribute(null);
        bSPTree.getPlus().setAttribute(Boolean.FALSE);
        bSPTree.getMinus().setAttribute(Boolean.TRUE);
    }

    private ArcsSet createSplitPart(List<Double> list) {
        int n;
        if (list.isEmpty()) {
            return null;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            double d2;
            n = (i2 + 1) % list.size();
            double d3 = list.get(i2);
            double d4 = MathUtils.normalizeAngle(list.get(n), d3);
            if (!(FastMath.abs(d2 - d3) <= this.getTolerance())) continue;
            if (n > 0) {
                list.remove(n);
                list.remove(i2);
                --i2;
                continue;
            }
            List<Double> list2 = list;
            double d5 = list2.remove(list2.size() - 1);
            double d6 = list.remove(0);
            if (list.isEmpty()) {
                if (d5 - d6 > Math.PI) {
                    return new ArcsSet(new BSPTree<Sphere1D>(Boolean.TRUE), this.getTolerance());
                }
                return null;
            }
            List<Double> list3 = list;
            list3.add(list3.remove(0) + Math.PI * 2);
        }
        BSPTree<Sphere1D> bSPTree = new BSPTree<Sphere1D>(Boolean.FALSE);
        for (n = 0; n < list.size() - 1; n += 2) {
            this.addArcLimit(bSPTree, list.get(n), true);
            this.addArcLimit(bSPTree, list.get(n + 1), false);
        }
        if (bSPTree.getCut() == null) {
            return null;
        }
        return new ArcsSet(bSPTree, this.getTolerance());
    }

    static /* synthetic */ BSPTree access$000(ArcsSet arcsSet) {
        return arcsSet.getFirstArcStart();
    }

    static /* synthetic */ BSPTree access$100(ArcsSet arcsSet, BSPTree bSPTree) {
        return arcsSet.getFirstLeaf(bSPTree);
    }

    static /* synthetic */ boolean access$200(ArcsSet arcsSet, BSPTree bSPTree) {
        return arcsSet.isArcStart(bSPTree);
    }

    static /* synthetic */ BSPTree access$300(ArcsSet arcsSet, BSPTree bSPTree) {
        return arcsSet.nextInternalNode(bSPTree);
    }

    static /* synthetic */ boolean access$400(ArcsSet arcsSet, BSPTree bSPTree) {
        return arcsSet.isArcEnd(bSPTree);
    }

    static /* synthetic */ double access$500(ArcsSet arcsSet, BSPTree bSPTree) {
        return arcsSet.getAngle(bSPTree);
    }

    static /* synthetic */ BSPTree access$600(ArcsSet arcsSet, BSPTree bSPTree) {
        return arcsSet.previousInternalNode(bSPTree);
    }
}

