/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.spherical.oned;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Region$Location;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;

public class Arc {
    private final double lower;
    private final double upper;
    private final double middle;
    private final double tolerance;

    public Arc(double d2, double d3, double d4) {
        this.tolerance = d4;
        if (Precision.equals(d2, d3, 0) || d3 - d2 >= Math.PI * 2) {
            this.lower = 0.0;
            this.upper = Math.PI * 2;
            this.middle = Math.PI;
            return;
        }
        if (d2 <= d3) {
            this.lower = MathUtils.normalizeAngle(d2, Math.PI);
            this.upper = this.lower + (d3 - d2);
            this.middle = 0.5 * (this.lower + this.upper);
            return;
        }
        throw new NumberIsTooLargeException((Localizable)LocalizedFormats.ENDPOINTS_NOT_AN_INTERVAL, (Number)d2, d3, true);
    }

    public double getInf() {
        return this.lower;
    }

    public double getSup() {
        return this.upper;
    }

    public double getSize() {
        return this.upper - this.lower;
    }

    public double getBarycenter() {
        return this.middle;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public Region$Location checkPoint(double d2) {
        double d3 = MathUtils.normalizeAngle(d2, this.middle);
        if (d3 < this.lower - this.tolerance || d3 > this.upper + this.tolerance) {
            return Region$Location.OUTSIDE;
        }
        if (d3 > this.lower + this.tolerance && d3 < this.upper - this.tolerance) {
            return Region$Location.INSIDE;
        }
        if (this.getSize() >= Math.PI * 2 - this.tolerance) {
            return Region$Location.INSIDE;
        }
        return Region$Location.BOUNDARY;
    }
}

