/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.utilities;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class OrderedTuple
implements Comparable<OrderedTuple> {
    private static final long SIGN_MASK = Long.MIN_VALUE;
    private static final long EXPONENT_MASK = 0x7FF0000000000000L;
    private static final long MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final long IMPLICIT_ONE = 0x10000000000000L;
    private double[] components;
    private int offset;
    private int lsb;
    private long[] encoding;
    private boolean posInf;
    private boolean negInf;
    private boolean nan;

    public OrderedTuple(double ... dArray) {
        this.components = (double[])dArray.clone();
        int n = Integer.MIN_VALUE;
        this.lsb = Integer.MAX_VALUE;
        this.posInf = false;
        this.negInf = false;
        this.nan = false;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (Double.isInfinite(dArray[i2])) {
                if (dArray[i2] < 0.0) {
                    this.negInf = true;
                    continue;
                }
                this.posInf = true;
                continue;
            }
            if (Double.isNaN(dArray[i2])) {
                this.nan = true;
                continue;
            }
            long l = Double.doubleToLongBits(dArray[i2]);
            long l2 = OrderedTuple.mantissa(l);
            if (l2 == 0L) continue;
            int n2 = OrderedTuple.exponent(l);
            n = FastMath.max(n, n2 + OrderedTuple.computeMSB(l2));
            this.lsb = FastMath.min(this.lsb, n2 + OrderedTuple.computeLSB(l2));
        }
        if (this.posInf && this.negInf) {
            this.posInf = false;
            this.negInf = false;
            this.nan = true;
        }
        if (this.lsb <= n) {
            this.encode(n + 16);
            return;
        }
        this.encoding = new long[]{0L};
    }

    private void encode(int n) {
        this.offset = n + 31;
        this.offset -= this.offset % 32;
        if (this.encoding != null && this.encoding.length == 1 && this.encoding[0] == 0L) {
            return;
        }
        n = this.offset + 1 - this.lsb;
        n = (n + 62) / 63;
        this.encoding = new long[this.components.length * n];
        n = 0;
        int n2 = 62;
        long l = 0L;
        int n3 = this.offset;
        while (n < this.encoding.length) {
            for (int i2 = 0; i2 < this.components.length; ++i2) {
                if (this.getBit(i2, n3) != 0) {
                    l |= 1L << n2;
                }
                if (n2-- != 0) continue;
                this.encoding[n++] = l;
                l = 0L;
                n2 = 62;
            }
            --n3;
        }
    }

    @Override
    public int compareTo(OrderedTuple orderedTuple) {
        if (this.components.length == orderedTuple.components.length) {
            if (this.nan) {
                return 1;
            }
            if (orderedTuple.nan) {
                return -1;
            }
            if (this.negInf || orderedTuple.posInf) {
                return -1;
            }
            if (this.posInf || orderedTuple.negInf) {
                return 1;
            }
            if (this.offset < orderedTuple.offset) {
                this.encode(orderedTuple.offset);
            } else if (this.offset > orderedTuple.offset) {
                orderedTuple.encode(this.offset);
            }
            int n = FastMath.min(this.encoding.length, orderedTuple.encoding.length);
            for (int i2 = 0; i2 < n; ++i2) {
                if (this.encoding[i2] < orderedTuple.encoding[i2]) {
                    return -1;
                }
                if (this.encoding[i2] <= orderedTuple.encoding[i2]) continue;
                return 1;
            }
            if (this.encoding.length < orderedTuple.encoding.length) {
                return -1;
            }
            if (this.encoding.length > orderedTuple.encoding.length) {
                return 1;
            }
            return 0;
        }
        return this.components.length - orderedTuple.components.length;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof OrderedTuple) {
            return this.compareTo((OrderedTuple)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        int n = Arrays.hashCode(this.components);
        n = n * 37 + this.offset;
        n = n * 37 + this.lsb;
        n = n * 37 + (this.posInf ? 97 : 71);
        n = n * 37 + (this.negInf ? 97 : 71);
        n = n * 37 + (this.nan ? 97 : 71);
        return n;
    }

    public double[] getComponents() {
        return (double[])this.components.clone();
    }

    private static long sign(long l) {
        return l & Long.MIN_VALUE;
    }

    private static int exponent(long l) {
        return (int)((l & 0x7FF0000000000000L) >> 52) - 1075;
    }

    private static long mantissa(long l) {
        if ((l & 0x7FF0000000000000L) == 0L) {
            return (l & 0xFFFFFFFFFFFFFL) << 1;
        }
        return 0x10000000000000L | l & 0xFFFFFFFFFFFFFL;
    }

    private static int computeMSB(long l) {
        long l2 = l;
        long l3 = 0xFFFFFFFFL;
        int n = 32;
        int n2 = 0;
        while (n != 0) {
            if ((l2 & l3) != l2) {
                n2 |= n;
                l2 >>= n;
            }
            l3 >>= (n >>= 1);
        }
        return n2;
    }

    private static int computeLSB(long l) {
        long l2 = l;
        long l3 = -4294967296L;
        int n = 32;
        int n2 = 0;
        while (n != 0) {
            if ((l2 & l3) == l2) {
                n2 |= n;
                l2 >>= n;
            }
            l3 >>= (n >>= 1);
        }
        return n2;
    }

    private int getBit(int n, int n2) {
        long l = Double.doubleToLongBits(this.components[n]);
        if (n2 < (n = OrderedTuple.exponent(l)) || n2 > this.offset) {
            return 0;
        }
        if (n2 == this.offset) {
            if (OrderedTuple.sign(l) == 0L) {
                return 1;
            }
            return 0;
        }
        if (n2 > n + 52) {
            if (OrderedTuple.sign(l) == 0L) {
                return 0;
            }
            return 1;
        }
        long l2 = OrderedTuple.sign(l) == 0L ? OrderedTuple.mantissa(l) : -OrderedTuple.mantissa(l);
        return (int)(l2 >> n2 - n & 1L);
    }
}

