/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.utilities;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.utilities.AVLTree;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.utilities.AVLTree$Skew;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVLTree$Node {
    private T element;
    private AVLTree$Node left;
    private AVLTree$Node right;
    private AVLTree$Node parent;
    private AVLTree$Skew skew;
    final /* synthetic */ AVLTree this$0;

    AVLTree$Node(T t, AVLTree$Node aVLTree$Node) {
        this.this$0 = var1_1;
        this.element = t;
        this.left = null;
        this.right = null;
        this.parent = aVLTree$Node;
        this.skew = AVLTree$Skew.BALANCED;
    }

    public T getElement() {
        return this.element;
    }

    int size() {
        return 1 + (this.left == null ? 0 : this.left.size()) + (this.right == null ? 0 : this.right.size());
    }

    AVLTree$Node getSmallest() {
        AVLTree$Node aVLTree$Node = this;
        while (aVLTree$Node.left != null) {
            aVLTree$Node = aVLTree$Node.left;
        }
        return aVLTree$Node;
    }

    AVLTree$Node getLargest() {
        AVLTree$Node aVLTree$Node = this;
        while (aVLTree$Node.right != null) {
            aVLTree$Node = aVLTree$Node.right;
        }
        return aVLTree$Node;
    }

    public AVLTree$Node getPrevious() {
        AVLTree$Node aVLTree$Node;
        if (this.left != null && (aVLTree$Node = this.left.getLargest()) != null) {
            return aVLTree$Node;
        }
        aVLTree$Node = this;
        while (aVLTree$Node.parent != null) {
            AVLTree$Node aVLTree$Node2 = aVLTree$Node;
            if (aVLTree$Node2 != aVLTree$Node2.parent.left) {
                return aVLTree$Node.parent;
            }
            aVLTree$Node = aVLTree$Node.parent;
        }
        return null;
    }

    public AVLTree$Node getNext() {
        AVLTree$Node aVLTree$Node;
        if (this.right != null && (aVLTree$Node = this.right.getSmallest()) != null) {
            return aVLTree$Node;
        }
        aVLTree$Node = this;
        while (aVLTree$Node.parent != null) {
            AVLTree$Node aVLTree$Node2 = aVLTree$Node;
            if (aVLTree$Node2 != aVLTree$Node2.parent.right) {
                return aVLTree$Node.parent;
            }
            aVLTree$Node = aVLTree$Node.parent;
        }
        return null;
    }

    boolean insert(T t) {
        if (t.compareTo(this.element) < 0) {
            if (this.left == null) {
                this.left = new AVLTree$Node(this.this$0, t, this);
                return this.rebalanceLeftGrown();
            }
            if (this.left.insert(t)) {
                return this.rebalanceLeftGrown();
            }
            return false;
        }
        if (this.right == null) {
            this.right = new AVLTree$Node(this.this$0, t, this);
            return this.rebalanceRightGrown();
        }
        if (this.right.insert(t)) {
            return this.rebalanceRightGrown();
        }
        return false;
    }

    public void delete() {
        AVLTree$Node aVLTree$Node;
        boolean bl;
        AVLTree$Node aVLTree$Node2;
        if (this.parent == null && this.left == null && this.right == null) {
            this.element = null;
            AVLTree.access$302(this.this$0, null);
            return;
        }
        if (this.left == null && this.right == null) {
            aVLTree$Node2 = this;
            this.element = null;
            AVLTree$Node aVLTree$Node3 = aVLTree$Node2;
            bl = aVLTree$Node3 == aVLTree$Node3.parent.left;
            aVLTree$Node = null;
        } else {
            aVLTree$Node2 = this.left != null ? this.left.getLargest() : this.right.getSmallest();
            this.element = aVLTree$Node2.element;
            AVLTree$Node aVLTree$Node4 = aVLTree$Node2;
            bl = aVLTree$Node4 == aVLTree$Node4.parent.left;
            aVLTree$Node = aVLTree$Node2.left != null ? aVLTree$Node2.left : aVLTree$Node2.right;
        }
        AVLTree$Node aVLTree$Node5 = aVLTree$Node;
        aVLTree$Node2 = aVLTree$Node2.parent;
        if (bl) {
            aVLTree$Node2.left = aVLTree$Node5;
        } else {
            aVLTree$Node2.right = aVLTree$Node5;
        }
        if (aVLTree$Node5 != null) {
            aVLTree$Node5.parent = aVLTree$Node2;
        }
        while (bl ? aVLTree$Node2.rebalanceLeftShrunk() : aVLTree$Node2.rebalanceRightShrunk()) {
            if (aVLTree$Node2.parent == null) {
                return;
            }
            AVLTree$Node aVLTree$Node6 = aVLTree$Node2;
            bl = aVLTree$Node6 == aVLTree$Node6.parent.left;
            aVLTree$Node2 = aVLTree$Node2.parent;
        }
    }

    private boolean rebalanceLeftGrown() {
        switch (this.skew) {
            case LEFT_HIGH: {
                if (this.left.skew == AVLTree$Skew.LEFT_HIGH) {
                    this.rotateCW();
                    this.skew = AVLTree$Skew.BALANCED;
                    this.right.skew = AVLTree$Skew.BALANCED;
                } else {
                    AVLTree$Skew aVLTree$Skew = this.left.right.skew;
                    this.left.rotateCCW();
                    this.rotateCW();
                    switch (aVLTree$Skew) {
                        case LEFT_HIGH: {
                            this.left.skew = AVLTree$Skew.BALANCED;
                            this.right.skew = AVLTree$Skew.RIGHT_HIGH;
                            break;
                        }
                        case RIGHT_HIGH: {
                            this.left.skew = AVLTree$Skew.LEFT_HIGH;
                            this.right.skew = AVLTree$Skew.BALANCED;
                            break;
                        }
                        default: {
                            this.left.skew = AVLTree$Skew.BALANCED;
                            this.right.skew = AVLTree$Skew.BALANCED;
                        }
                    }
                    this.skew = AVLTree$Skew.BALANCED;
                }
                return false;
            }
            case RIGHT_HIGH: {
                this.skew = AVLTree$Skew.BALANCED;
                return false;
            }
        }
        this.skew = AVLTree$Skew.LEFT_HIGH;
        return true;
    }

    private boolean rebalanceRightGrown() {
        switch (this.skew) {
            case LEFT_HIGH: {
                this.skew = AVLTree$Skew.BALANCED;
                return false;
            }
            case RIGHT_HIGH: {
                if (this.right.skew == AVLTree$Skew.RIGHT_HIGH) {
                    this.rotateCCW();
                    this.skew = AVLTree$Skew.BALANCED;
                    this.left.skew = AVLTree$Skew.BALANCED;
                } else {
                    AVLTree$Skew aVLTree$Skew = this.right.left.skew;
                    this.right.rotateCW();
                    this.rotateCCW();
                    switch (aVLTree$Skew) {
                        case LEFT_HIGH: {
                            this.left.skew = AVLTree$Skew.BALANCED;
                            this.right.skew = AVLTree$Skew.RIGHT_HIGH;
                            break;
                        }
                        case RIGHT_HIGH: {
                            this.left.skew = AVLTree$Skew.LEFT_HIGH;
                            this.right.skew = AVLTree$Skew.BALANCED;
                            break;
                        }
                        default: {
                            this.left.skew = AVLTree$Skew.BALANCED;
                            this.right.skew = AVLTree$Skew.BALANCED;
                        }
                    }
                    this.skew = AVLTree$Skew.BALANCED;
                }
                return false;
            }
        }
        this.skew = AVLTree$Skew.RIGHT_HIGH;
        return true;
    }

    private boolean rebalanceLeftShrunk() {
        switch (this.skew) {
            case LEFT_HIGH: {
                this.skew = AVLTree$Skew.BALANCED;
                return true;
            }
            case RIGHT_HIGH: {
                if (this.right.skew == AVLTree$Skew.RIGHT_HIGH) {
                    this.rotateCCW();
                    this.skew = AVLTree$Skew.BALANCED;
                    this.left.skew = AVLTree$Skew.BALANCED;
                    return true;
                }
                if (this.right.skew == AVLTree$Skew.BALANCED) {
                    this.rotateCCW();
                    this.skew = AVLTree$Skew.LEFT_HIGH;
                    this.left.skew = AVLTree$Skew.RIGHT_HIGH;
                    return false;
                }
                AVLTree$Skew aVLTree$Skew = this.right.left.skew;
                this.right.rotateCW();
                this.rotateCCW();
                switch (aVLTree$Skew) {
                    case LEFT_HIGH: {
                        this.left.skew = AVLTree$Skew.BALANCED;
                        this.right.skew = AVLTree$Skew.RIGHT_HIGH;
                        break;
                    }
                    case RIGHT_HIGH: {
                        this.left.skew = AVLTree$Skew.LEFT_HIGH;
                        this.right.skew = AVLTree$Skew.BALANCED;
                        break;
                    }
                    default: {
                        this.left.skew = AVLTree$Skew.BALANCED;
                        this.right.skew = AVLTree$Skew.BALANCED;
                    }
                }
                this.skew = AVLTree$Skew.BALANCED;
                return true;
            }
        }
        this.skew = AVLTree$Skew.RIGHT_HIGH;
        return false;
    }

    private boolean rebalanceRightShrunk() {
        switch (this.skew) {
            case RIGHT_HIGH: {
                this.skew = AVLTree$Skew.BALANCED;
                return true;
            }
            case LEFT_HIGH: {
                if (this.left.skew == AVLTree$Skew.LEFT_HIGH) {
                    this.rotateCW();
                    this.skew = AVLTree$Skew.BALANCED;
                    this.right.skew = AVLTree$Skew.BALANCED;
                    return true;
                }
                if (this.left.skew == AVLTree$Skew.BALANCED) {
                    this.rotateCW();
                    this.skew = AVLTree$Skew.RIGHT_HIGH;
                    this.right.skew = AVLTree$Skew.LEFT_HIGH;
                    return false;
                }
                AVLTree$Skew aVLTree$Skew = this.left.right.skew;
                this.left.rotateCCW();
                this.rotateCW();
                switch (aVLTree$Skew) {
                    case LEFT_HIGH: {
                        this.left.skew = AVLTree$Skew.BALANCED;
                        this.right.skew = AVLTree$Skew.RIGHT_HIGH;
                        break;
                    }
                    case RIGHT_HIGH: {
                        this.left.skew = AVLTree$Skew.LEFT_HIGH;
                        this.right.skew = AVLTree$Skew.BALANCED;
                        break;
                    }
                    default: {
                        this.left.skew = AVLTree$Skew.BALANCED;
                        this.right.skew = AVLTree$Skew.BALANCED;
                    }
                }
                this.skew = AVLTree$Skew.BALANCED;
                return true;
            }
        }
        this.skew = AVLTree$Skew.LEFT_HIGH;
        return false;
    }

    private void rotateCW() {
        Object object = this.element;
        this.element = this.left.element;
        this.left.element = object;
        object = this.left;
        this.left = ((AVLTree$Node)object).left;
        ((AVLTree$Node)object).left = ((AVLTree$Node)object).right;
        ((AVLTree$Node)object).right = this.right;
        this.right = object;
        if (this.left != null) {
            this.left.parent = this;
        }
        if (this.right.right != null) {
            this.right.right.parent = this.right;
        }
    }

    private void rotateCCW() {
        Object object = this.element;
        this.element = this.right.element;
        this.right.element = object;
        object = this.right;
        this.right = ((AVLTree$Node)object).right;
        ((AVLTree$Node)object).right = ((AVLTree$Node)object).left;
        ((AVLTree$Node)object).left = this.left;
        this.left = object;
        if (this.right != null) {
            this.right.parent = this;
        }
        if (this.left.left != null) {
            this.left.left.parent = this.left;
        }
    }

    static /* synthetic */ Comparable access$000(AVLTree$Node aVLTree$Node) {
        return aVLTree$Node.element;
    }

    static /* synthetic */ AVLTree$Node access$100(AVLTree$Node aVLTree$Node) {
        return aVLTree$Node.right;
    }

    static /* synthetic */ AVLTree$Node access$200(AVLTree$Node aVLTree$Node) {
        return aVLTree$Node.left;
    }
}

