/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Space;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTree;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BoundaryAttribute;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Hyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.NodesSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Region;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.RegionFactory$DifferenceMerger;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.RegionFactory$IntersectionMerger;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.RegionFactory$NodesCleaner;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.RegionFactory$UnionMerger;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.RegionFactory$XorMerger;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane$SplitSubHyperplane;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionFactory<S extends Space> {
    private final RegionFactory$NodesCleaner nodeCleaner = new RegionFactory$NodesCleaner(this, null);

    public Region<S> buildConvex(Hyperplane<S> ... hyperplaneArray) {
        if (hyperplaneArray == null || hyperplaneArray.length == 0) {
            return null;
        }
        Region<S> region = hyperplaneArray[0].wholeSpace();
        BSPTree<S> bSPTree = region.getTree(false);
        bSPTree.setAttribute(Boolean.TRUE);
        Hyperplane<S>[] hyperplaneArray2 = hyperplaneArray;
        int n = hyperplaneArray.length;
        for (int i2 = 0; i2 < n; ++i2) {
            Hyperplane<S> hyperplane = hyperplaneArray2[i2];
            if (bSPTree.insertCut(hyperplane)) {
                bSPTree.setAttribute(null);
                bSPTree.getPlus().setAttribute(Boolean.FALSE);
                bSPTree = bSPTree.getMinus();
                bSPTree.setAttribute(Boolean.TRUE);
                continue;
            }
            SubHyperplane<S> subHyperplane = hyperplane.wholeHyperplane();
            BSPTree<S> bSPTree2 = bSPTree;
            while (bSPTree2.getParent() != null && subHyperplane != null) {
                Hyperplane<S> hyperplane2 = bSPTree2.getParent().getCut().getHyperplane();
                SubHyperplane$SplitSubHyperplane<S> subHyperplane$SplitSubHyperplane = subHyperplane.split(hyperplane2);
                switch (subHyperplane$SplitSubHyperplane.getSide()) {
                    case HYPER: {
                        if (hyperplane.sameOrientationAs(hyperplane2)) break;
                        return this.getComplement(hyperplaneArray[0].wholeSpace());
                    }
                    case PLUS: {
                        throw new MathIllegalArgumentException(LocalizedFormats.NOT_CONVEX_HYPERPLANES, new Object[0]);
                    }
                    default: {
                        subHyperplane = subHyperplane$SplitSubHyperplane.getMinus();
                    }
                }
                bSPTree2 = bSPTree2.getParent();
            }
        }
        return region;
    }

    public Region<S> union(Region<S> region, Region<S> object) {
        object = region.getTree(false).merge(object.getTree(false), new RegionFactory$UnionMerger(this, null));
        ((BSPTree)object).visit(this.nodeCleaner);
        return region.buildNew((BSPTree<S>)object);
    }

    public Region<S> intersection(Region<S> region, Region<S> object) {
        object = region.getTree(false).merge(object.getTree(false), new RegionFactory$IntersectionMerger(this, null));
        ((BSPTree)object).visit(this.nodeCleaner);
        return region.buildNew((BSPTree<S>)object);
    }

    public Region<S> xor(Region<S> region, Region<S> object) {
        object = region.getTree(false).merge(object.getTree(false), new RegionFactory$XorMerger(this, null));
        ((BSPTree)object).visit(this.nodeCleaner);
        return region.buildNew((BSPTree<S>)object);
    }

    public Region<S> difference(Region<S> region, Region<S> object) {
        object = region.getTree(false).merge(object.getTree(false), new RegionFactory$DifferenceMerger(this, region, object));
        ((BSPTree)object).visit(this.nodeCleaner);
        return region.buildNew((BSPTree<S>)object);
    }

    public Region<S> getComplement(Region<S> region) {
        return region.buildNew(this.recurseComplement(region.getTree(false)));
    }

    private BSPTree<S> recurseComplement(BSPTree<S> bSPTree) {
        HashMap<BSPTree<S>, BSPTree<S>> hashMap = new HashMap<BSPTree<S>, BSPTree<S>>();
        bSPTree = this.recurseComplement(bSPTree, hashMap);
        for (Map.Entry entry : hashMap.entrySet()) {
            Object object;
            if (((BSPTree)entry.getKey()).getCut() == null || (object = (BoundaryAttribute)((BSPTree)entry.getKey()).getAttribute()) == null) continue;
            entry = (BoundaryAttribute)((BSPTree)entry.getValue()).getAttribute();
            object = ((BoundaryAttribute)object).getSplitters().iterator();
            while (object.hasNext()) {
                BSPTree bSPTree2 = (BSPTree)object.next();
                ((BoundaryAttribute)((Object)entry)).getSplitters().add((BSPTree)hashMap.get(bSPTree2));
            }
        }
        return bSPTree;
    }

    private BSPTree<S> recurseComplement(BSPTree<S> bSPTree, Map<BSPTree<S>, BSPTree<S>> map) {
        Object object;
        if (bSPTree.getCut() == null) {
            object = new BSPTree((Boolean)bSPTree.getAttribute() != false ? Boolean.FALSE : Boolean.TRUE);
        } else {
            object = (BoundaryAttribute)bSPTree.getAttribute();
            if (object != null) {
                SubHyperplane subHyperplane = ((BoundaryAttribute)object).getPlusInside() == null ? null : ((BoundaryAttribute)object).getPlusInside().copySelf();
                object = ((BoundaryAttribute)object).getPlusOutside() == null ? null : ((BoundaryAttribute)object).getPlusOutside().copySelf();
                object = new BoundaryAttribute(subHyperplane, object, new NodesSet());
            }
            object = new BSPTree<S>(bSPTree.getCut().copySelf(), this.recurseComplement(bSPTree.getPlus(), map), this.recurseComplement(bSPTree.getMinus(), map), object);
        }
        map.put(bSPTree, (BSPTree<S>)object);
        return object;
    }

    static /* synthetic */ BSPTree access$400(RegionFactory regionFactory, BSPTree bSPTree) {
        return regionFactory.recurseComplement(bSPTree);
    }
}

