/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Space;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTree;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Hyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Region;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Side;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane$SplitSubHyperplane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InsideFinder<S extends Space> {
    private final Region<S> region;
    private boolean plusFound;
    private boolean minusFound;

    InsideFinder(Region<S> region) {
        this.region = region;
        this.plusFound = false;
        this.minusFound = false;
    }

    public void recurseSides(BSPTree<S> bSPTree, SubHyperplane<S> subHyperplane) {
        if (bSPTree.getCut() == null) {
            if (((Boolean)bSPTree.getAttribute()).booleanValue()) {
                this.plusFound = true;
                this.minusFound = true;
            }
            return;
        }
        Object object = bSPTree.getCut().getHyperplane();
        object = subHyperplane.split((Hyperplane<S>)object);
        switch (((SubHyperplane$SplitSubHyperplane)object).getSide()) {
            case PLUS: {
                if (bSPTree.getCut().split(subHyperplane.getHyperplane()).getSide() == Side.PLUS) {
                    if (!this.region.isEmpty(bSPTree.getMinus())) {
                        this.plusFound = true;
                    }
                } else if (!this.region.isEmpty(bSPTree.getMinus())) {
                    this.minusFound = true;
                }
                if (this.plusFound && this.minusFound) break;
                this.recurseSides(bSPTree.getPlus(), subHyperplane);
                return;
            }
            case MINUS: {
                if (bSPTree.getCut().split(subHyperplane.getHyperplane()).getSide() == Side.PLUS) {
                    if (!this.region.isEmpty(bSPTree.getPlus())) {
                        this.plusFound = true;
                    }
                } else if (!this.region.isEmpty(bSPTree.getPlus())) {
                    this.minusFound = true;
                }
                if (this.plusFound && this.minusFound) break;
                this.recurseSides(bSPTree.getMinus(), subHyperplane);
                return;
            }
            case BOTH: {
                this.recurseSides(bSPTree.getPlus(), ((SubHyperplane$SplitSubHyperplane)object).getPlus());
                if (this.plusFound && this.minusFound) break;
                this.recurseSides(bSPTree.getMinus(), ((SubHyperplane$SplitSubHyperplane)object).getMinus());
                return;
            }
            default: {
                if (bSPTree.getCut().getHyperplane().sameOrientationAs(subHyperplane.getHyperplane())) {
                    if (bSPTree.getPlus().getCut() != null || ((Boolean)bSPTree.getPlus().getAttribute()).booleanValue()) {
                        this.plusFound = true;
                    }
                    if (bSPTree.getMinus().getCut() == null && !((Boolean)bSPTree.getMinus().getAttribute()).booleanValue()) break;
                    this.minusFound = true;
                    return;
                }
                if (bSPTree.getPlus().getCut() != null || ((Boolean)bSPTree.getPlus().getAttribute()).booleanValue()) {
                    this.minusFound = true;
                }
                if (bSPTree.getMinus().getCut() == null && !((Boolean)bSPTree.getMinus().getAttribute()).booleanValue()) break;
                this.plusFound = true;
            }
        }
    }

    public boolean plusFound() {
        return this.plusFound;
    }

    public boolean minusFound() {
        return this.minusFound;
    }
}

