/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Space;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTree;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Hyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.NodesSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane$SplitSubHyperplane;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Characterization<S extends Space> {
    private SubHyperplane<S> outsideTouching = null;
    private SubHyperplane<S> insideTouching = null;
    private final NodesSet<S> outsideSplitters = new NodesSet();
    private final NodesSet<S> insideSplitters = new NodesSet();

    Characterization(BSPTree<S> bSPTree, SubHyperplane<S> subHyperplane) {
        this.characterize(bSPTree, subHyperplane, new ArrayList<BSPTree<S>>());
    }

    private void characterize(BSPTree<S> bSPTree, SubHyperplane<S> subHyperplane, List<BSPTree<S>> list) {
        if (bSPTree.getCut() == null) {
            boolean bl = (Boolean)bSPTree.getAttribute();
            if (!bl) {
                this.addOutsideTouching(subHyperplane, list);
                return;
            }
        } else {
            Object object = bSPTree.getCut().getHyperplane();
            object = subHyperplane.split((Hyperplane<S>)object);
            switch (((SubHyperplane$SplitSubHyperplane)object).getSide()) {
                case PLUS: {
                    this.characterize(bSPTree.getPlus(), subHyperplane, list);
                    return;
                }
                case MINUS: {
                    this.characterize(bSPTree.getMinus(), subHyperplane, list);
                    return;
                }
                case BOTH: {
                    list.add(bSPTree);
                    this.characterize(bSPTree.getPlus(), ((SubHyperplane$SplitSubHyperplane)object).getPlus(), list);
                    this.characterize(bSPTree.getMinus(), ((SubHyperplane$SplitSubHyperplane)object).getMinus(), list);
                    List<BSPTree<S>> list2 = list;
                    list2.remove(list2.size() - 1);
                    return;
                }
            }
            throw new MathInternalError();
        }
        this.addInsideTouching(subHyperplane, list);
    }

    private void addOutsideTouching(SubHyperplane<S> subHyperplane, List<BSPTree<S>> list) {
        this.outsideTouching = this.outsideTouching == null ? subHyperplane : this.outsideTouching.reunite(subHyperplane);
        this.outsideSplitters.addAll(list);
    }

    private void addInsideTouching(SubHyperplane<S> subHyperplane, List<BSPTree<S>> list) {
        this.insideTouching = this.insideTouching == null ? subHyperplane : this.insideTouching.reunite(subHyperplane);
        this.insideSplitters.addAll(list);
    }

    public boolean touchOutside() {
        return this.outsideTouching != null && !this.outsideTouching.isEmpty();
    }

    public SubHyperplane<S> outsideTouching() {
        return this.outsideTouching;
    }

    public NodesSet<S> getOutsideSplitters() {
        return this.outsideSplitters;
    }

    public boolean touchInside() {
        return this.insideTouching != null && !this.insideTouching.isEmpty();
    }

    public SubHyperplane<S> insideTouching() {
        return this.insideTouching;
    }

    public NodesSet<S> getInsideSplitters() {
        return this.insideSplitters;
    }
}

