/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Space;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.AbstractSubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTree;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTreeVisitor$Order;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BoundaryAttribute;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BoundaryProjection;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Embedding;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Hyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Region;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Region$Location;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BoundaryProjector<S extends Space, T extends Space>
implements BSPTreeVisitor<S> {
    private final Point<S> original;
    private Point<S> projected;
    private BSPTree<S> leaf;
    private double offset;

    BoundaryProjector(Point<S> point) {
        this.original = point;
        this.projected = null;
        this.leaf = null;
        this.offset = Double.POSITIVE_INFINITY;
    }

    @Override
    public BSPTreeVisitor$Order visitOrder(BSPTree<S> bSPTree) {
        if (bSPTree.getCut().getHyperplane().getOffset(this.original) <= 0.0) {
            return BSPTreeVisitor$Order.MINUS_SUB_PLUS;
        }
        return BSPTreeVisitor$Order.PLUS_SUB_MINUS;
    }

    @Override
    public void visitInternalNode(BSPTree<S> point) {
        double d2;
        Hyperplane<S> hyperplane = ((BSPTree)((Object)point)).getCut().getHyperplane();
        double d3 = hyperplane.getOffset(this.original);
        if (FastMath.abs(d2) < this.offset) {
            Region region;
            Point<S> point2 = hyperplane.project(this.original);
            point = this.boundaryRegions((BSPTree<S>)((Object)point));
            boolean bl = false;
            Iterator iterator = point.iterator();
            while (iterator.hasNext()) {
                region = (Region)iterator.next();
                if (bl || !this.belongsToPart(point2, hyperplane, region)) continue;
                this.projected = point2;
                this.offset = FastMath.abs(d3);
                bl = true;
            }
            if (!bl) {
                iterator = point.iterator();
                while (iterator.hasNext()) {
                    double d4;
                    region = (Region)iterator.next();
                    point = this.singularProjection(point2, hyperplane, region);
                    if (point == null) continue;
                    double d5 = this.original.distance(point);
                    if (!(d4 < this.offset)) continue;
                    this.projected = point;
                    this.offset = d5;
                }
            }
        }
    }

    @Override
    public void visitLeafNode(BSPTree<S> bSPTree) {
        if (this.leaf == null) {
            this.leaf = bSPTree;
        }
    }

    public BoundaryProjection<S> getProjection() {
        this.offset = FastMath.copySign(this.offset, (Boolean)this.leaf.getAttribute() != false ? -1.0 : 1.0);
        return new BoundaryProjection<S>(this.original, this.projected, this.offset);
    }

    private List<Region<T>> boundaryRegions(BSPTree<S> object) {
        ArrayList<Region<T>> arrayList = new ArrayList<Region<T>>(2);
        object = (BoundaryAttribute)((BSPTree)object).getAttribute();
        this.addRegion(((BoundaryAttribute)object).getPlusInside(), arrayList);
        this.addRegion(((BoundaryAttribute)object).getPlusOutside(), arrayList);
        return arrayList;
    }

    private void addRegion(SubHyperplane<S> object, List<Region<T>> list) {
        if (object != null && (object = ((AbstractSubHyperplane)object).getRemainingRegion()) != null) {
            list.add((Region<T>)object);
        }
    }

    private boolean belongsToPart(Point<S> point, Hyperplane<S> object, Region<T> region) {
        return region.checkPoint((object = (Embedding)object).toSubSpace(point)) != Region$Location.OUTSIDE;
    }

    private Point<S> singularProjection(Point<S> object, Hyperplane<S> object2, Region<T> region) {
        if (((BoundaryProjection)(object = region.projectToBoundary((object2 = (Embedding)object2).toSubSpace(object)))).getProjected() == null) {
            return null;
        }
        return object2.toSpace(((BoundaryProjection)object).getProjected());
    }
}

