/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Space;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Vector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTree$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTree$LeafMerger;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTree$VanishingCutHandler;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Hyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Side;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane$SplitSubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BSPTree<S extends Space> {
    private SubHyperplane<S> cut;
    private BSPTree<S> plus;
    private BSPTree<S> minus;
    private BSPTree<S> parent;
    private Object attribute;

    public BSPTree() {
        this.cut = null;
        this.plus = null;
        this.minus = null;
        this.parent = null;
        this.attribute = null;
    }

    public BSPTree(Object object) {
        this.cut = null;
        this.plus = null;
        this.minus = null;
        this.parent = null;
        this.attribute = object;
    }

    public BSPTree(SubHyperplane<S> subHyperplane, BSPTree<S> bSPTree, BSPTree<S> bSPTree2, Object object) {
        this.cut = subHyperplane;
        this.plus = bSPTree;
        this.minus = bSPTree2;
        this.parent = null;
        this.attribute = object;
        bSPTree.parent = this;
        bSPTree2.parent = this;
    }

    public boolean insertCut(Hyperplane<S> object) {
        if (this.cut != null) {
            this.plus.parent = null;
            this.minus.parent = null;
        }
        if ((object = this.fitToCell(object.wholeHyperplane())) == null || object.isEmpty()) {
            this.cut = null;
            this.plus = null;
            this.minus = null;
            return false;
        }
        this.cut = object;
        this.plus = new BSPTree<S>();
        this.plus.parent = this;
        this.minus = new BSPTree<S>();
        this.minus.parent = this;
        return true;
    }

    public BSPTree<S> copySelf() {
        if (this.cut == null) {
            return new BSPTree<S>(this.attribute);
        }
        return new BSPTree<S>(this.cut.copySelf(), this.plus.copySelf(), this.minus.copySelf(), this.attribute);
    }

    public SubHyperplane<S> getCut() {
        return this.cut;
    }

    public BSPTree<S> getPlus() {
        return this.plus;
    }

    public BSPTree<S> getMinus() {
        return this.minus;
    }

    public BSPTree<S> getParent() {
        return this.parent;
    }

    public void setAttribute(Object object) {
        this.attribute = object;
    }

    public Object getAttribute() {
        return this.attribute;
    }

    public void visit(BSPTreeVisitor<S> bSPTreeVisitor) {
        if (this.cut == null) {
            bSPTreeVisitor.visitLeafNode(this);
            return;
        }
        switch (bSPTreeVisitor.visitOrder(this)) {
            case PLUS_MINUS_SUB: {
                this.plus.visit(bSPTreeVisitor);
                this.minus.visit(bSPTreeVisitor);
                bSPTreeVisitor.visitInternalNode(this);
                return;
            }
            case PLUS_SUB_MINUS: {
                this.plus.visit(bSPTreeVisitor);
                bSPTreeVisitor.visitInternalNode(this);
                this.minus.visit(bSPTreeVisitor);
                return;
            }
            case MINUS_PLUS_SUB: {
                this.minus.visit(bSPTreeVisitor);
                this.plus.visit(bSPTreeVisitor);
                bSPTreeVisitor.visitInternalNode(this);
                return;
            }
            case MINUS_SUB_PLUS: {
                this.minus.visit(bSPTreeVisitor);
                bSPTreeVisitor.visitInternalNode(this);
                this.plus.visit(bSPTreeVisitor);
                return;
            }
            case SUB_PLUS_MINUS: {
                bSPTreeVisitor.visitInternalNode(this);
                this.plus.visit(bSPTreeVisitor);
                this.minus.visit(bSPTreeVisitor);
                return;
            }
            case SUB_MINUS_PLUS: {
                bSPTreeVisitor.visitInternalNode(this);
                this.minus.visit(bSPTreeVisitor);
                this.plus.visit(bSPTreeVisitor);
                return;
            }
        }
        throw new MathInternalError();
    }

    private SubHyperplane<S> fitToCell(SubHyperplane<S> subHyperplane) {
        BSPTree<S> bSPTree = this;
        while (bSPTree.parent != null && subHyperplane != null) {
            BSPTree<S> bSPTree2 = bSPTree;
            subHyperplane = bSPTree2 == bSPTree2.parent.plus ? subHyperplane.split(bSPTree.parent.cut.getHyperplane()).getPlus() : subHyperplane.split(bSPTree.parent.cut.getHyperplane()).getMinus();
            bSPTree = bSPTree.parent;
        }
        return subHyperplane;
    }

    @Deprecated
    public BSPTree<S> getCell(Vector<S> vector) {
        return this.getCell(vector, 1.0E-10);
    }

    public BSPTree<S> getCell(Point<S> point, double d2) {
        double d3;
        if (this.cut == null) {
            return this;
        }
        double d4 = this.cut.getHyperplane().getOffset(point);
        if (FastMath.abs(d3) < d2) {
            return this;
        }
        if (d4 <= 0.0) {
            return this.minus.getCell(point, d2);
        }
        return this.plus.getCell(point, d2);
    }

    public List<BSPTree<S>> getCloseCuts(Point<S> point, double d2) {
        ArrayList<BSPTree<S>> arrayList = new ArrayList<BSPTree<S>>();
        this.recurseCloseCuts(point, d2, arrayList);
        return arrayList;
    }

    private void recurseCloseCuts(Point<S> point, double d2, List<BSPTree<S>> list) {
        while (bSPTree.cut != null) {
            double d3;
            double d4 = bSPTree.cut.getHyperplane().getOffset(point);
            if (d3 < -d2) {
                super.recurseCloseCuts(point, d2, list);
                return;
            }
            if (d4 > d2) {
                super.recurseCloseCuts(point, d2, list);
                return;
            }
            list.add(bSPTree);
            super.recurseCloseCuts(point, d2, list);
            BSPTree<S> bSPTree = bSPTree.plus;
        }
    }

    private void condense() {
        if (this.cut != null && this.plus.cut == null && this.minus.cut == null && (this.plus.attribute == null && this.minus.attribute == null || this.plus.attribute != null && this.plus.attribute.equals(this.minus.attribute))) {
            this.attribute = this.plus.attribute == null ? this.minus.attribute : this.plus.attribute;
            this.cut = null;
            this.plus = null;
            this.minus = null;
        }
    }

    public BSPTree<S> merge(BSPTree<S> bSPTree, BSPTree$LeafMerger<S> bSPTree$LeafMerger) {
        return this.merge(bSPTree, bSPTree$LeafMerger, null, false);
    }

    private BSPTree<S> merge(BSPTree<S> bSPTree, BSPTree$LeafMerger<S> bSPTree$LeafMerger, BSPTree<S> bSPTree2, boolean bl) {
        if (this.cut == null) {
            return bSPTree$LeafMerger.merge(this, bSPTree, bSPTree2, bl, true);
        }
        if (bSPTree.cut == null) {
            return bSPTree$LeafMerger.merge(bSPTree, this, bSPTree2, bl, false);
        }
        bSPTree = bSPTree.split(this.cut);
        if (bSPTree2 != null) {
            bSPTree.parent = bSPTree2;
            if (bl) {
                bSPTree2.plus = bSPTree;
            } else {
                bSPTree2.minus = bSPTree;
            }
        }
        super.merge(bSPTree.plus, bSPTree$LeafMerger, bSPTree, true);
        super.merge(bSPTree.minus, bSPTree$LeafMerger, bSPTree, false);
        super.condense();
        if (bSPTree.cut != null) {
            bSPTree.cut = super.fitToCell(bSPTree.cut.getHyperplane().wholeHyperplane());
        }
        return bSPTree;
    }

    public BSPTree<S> split(SubHyperplane<S> object) {
        if (this.cut == null) {
            return new BSPTree<S>(object, this.copySelf(), new BSPTree<S>(this.attribute), null);
        }
        BSPTree<S> bSPTree = this.cut.getHyperplane();
        Hyperplane<S> hyperplane = object.getHyperplane();
        SubHyperplane$SplitSubHyperplane<S> subHyperplane$SplitSubHyperplane = object.split(bSPTree);
        switch (subHyperplane$SplitSubHyperplane.getSide()) {
            case PLUS: {
                bSPTree = this.plus.split((SubHyperplane<S>)object);
                if (this.cut.split(hyperplane).getSide() == Side.PLUS) {
                    bSPTree.plus = new BSPTree<S>(this.cut.copySelf(), bSPTree.plus, this.minus.copySelf(), this.attribute);
                    super.condense();
                    bSPTree.plus.parent = bSPTree;
                } else {
                    bSPTree.minus = new BSPTree<S>(this.cut.copySelf(), bSPTree.minus, this.minus.copySelf(), this.attribute);
                    super.condense();
                    bSPTree.minus.parent = bSPTree;
                }
                return bSPTree;
            }
            case MINUS: {
                bSPTree = this.minus.split((SubHyperplane<S>)object);
                if (this.cut.split(hyperplane).getSide() == Side.PLUS) {
                    bSPTree.plus = new BSPTree<S>(this.cut.copySelf(), this.plus.copySelf(), bSPTree.plus, this.attribute);
                    super.condense();
                    bSPTree.plus.parent = bSPTree;
                } else {
                    bSPTree.minus = new BSPTree<S>(this.cut.copySelf(), this.plus.copySelf(), bSPTree.minus, this.attribute);
                    super.condense();
                    bSPTree.minus.parent = bSPTree;
                }
                return bSPTree;
            }
            case BOTH: {
                bSPTree = this.cut.split(hyperplane);
                object = new BSPTree<S>(object, this.plus.split(subHyperplane$SplitSubHyperplane.getPlus()), this.minus.split(subHyperplane$SplitSubHyperplane.getMinus()), null);
                v0.plus.cut = ((SubHyperplane$SplitSubHyperplane)((Object)bSPTree)).getPlus();
                ((BSPTree)object).minus.cut = ((SubHyperplane$SplitSubHyperplane)((Object)bSPTree)).getMinus();
                bSPTree = ((BSPTree)object).plus.minus;
                ((BSPTree)object).plus.minus = ((BSPTree)object).minus.plus;
                ((BSPTree)object).plus.minus.parent = ((BSPTree)object).plus;
                ((BSPTree)object).minus.plus = bSPTree;
                ((BSPTree)object).minus.plus.parent = ((BSPTree)object).minus;
                super.condense();
                super.condense();
                return object;
            }
        }
        if (bSPTree.sameOrientationAs(hyperplane)) {
            return new BSPTree<S>(object, this.plus.copySelf(), this.minus.copySelf(), this.attribute);
        }
        return new BSPTree<S>(object, this.minus.copySelf(), this.plus.copySelf(), this.attribute);
    }

    @Deprecated
    public void insertInTree(BSPTree<S> bSPTree, boolean bl) {
        this.insertInTree(bSPTree, bl, new BSPTree$1(this));
    }

    public void insertInTree(BSPTree<S> bSPTree, boolean bl, BSPTree$VanishingCutHandler<S> bSPTree$VanishingCutHandler) {
        this.parent = bSPTree;
        if (bSPTree != null) {
            if (bl) {
                bSPTree.plus = this;
            } else {
                bSPTree.minus = this;
            }
        }
        if (this.cut != null) {
            bSPTree = this;
            while (bSPTree.parent != null) {
                Object object = bSPTree.parent.cut.getHyperplane();
                BSPTree<S> bSPTree2 = bSPTree;
                if (bSPTree2 == bSPTree2.parent.plus) {
                    this.cut = this.cut.split((Hyperplane<S>)object).getPlus();
                    super.chopOffMinus((Hyperplane<S>)object, bSPTree$VanishingCutHandler);
                    super.chopOffMinus((Hyperplane<S>)object, bSPTree$VanishingCutHandler);
                } else {
                    this.cut = this.cut.split((Hyperplane<S>)object).getMinus();
                    super.chopOffPlus((Hyperplane<S>)object, bSPTree$VanishingCutHandler);
                    super.chopOffPlus((Hyperplane<S>)object, bSPTree$VanishingCutHandler);
                }
                if (this.cut == null) {
                    object = bSPTree$VanishingCutHandler.fixNode(this);
                    this.cut = ((BSPTree)object).cut;
                    this.plus = ((BSPTree)object).plus;
                    this.minus = ((BSPTree)object).minus;
                    this.attribute = ((BSPTree)object).attribute;
                    if (this.cut == null) break;
                }
                bSPTree = bSPTree.parent;
            }
            this.condense();
        }
    }

    public BSPTree<S> pruneAroundConvexCell(Object bSPTree, Object object, Object object2) {
        bSPTree = new BSPTree<S>(bSPTree);
        BSPTree<S> bSPTree2 = this;
        while (bSPTree2.parent != null) {
            SubHyperplane<S> subHyperplane = bSPTree2.parent.cut.copySelf();
            BSPTree<S> bSPTree3 = new BSPTree<S>(object);
            BSPTree<S> bSPTree4 = bSPTree2;
            bSPTree = bSPTree4 == bSPTree4.parent.plus ? new BSPTree<S>(subHyperplane, bSPTree, bSPTree3, object2) : new BSPTree<S>(subHyperplane, bSPTree3, bSPTree, object2);
            bSPTree2 = bSPTree2.parent;
        }
        return bSPTree;
    }

    private void chopOffMinus(Hyperplane<S> object, BSPTree$VanishingCutHandler<S> bSPTree$VanishingCutHandler) {
        if (this.cut != null) {
            this.cut = this.cut.split((Hyperplane<S>)object).getPlus();
            super.chopOffMinus((Hyperplane<S>)object, bSPTree$VanishingCutHandler);
            super.chopOffMinus((Hyperplane<S>)object, bSPTree$VanishingCutHandler);
            if (this.cut == null) {
                object = bSPTree$VanishingCutHandler.fixNode(this);
                this.cut = ((BSPTree)object).cut;
                this.plus = ((BSPTree)object).plus;
                this.minus = ((BSPTree)object).minus;
                this.attribute = ((BSPTree)object).attribute;
            }
        }
    }

    private void chopOffPlus(Hyperplane<S> object, BSPTree$VanishingCutHandler<S> bSPTree$VanishingCutHandler) {
        if (this.cut != null) {
            this.cut = this.cut.split((Hyperplane<S>)object).getMinus();
            super.chopOffPlus((Hyperplane<S>)object, bSPTree$VanishingCutHandler);
            super.chopOffPlus((Hyperplane<S>)object, bSPTree$VanishingCutHandler);
            if (this.cut == null) {
                object = bSPTree$VanishingCutHandler.fixNode(this);
                this.cut = ((BSPTree)object).cut;
                this.plus = ((BSPTree)object).plus;
                this.minus = ((BSPTree)object).minus;
                this.attribute = ((BSPTree)object).attribute;
            }
        }
    }
}

