/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Space;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTree;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BoundaryAttribute;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Hyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.NodesSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Region;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.RegionFactory;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Side;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane$SplitSubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Transform;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSubHyperplane<S extends Space, T extends Space>
implements SubHyperplane<S> {
    private final Hyperplane<S> hyperplane;
    private final Region<T> remainingRegion;

    protected AbstractSubHyperplane(Hyperplane<S> hyperplane, Region<T> region) {
        this.hyperplane = hyperplane;
        this.remainingRegion = region;
    }

    protected abstract AbstractSubHyperplane<S, T> buildNew(Hyperplane<S> var1, Region<T> var2);

    public AbstractSubHyperplane<S, T> copySelf() {
        AbstractSubHyperplane abstractSubHyperplane = this;
        return abstractSubHyperplane.buildNew(abstractSubHyperplane.hyperplane.copySelf(), this.remainingRegion);
    }

    @Override
    public Hyperplane<S> getHyperplane() {
        return this.hyperplane;
    }

    public Region<T> getRemainingRegion() {
        return this.remainingRegion;
    }

    @Override
    public double getSize() {
        return this.remainingRegion.getSize();
    }

    public AbstractSubHyperplane<S, T> reunite(SubHyperplane<S> abstractSubHyperplane) {
        abstractSubHyperplane = abstractSubHyperplane;
        AbstractSubHyperplane abstractSubHyperplane2 = this;
        return abstractSubHyperplane2.buildNew(abstractSubHyperplane2.hyperplane, new RegionFactory<T>().union(this.remainingRegion, abstractSubHyperplane.remainingRegion));
    }

    public AbstractSubHyperplane<S, T> applyTransform(Transform<S, T> object) {
        Hyperplane<S> hyperplane = object.apply(this.hyperplane);
        HashMap<BSPTree<T>, BSPTree<T>> hashMap = new HashMap<BSPTree<T>, BSPTree<T>>();
        AbstractSubHyperplane abstractSubHyperplane = this;
        object = abstractSubHyperplane.recurseTransform(abstractSubHyperplane.remainingRegion.getTree(false), hyperplane, (Transform<S, T>)object, (Map<BSPTree<T>, BSPTree<T>>)hashMap);
        for (Map.Entry entry : hashMap.entrySet()) {
            Object object2;
            if (((BSPTree)entry.getKey()).getCut() == null || (object2 = (BoundaryAttribute)((BSPTree)entry.getKey()).getAttribute()) == null) continue;
            entry = (BoundaryAttribute)((BSPTree)entry.getValue()).getAttribute();
            object2 = ((BoundaryAttribute)object2).getSplitters().iterator();
            while (object2.hasNext()) {
                BSPTree bSPTree = (BSPTree)object2.next();
                ((BoundaryAttribute)((Object)entry)).getSplitters().add((BSPTree)hashMap.get(bSPTree));
            }
        }
        return this.buildNew(hyperplane, this.remainingRegion.buildNew((BSPTree<T>)object));
    }

    private BSPTree<T> recurseTransform(BSPTree<T> bSPTree, Hyperplane<S> bSPTree2, Transform<S, T> transform, Map<BSPTree<T>, BSPTree<T>> map) {
        if (bSPTree.getCut() == null) {
            bSPTree2 = new BSPTree(bSPTree.getAttribute());
        } else {
            BoundaryAttribute<T> boundaryAttribute = (BoundaryAttribute<T>)bSPTree.getAttribute();
            if (boundaryAttribute != null) {
                SubHyperplane<T> subHyperplane = boundaryAttribute.getPlusOutside() == null ? null : transform.apply(boundaryAttribute.getPlusOutside(), this.hyperplane, (Hyperplane<S>)((Object)bSPTree2));
                boundaryAttribute = boundaryAttribute.getPlusInside() == null ? null : transform.apply(boundaryAttribute.getPlusInside(), this.hyperplane, (Hyperplane<S>)((Object)bSPTree2));
                boundaryAttribute = new BoundaryAttribute<T>(subHyperplane, boundaryAttribute, new NodesSet());
            }
            bSPTree2 = new BSPTree<T>(transform.apply(bSPTree.getCut(), this.hyperplane, (Hyperplane<S>)((Object)bSPTree2)), this.recurseTransform(bSPTree.getPlus(), (Hyperplane<S>)((Object)bSPTree2), transform, map), this.recurseTransform(bSPTree.getMinus(), (Hyperplane<S>)((Object)bSPTree2), transform, map), boundaryAttribute);
        }
        map.put(bSPTree, bSPTree2);
        return bSPTree2;
    }

    @Override
    @Deprecated
    public Side side(Hyperplane<S> hyperplane) {
        return this.split(hyperplane).getSide();
    }

    @Override
    public abstract SubHyperplane$SplitSubHyperplane<S> split(Hyperplane<S> var1);

    @Override
    public boolean isEmpty() {
        return this.remainingRegion.isEmpty();
    }
}

