/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Space;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Vector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.AbstractRegion$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.AbstractRegion$2;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.AbstractSubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTree;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BoundaryAttribute;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BoundaryBuilder;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BoundaryProjection;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BoundaryProjector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BoundarySizeVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Hyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.InsideFinder;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.NodesSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Region;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Region$Location;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.RegionFactory;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Side;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane$SplitSubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Transform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRegion<S extends Space, T extends Space>
implements Region<S> {
    private BSPTree<S> tree;
    private final double tolerance;
    private double size;
    private Point<S> barycenter;

    protected AbstractRegion(double d2) {
        this.tree = new BSPTree(Boolean.TRUE);
        this.tolerance = d2;
    }

    protected AbstractRegion(BSPTree<S> bSPTree, double d2) {
        this.tree = bSPTree;
        this.tolerance = d2;
    }

    protected AbstractRegion(Collection<SubHyperplane<S>> collection, double d2) {
        this.tolerance = d2;
        if (collection.size() == 0) {
            this.tree = new BSPTree(Boolean.TRUE);
            return;
        }
        TreeSet<SubHyperplane<S>> treeSet = new TreeSet<SubHyperplane<S>>(new AbstractRegion$1(this));
        treeSet.addAll(collection);
        this.tree = new BSPTree();
        AbstractRegion abstractRegion = this;
        abstractRegion.insertCuts(abstractRegion.tree, treeSet);
        this.tree.visit(new AbstractRegion$2(this));
    }

    public AbstractRegion(Hyperplane<S>[] hyperplaneArray, double d2) {
        this.tolerance = d2;
        if (hyperplaneArray == null || hyperplaneArray.length == 0) {
            this.tree = new BSPTree(Boolean.FALSE);
            return;
        }
        this.tree = hyperplaneArray[0].wholeSpace().getTree(false);
        BSPTree<S> bSPTree = this.tree;
        bSPTree.setAttribute(Boolean.TRUE);
        for (Hyperplane<S> hyperplane : hyperplaneArray) {
            if (!bSPTree.insertCut(hyperplane)) continue;
            bSPTree.setAttribute(null);
            bSPTree.getPlus().setAttribute(Boolean.FALSE);
            bSPTree = bSPTree.getMinus();
            bSPTree.setAttribute(Boolean.TRUE);
        }
    }

    public abstract AbstractRegion<S, T> buildNew(BSPTree<S> var1);

    public double getTolerance() {
        return this.tolerance;
    }

    private void insertCuts(BSPTree<S> bSPTree, Collection<SubHyperplane<S>> arrayList) {
        while (true) {
            arrayList = arrayList.iterator();
            Hyperplane hyperplane = null;
            while (hyperplane == null && arrayList.hasNext()) {
                hyperplane = ((SubHyperplane)arrayList.next()).getHyperplane();
                if (bSPTree.insertCut(hyperplane.copySelf())) continue;
                hyperplane = null;
            }
            if (!arrayList.hasNext()) {
                return;
            }
            ArrayList<SubHyperplane<S>> arrayList2 = new ArrayList<SubHyperplane<S>>();
            ArrayList arrayList3 = new ArrayList();
            while (arrayList.hasNext()) {
                SubHyperplane subHyperplane = (SubHyperplane)arrayList.next();
                SubHyperplane$SplitSubHyperplane subHyperplane$SplitSubHyperplane = subHyperplane.split(hyperplane);
                switch (subHyperplane$SplitSubHyperplane.getSide()) {
                    case PLUS: {
                        arrayList2.add(subHyperplane);
                        break;
                    }
                    case MINUS: {
                        arrayList3.add(subHyperplane);
                        break;
                    }
                    case BOTH: {
                        arrayList2.add(subHyperplane$SplitSubHyperplane.getPlus());
                        arrayList3.add(subHyperplane$SplitSubHyperplane.getMinus());
                    }
                }
            }
            this.insertCuts(bSPTree.getPlus(), arrayList2);
            arrayList = arrayList3;
            bSPTree = bSPTree.getMinus();
        }
    }

    public AbstractRegion<S, T> copySelf() {
        AbstractRegion abstractRegion = this;
        return abstractRegion.buildNew((BSPTree)abstractRegion.tree.copySelf());
    }

    @Override
    public boolean isEmpty() {
        AbstractRegion abstractRegion = this;
        return abstractRegion.isEmpty(abstractRegion.tree);
    }

    @Override
    public boolean isEmpty(BSPTree<S> bSPTree) {
        if (bSPTree.getCut() == null) {
            return (Boolean)bSPTree.getAttribute() == false;
        }
        return this.isEmpty(bSPTree.getMinus()) && this.isEmpty(bSPTree.getPlus());
    }

    @Override
    public boolean isFull() {
        AbstractRegion abstractRegion = this;
        return abstractRegion.isFull(abstractRegion.tree);
    }

    @Override
    public boolean isFull(BSPTree<S> bSPTree) {
        if (bSPTree.getCut() == null) {
            return (Boolean)bSPTree.getAttribute();
        }
        return this.isFull(bSPTree.getMinus()) && this.isFull(bSPTree.getPlus());
    }

    @Override
    public boolean contains(Region<S> region) {
        return new RegionFactory<S>().difference(region, this).isEmpty();
    }

    @Override
    public BoundaryProjection<S> projectToBoundary(Point<S> object) {
        object = new BoundaryProjector(object);
        this.getTree(true).visit((BSPTreeVisitor<S>)object);
        return ((BoundaryProjector)object).getProjection();
    }

    @Override
    public Region$Location checkPoint(Vector<S> vector) {
        return this.checkPoint((Point<S>)vector);
    }

    @Override
    public Region$Location checkPoint(Point<S> point) {
        AbstractRegion abstractRegion = this;
        return abstractRegion.checkPoint(abstractRegion.tree, point);
    }

    protected Region$Location checkPoint(BSPTree<S> bSPTree, Vector<S> vector) {
        return this.checkPoint(bSPTree, (Point<S>)vector);
    }

    protected Region$Location checkPoint(BSPTree<S> object, Point<S> point) {
        if ((object = object.getCell(point, this.tolerance)).getCut() == null) {
            if (((Boolean)object.getAttribute()).booleanValue()) {
                return Region$Location.INSIDE;
            }
            return Region$Location.OUTSIDE;
        }
        Region$Location region$Location = this.checkPoint(object.getMinus(), point);
        if (region$Location == (object = this.checkPoint(object.getPlus(), point))) {
            return region$Location;
        }
        return Region$Location.BOUNDARY;
    }

    @Override
    public BSPTree<S> getTree(boolean bl) {
        if (bl && this.tree.getCut() != null && this.tree.getAttribute() == null) {
            this.tree.visit(new BoundaryBuilder());
        }
        return this.tree;
    }

    @Override
    public double getBoundarySize() {
        BoundarySizeVisitor boundarySizeVisitor = new BoundarySizeVisitor();
        this.getTree(true).visit(boundarySizeVisitor);
        return boundarySizeVisitor.getSize();
    }

    @Override
    public double getSize() {
        if (this.barycenter == null) {
            this.computeGeometricalProperties();
        }
        return this.size;
    }

    protected void setSize(double d2) {
        this.size = d2;
    }

    @Override
    public Point<S> getBarycenter() {
        if (this.barycenter == null) {
            this.computeGeometricalProperties();
        }
        return this.barycenter;
    }

    protected void setBarycenter(Vector<S> vector) {
        this.setBarycenter((Point<S>)vector);
    }

    protected void setBarycenter(Point<S> point) {
        this.barycenter = point;
    }

    protected abstract void computeGeometricalProperties();

    @Override
    @Deprecated
    public Side side(Hyperplane<S> hyperplane) {
        InsideFinder<S> insideFinder = new InsideFinder<S>(this);
        insideFinder.recurseSides(this.tree, hyperplane.wholeHyperplane());
        if (insideFinder.plusFound()) {
            if (insideFinder.minusFound()) {
                return Side.BOTH;
            }
            return Side.PLUS;
        }
        if (insideFinder.minusFound()) {
            return Side.MINUS;
        }
        return Side.HYPER;
    }

    @Override
    public SubHyperplane<S> intersection(SubHyperplane<S> subHyperplane) {
        AbstractRegion abstractRegion = this;
        return abstractRegion.recurseIntersection(abstractRegion.tree, subHyperplane);
    }

    private SubHyperplane<S> recurseIntersection(BSPTree<S> object, SubHyperplane<S> subHyperplane) {
        while (true) {
            if (((BSPTree)object).getCut() == null) {
                if (((Boolean)((BSPTree)object).getAttribute()).booleanValue()) {
                    return subHyperplane.copySelf();
                }
                return null;
            }
            Object object2 = ((BSPTree)object).getCut().getHyperplane();
            if (((SubHyperplane$SplitSubHyperplane)(object2 = subHyperplane.split((Hyperplane<S>)object2))).getPlus() != null) {
                if (((SubHyperplane$SplitSubHyperplane)object2).getMinus() != null) {
                    subHyperplane = this.recurseIntersection(((BSPTree)object).getPlus(), ((SubHyperplane$SplitSubHyperplane)object2).getPlus());
                    object = this.recurseIntersection(((BSPTree)object).getMinus(), ((SubHyperplane$SplitSubHyperplane)object2).getMinus());
                    if (subHyperplane == null) {
                        return object;
                    }
                    if (object == null) {
                        return subHyperplane;
                    }
                    return subHyperplane.reunite((SubHyperplane<S>)object);
                }
                object = ((BSPTree)object).getPlus();
                continue;
            }
            if (((SubHyperplane$SplitSubHyperplane)object2).getMinus() != null) {
                object = ((BSPTree)object).getMinus();
                continue;
            }
            subHyperplane = this.recurseIntersection(((BSPTree)object).getMinus(), subHyperplane);
            object = ((BSPTree)object).getPlus();
        }
    }

    public AbstractRegion<S, T> applyTransform(Transform<S, T> object) {
        HashMap<BSPTree<S>, BSPTree<S>> hashMap = new HashMap<BSPTree<S>, BSPTree<S>>();
        AbstractRegion abstractRegion = this;
        object = abstractRegion.recurseTransform(abstractRegion.getTree(false), (Transform<S, T>)object, (Map<BSPTree<S>, BSPTree<S>>)hashMap);
        for (Map.Entry entry : hashMap.entrySet()) {
            Object object2;
            if (((BSPTree)entry.getKey()).getCut() == null || (object2 = (BoundaryAttribute)((BSPTree)entry.getKey()).getAttribute()) == null) continue;
            entry = (BoundaryAttribute)((BSPTree)entry.getValue()).getAttribute();
            object2 = ((BoundaryAttribute)object2).getSplitters().iterator();
            while (object2.hasNext()) {
                BSPTree bSPTree = (BSPTree)object2.next();
                ((BoundaryAttribute)((Object)entry)).getSplitters().add((BSPTree)hashMap.get(bSPTree));
            }
        }
        return this.buildNew((BSPTree)object);
    }

    private BSPTree<S> recurseTransform(BSPTree<S> bSPTree, Transform<S, T> bSPTree2, Map<BSPTree<S>, BSPTree<S>> map) {
        if (bSPTree.getCut() == null) {
            bSPTree2 = new BSPTree(bSPTree.getAttribute());
        } else {
            SubHyperplane<S> subHyperplane = bSPTree.getCut();
            subHyperplane = ((AbstractSubHyperplane)subHyperplane).applyTransform(bSPTree2);
            BoundaryAttribute boundaryAttribute = (BoundaryAttribute)bSPTree.getAttribute();
            if (boundaryAttribute != null) {
                AbstractSubHyperplane abstractSubHyperplane = boundaryAttribute.getPlusOutside() == null ? null : ((AbstractSubHyperplane)boundaryAttribute.getPlusOutside()).applyTransform(bSPTree2);
                boundaryAttribute = boundaryAttribute.getPlusInside() == null ? null : ((AbstractSubHyperplane)boundaryAttribute.getPlusInside()).applyTransform(bSPTree2);
                boundaryAttribute = new BoundaryAttribute(abstractSubHyperplane, boundaryAttribute, new NodesSet());
            }
            bSPTree2 = new BSPTree<S>(subHyperplane, this.recurseTransform(bSPTree.getPlus(), (Transform<S, T>)((Object)bSPTree2), map), this.recurseTransform(bSPTree.getMinus(), (Transform<S, T>)((Object)bSPTree2), map), boundaryAttribute);
        }
        map.put(bSPTree, bSPTree2);
        return bSPTree2;
    }
}

