/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.hull;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Line;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.hull.AbstractConvexHullGenerator2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.hull.MonotoneChain$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonotoneChain
extends AbstractConvexHullGenerator2D {
    public MonotoneChain() {
        this(false);
    }

    public MonotoneChain(boolean bl) {
        super(bl);
    }

    public MonotoneChain(boolean bl, double d2) {
        super(bl, d2);
    }

    @Override
    public Collection<Vector2D> findHullVertices(Collection<Vector2D> collection) {
        int n;
        collection = new ArrayList<Vector2D>(collection);
        Collections.sort(collection, new MonotoneChain$1(this));
        ArrayList<Vector2D> arrayList = new ArrayList<Vector2D>();
        for (Vector2D vector2D : collection) {
            this.updateHull(vector2D, arrayList);
        }
        ArrayList arrayList2 = new ArrayList();
        for (int i2 = collection.size() - 1; i2 >= 0; --i2) {
            Vector2D vector2D = (Vector2D)collection.get(i2);
            this.updateHull(vector2D, arrayList2);
        }
        ArrayList<Vector2D> arrayList3 = new ArrayList<Vector2D>(arrayList.size() + arrayList2.size() - 2);
        for (n = 0; n < arrayList.size() - 1; ++n) {
            arrayList3.add((Vector2D)arrayList.get(n));
        }
        for (n = 0; n < arrayList2.size() - 1; ++n) {
            arrayList3.add((Vector2D)arrayList2.get(n));
        }
        if (arrayList3.isEmpty() && !arrayList.isEmpty()) {
            arrayList3.add((Vector2D)arrayList.get(0));
        }
        return arrayList3;
    }

    private void updateHull(Vector2D vector2D, List<Vector2D> list) {
        double d2 = this.getTolerance();
        if (list.size() == 1) {
            Vector2D vector2D2;
            Vector2D vector2D3 = list.get(0);
            if (vector2D2.distance(vector2D) < d2) {
                return;
            }
        }
        while (list.size() >= 2) {
            double d3;
            int n = list.size();
            Vector2D vector2D4 = list.get(n - 2);
            Vector2D vector2D5 = list.get(n - 1);
            double d4 = new Line(vector2D4, vector2D5, d2).getOffset(vector2D);
            if (FastMath.abs(d3) < d2) {
                double d5 = vector2D4.distance(vector2D);
                if (d5 < d2 || vector2D5.distance(vector2D) < d2) {
                    return;
                }
                double d6 = vector2D4.distance(vector2D5);
                if (this.isIncludeCollinearPoints()) {
                    int n2 = d5 < d6 ? n - 1 : n;
                    list.add(n2, vector2D);
                    return;
                }
                if (d5 > d6) {
                    list.remove(n - 1);
                    list.add(vector2D);
                }
                return;
            }
            if (!(d4 > 0.0)) break;
            list.remove(n - 1);
        }
        list.add(vector2D);
    }
}

