/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.hull;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.InsufficientDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Vector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Line;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Segment;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.hull.ConvexHull;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Region;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.RegionFactory;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvexHull2D
implements ConvexHull<Euclidean2D, Vector2D>,
Serializable {
    private static final long serialVersionUID = 20140129L;
    private final Vector2D[] vertices;
    private final double tolerance;
    private transient Segment[] lineSegments;

    public ConvexHull2D(Vector2D[] vector2DArray, double d2) {
        this.tolerance = d2;
        if (!this.isConvex(vector2DArray)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_CONVEX, new Object[0]);
        }
        this.vertices = (Vector2D[])vector2DArray.clone();
    }

    private boolean isConvex(Vector2D[] vector2DArray) {
        if (vector2DArray.length < 3) {
            return true;
        }
        int n = 0;
        for (int i2 = 0; i2 < vector2DArray.length; ++i2) {
            Vector<Euclidean2D> vector = vector2DArray[i2 == 0 ? vector2DArray.length - 1 : i2 - 1];
            Vector<Euclidean2D> vector2 = vector2DArray[i2];
            Vector2D vector2D = vector2DArray[i2 == vector2DArray.length - 1 ? 0 : i2 + 1];
            vector = ((Vector2D)vector2).subtract((Vector)vector);
            vector2 = vector2D.subtract((Vector)vector2);
            double d2 = MathArrays.linearCombination(((Vector2D)vector).getX(), ((Vector2D)vector2).getY(), -((Vector2D)vector).getY(), ((Vector2D)vector2).getX());
            int n2 = Precision.compareTo(d2, 0.0, this.tolerance);
            if ((double)n2 == 0.0) continue;
            if ((double)n != 0.0 && n2 != n) {
                return false;
            }
            n = n2;
        }
        return true;
    }

    public Vector2D[] getVertices() {
        return (Vector2D[])this.vertices.clone();
    }

    public Segment[] getLineSegments() {
        return (Segment[])this.retrieveLineSegments().clone();
    }

    private Segment[] retrieveLineSegments() {
        if (this.lineSegments == null) {
            int n = this.vertices.length;
            if (n <= 1) {
                this.lineSegments = new Segment[0];
            } else if (n == 2) {
                this.lineSegments = new Segment[1];
                Vector2D vector2D = this.vertices[0];
                Vector2D vector2D2 = this.vertices[1];
                this.lineSegments[0] = new Segment(vector2D, vector2D2, new Line(vector2D, vector2D2, this.tolerance));
            } else {
                this.lineSegments = new Segment[n];
                Vector2D vector2D = null;
                Vector2D vector2D3 = null;
                int n2 = 0;
                Vector2D[] vector2DArray = this.vertices;
                int n3 = this.vertices.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    Vector2D vector2D4 = vector2DArray[i2];
                    if (vector2D3 == null) {
                        vector2D = vector2D4;
                        vector2D3 = vector2D4;
                        continue;
                    }
                    this.lineSegments[n2++] = new Segment(vector2D3, vector2D4, new Line(vector2D3, vector2D4, this.tolerance));
                    vector2D3 = vector2D4;
                }
                this.lineSegments[n2] = new Segment(vector2D3, vector2D, new Line(vector2D3, vector2D, this.tolerance));
            }
        }
        return this.lineSegments;
    }

    @Override
    public Region<Euclidean2D> createRegion() {
        if (this.vertices.length < 3) {
            throw new InsufficientDataException();
        }
        RegionFactory regionFactory = new RegionFactory();
        Segment[] segmentArray = this.retrieveLineSegments();
        Line[] lineArray = new Line[segmentArray.length];
        for (int i2 = 0; i2 < segmentArray.length; ++i2) {
            lineArray[i2] = segmentArray[i2].getLine();
        }
        return regionFactory.buildConvex(lineArray);
    }
}

