/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.hull;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AklToussaintHeuristic {
    private AklToussaintHeuristic() {
    }

    public static Collection<Vector2D> reducePoints(Collection<Vector2D> object) {
        Serializable serializable;
        int n = 0;
        Vector2D vector2D = null;
        Vector2D vector2D2 = null;
        Vector2D vector2D3 = null;
        Vector2D vector2D4 = null;
        List<Vector2D> list = object.iterator();
        while (list.hasNext()) {
            serializable = list.next();
            if (vector2D == null || ((Vector2D)serializable).getX() < vector2D.getX()) {
                vector2D = serializable;
            }
            if (vector2D2 == null || ((Vector2D)serializable).getX() > vector2D2.getX()) {
                vector2D2 = serializable;
            }
            if (vector2D3 == null || ((Vector2D)serializable).getY() < vector2D3.getY()) {
                vector2D3 = serializable;
            }
            if (vector2D4 == null || ((Vector2D)serializable).getY() > vector2D4.getY()) {
                vector2D4 = serializable;
            }
            ++n;
        }
        if (n < 4) {
            return object;
        }
        list = AklToussaintHeuristic.buildQuadrilateral(vector2D3, vector2D2, vector2D4, vector2D);
        if (list.size() < 3) {
            return object;
        }
        serializable = new ArrayList(list);
        object = object.iterator();
        while (object.hasNext()) {
            Vector2D vector2D5 = (Vector2D)object.next();
            if (AklToussaintHeuristic.insideQuadrilateral(vector2D5, list)) continue;
            serializable.add(vector2D5);
        }
        return serializable;
    }

    private static List<Vector2D> buildQuadrilateral(Vector2D ... vector2DArray) {
        ArrayList<Vector2D> arrayList = new ArrayList<Vector2D>();
        for (Vector2D vector2D : vector2DArray) {
            if (arrayList.contains(vector2D)) continue;
            arrayList.add(vector2D);
        }
        return arrayList;
    }

    private static boolean insideQuadrilateral(Vector2D vector2D, List<Vector2D> list) {
        Vector2D vector2D2 = list.get(0);
        Vector2D vector2D3 = list.get(1);
        if (vector2D.equals(vector2D2) || vector2D.equals(vector2D3)) {
            return true;
        }
        double d2 = vector2D.crossProduct(vector2D2, vector2D3);
        int n = list.size();
        for (int i2 = 1; i2 < n; ++i2) {
            vector2D2 = vector2D3;
            vector2D3 = list.get(i2 + 1 == n ? 0 : i2 + 1);
            if (vector2D.equals(vector2D2) || vector2D.equals(vector2D3)) {
                return true;
            }
            if (!(d2 * vector2D.crossProduct(vector2D2, vector2D3) < 0.0)) continue;
            return false;
        }
        return true;
    }
}

