/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.hull;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ConvergenceException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.hull.ConvexHull2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.hull.ConvexHullGenerator2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractConvexHullGenerator2D
implements ConvexHullGenerator2D {
    private static final double DEFAULT_TOLERANCE = 1.0E-10;
    private final double tolerance;
    private final boolean includeCollinearPoints;

    protected AbstractConvexHullGenerator2D(boolean bl) {
        this(bl, 1.0E-10);
    }

    protected AbstractConvexHullGenerator2D(boolean bl, double d2) {
        this.includeCollinearPoints = bl;
        this.tolerance = d2;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public boolean isIncludeCollinearPoints() {
        return this.includeCollinearPoints;
    }

    @Override
    public ConvexHull2D generate(Collection<Vector2D> collection) {
        MathUtils.checkNotNull(collection);
        if (collection.size() >= 2) {
            collection = this.findHullVertices(collection);
        }
        try {
            Collection<Vector2D> collection2 = collection;
            return new ConvexHull2D(collection2.toArray(new Vector2D[collection2.size()]), this.tolerance);
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw new ConvergenceException();
        }
    }

    protected abstract Collection<Vector2D> findHullVertices(Collection<Vector2D> var1);
}

