/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathArithmeticException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Space;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Vector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Vector2DFormat;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.text.NumberFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vector2D
implements Vector<Euclidean2D> {
    public static final Vector2D ZERO = new Vector2D(0.0, 0.0);
    public static final Vector2D NaN = new Vector2D(Double.NaN, Double.NaN);
    public static final Vector2D POSITIVE_INFINITY = new Vector2D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final Vector2D NEGATIVE_INFINITY = new Vector2D(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    private static final long serialVersionUID = 266938651998679754L;
    private final double x;
    private final double y;

    public Vector2D(double d2, double d3) {
        this.x = d2;
        this.y = d3;
    }

    public Vector2D(double[] dArray) {
        if (dArray.length != 2) {
            throw new DimensionMismatchException(dArray.length, 2);
        }
        this.x = dArray[0];
        this.y = dArray[1];
    }

    public Vector2D(double d2, Vector2D vector2D) {
        this.x = d2 * vector2D.x;
        this.y = d2 * vector2D.y;
    }

    public Vector2D(double d2, Vector2D vector2D, double d3, Vector2D vector2D2) {
        this.x = d2 * vector2D.x + d3 * vector2D2.x;
        this.y = d2 * vector2D.y + d3 * vector2D2.y;
    }

    public Vector2D(double d2, Vector2D vector2D, double d3, Vector2D vector2D2, double d4, Vector2D vector2D3) {
        this.x = d2 * vector2D.x + d3 * vector2D2.x + d4 * vector2D3.x;
        this.y = d2 * vector2D.y + d3 * vector2D2.y + d4 * vector2D3.y;
    }

    public Vector2D(double d2, Vector2D vector2D, double d3, Vector2D vector2D2, double d4, Vector2D vector2D3, double d5, Vector2D vector2D4) {
        this.x = d2 * vector2D.x + d3 * vector2D2.x + d4 * vector2D3.x + d5 * vector2D4.x;
        this.y = d2 * vector2D.y + d3 * vector2D2.y + d4 * vector2D3.y + d5 * vector2D4.y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double[] toArray() {
        return new double[]{this.x, this.y};
    }

    @Override
    public Space getSpace() {
        return Euclidean2D.getInstance();
    }

    public Vector2D getZero() {
        return ZERO;
    }

    @Override
    public double getNorm1() {
        return FastMath.abs(this.x) + FastMath.abs(this.y);
    }

    @Override
    public double getNorm() {
        return FastMath.sqrt(this.x * this.x + this.y * this.y);
    }

    @Override
    public double getNormSq() {
        return this.x * this.x + this.y * this.y;
    }

    @Override
    public double getNormInf() {
        return FastMath.max(FastMath.abs(this.x), FastMath.abs(this.y));
    }

    public Vector2D add(Vector<Euclidean2D> vector2D) {
        vector2D = vector2D;
        return new Vector2D(this.x + vector2D.getX(), this.y + vector2D.getY());
    }

    public Vector2D add(double d2, Vector<Euclidean2D> vector2D) {
        vector2D = vector2D;
        return new Vector2D(this.x + d2 * vector2D.getX(), this.y + d2 * vector2D.getY());
    }

    public Vector2D subtract(Vector<Euclidean2D> vector2D) {
        vector2D = vector2D;
        return new Vector2D(this.x - vector2D.x, this.y - vector2D.y);
    }

    public Vector2D subtract(double d2, Vector<Euclidean2D> vector2D) {
        vector2D = vector2D;
        return new Vector2D(this.x - d2 * vector2D.getX(), this.y - d2 * vector2D.getY());
    }

    public Vector2D normalize() {
        double d2 = this.getNorm();
        if (d2 == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.CANNOT_NORMALIZE_A_ZERO_NORM_VECTOR, new Object[0]);
        }
        return this.scalarMultiply(1.0 / d2);
    }

    public static double angle(Vector2D vector2D, Vector2D vector2D2) {
        double d2;
        double d3 = vector2D.getNorm() * vector2D2.getNorm();
        if (d3 == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        double d4 = vector2D.dotProduct(vector2D2);
        if (d4 < -(d2 = d3 * 0.9999) || d4 > d2) {
            double d5 = FastMath.abs(MathArrays.linearCombination(vector2D.x, vector2D2.y, -vector2D.y, vector2D2.x));
            if (d4 >= 0.0) {
                return FastMath.asin(d5 / d3);
            }
            return Math.PI - FastMath.asin(d5 / d3);
        }
        return FastMath.acos(d4 / d3);
    }

    public Vector2D negate() {
        return new Vector2D(-this.x, -this.y);
    }

    public Vector2D scalarMultiply(double d2) {
        return new Vector2D(d2 * this.x, d2 * this.y);
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y);
    }

    @Override
    public boolean isInfinite() {
        return !this.isNaN() && (Double.isInfinite(this.x) || Double.isInfinite(this.y));
    }

    @Override
    public double distance1(Vector<Euclidean2D> vector2D) {
        vector2D = vector2D;
        double d2 = FastMath.abs(vector2D.x - this.x);
        double d3 = FastMath.abs(vector2D.y - this.y);
        return d2 + d3;
    }

    @Override
    public double distance(Vector<Euclidean2D> vector) {
        return this.distance((Point<Euclidean2D>)vector);
    }

    @Override
    public double distance(Point<Euclidean2D> vector2D) {
        vector2D = vector2D;
        double d2 = vector2D.x - this.x;
        double d3 = vector2D.y - this.y;
        double d4 = d2;
        double d5 = d3;
        return FastMath.sqrt(d4 * d4 + d5 * d5);
    }

    @Override
    public double distanceInf(Vector<Euclidean2D> vector2D) {
        vector2D = vector2D;
        double d2 = FastMath.abs(vector2D.x - this.x);
        double d3 = FastMath.abs(vector2D.y - this.y);
        return FastMath.max(d2, d3);
    }

    @Override
    public double distanceSq(Vector<Euclidean2D> vector2D) {
        vector2D = vector2D;
        double d2 = vector2D.x - this.x;
        double d3 = vector2D.y - this.y;
        double d4 = d2;
        double d5 = d3;
        return d4 * d4 + d5 * d5;
    }

    @Override
    public double dotProduct(Vector<Euclidean2D> vector2D) {
        vector2D = vector2D;
        return MathArrays.linearCombination(this.x, vector2D.x, this.y, vector2D.y);
    }

    public double crossProduct(Vector2D vector2D, Vector2D vector2D2) {
        double d2 = vector2D2.getX() - vector2D.getX();
        double d3 = this.getY() - vector2D.getY();
        double d4 = this.getX() - vector2D.getX();
        double d5 = vector2D2.getY() - vector2D.getY();
        return MathArrays.linearCombination(d2, d3, -d4, d5);
    }

    public static double distance(Vector2D vector2D, Vector2D vector2D2) {
        return vector2D.distance(vector2D2);
    }

    public static double distanceInf(Vector2D vector2D, Vector2D vector2D2) {
        return vector2D.distanceInf(vector2D2);
    }

    public static double distanceSq(Vector2D vector2D, Vector2D vector2D2) {
        return vector2D.distanceSq(vector2D2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Vector2D) {
            if (((Vector2D)(object = (Vector2D)object)).isNaN()) {
                return this.isNaN();
            }
            return this.x == ((Vector2D)object).x && this.y == ((Vector2D)object).y;
        }
        return false;
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 542;
        }
        return 122 * (76 * MathUtils.hash(this.x) + MathUtils.hash(this.y));
    }

    public String toString() {
        return Vector2DFormat.getInstance().format(this);
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        return new Vector2DFormat(numberFormat).format(this);
    }
}

