/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Euclidean1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Interval;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.IntervalsSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.OrientedPoint;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Line;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Segment;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.AbstractSubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTree;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Hyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Region;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Region$Location;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane$SplitSubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubLine
extends AbstractSubHyperplane<Euclidean2D, Euclidean1D> {
    private static final double DEFAULT_TOLERANCE = 1.0E-10;

    public SubLine(Hyperplane<Euclidean2D> hyperplane, Region<Euclidean1D> region) {
        super(hyperplane, region);
    }

    public SubLine(Vector2D vector2D, Vector2D vector2D2, double d2) {
        super(new Line(vector2D, vector2D2, d2), SubLine.buildIntervalSet(vector2D, vector2D2, d2));
    }

    @Deprecated
    public SubLine(Vector2D vector2D, Vector2D vector2D2) {
        this(vector2D, vector2D2, 1.0E-10);
    }

    public SubLine(Segment segment) {
        super(segment.getLine(), SubLine.buildIntervalSet(segment.getStart(), segment.getEnd(), segment.getLine().getTolerance()));
    }

    public List<Segment> getSegments() {
        Line line = (Line)this.getHyperplane();
        Object object = ((IntervalsSet)this.getRemainingRegion()).asList();
        ArrayList<Segment> arrayList = new ArrayList<Segment>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Interval)object.next();
            Point point = line.toSpace((Point)new Vector1D(((Interval)object2).getInf()));
            object2 = line.toSpace((Point)new Vector1D(((Interval)object2).getSup()));
            arrayList.add(new Segment((Vector2D)point, (Vector2D)object2, line));
        }
        return arrayList;
    }

    public Vector2D intersection(SubLine object, boolean bl) {
        Line line;
        Object object2 = (Line)this.getHyperplane();
        Vector2D vector2D = object2.intersection(line = (Line)object.getHyperplane());
        if (vector2D == null) {
            return null;
        }
        object2 = this.getRemainingRegion().checkPoint(object2.toSubSpace((Point)vector2D));
        object = object.getRemainingRegion().checkPoint(line.toSubSpace((Point)vector2D));
        if (bl) {
            if (object2 != Region$Location.OUTSIDE && object != Region$Location.OUTSIDE) {
                return vector2D;
            }
            return null;
        }
        if (object2 == Region$Location.INSIDE && object == Region$Location.INSIDE) {
            return vector2D;
        }
        return null;
    }

    private static IntervalsSet buildIntervalSet(Vector2D vector2D, Vector2D vector2D2, double d2) {
        Line line = new Line(vector2D, vector2D2, d2);
        return new IntervalsSet(((Vector1D)line.toSubSpace((Point)vector2D)).getX(), ((Vector1D)line.toSubSpace((Point)vector2D2)).getX(), d2);
    }

    @Override
    protected AbstractSubHyperplane<Euclidean2D, Euclidean1D> buildNew(Hyperplane<Euclidean2D> hyperplane, Region<Euclidean1D> region) {
        return new SubLine(hyperplane, region);
    }

    @Override
    public SubHyperplane$SplitSubHyperplane<Euclidean2D> split(Hyperplane<Euclidean2D> bSPTree) {
        Line line = (Line)this.getHyperplane();
        bSPTree = (Line)((Object)bSPTree);
        BSPTree<Euclidean1D> bSPTree2 = line.intersection((Line)((Object)bSPTree));
        double d2 = line.getTolerance();
        if (bSPTree2 == null) {
            double d3;
            double d4 = ((Line)((Object)bSPTree)).getOffset(line);
            if (d3 < -d2) {
                return new SubHyperplane$SplitSubHyperplane<Euclidean2D>(null, this);
            }
            if (d4 > d2) {
                return new SubHyperplane$SplitSubHyperplane<Euclidean2D>(this, null);
            }
            return new SubHyperplane$SplitSubHyperplane<Euclidean2D>(null, null);
        }
        boolean bl = FastMath.sin(line.getAngle() - ((Line)((Object)bSPTree)).getAngle()) < 0.0;
        Point point = line.toSubSpace((Point)((Object)bSPTree2));
        bSPTree = new OrientedPoint((Vector1D)point, !bl, d2).wholeHyperplane();
        bSPTree2 = new OrientedPoint((Vector1D)point, bl, d2).wholeHyperplane();
        BSPTree bSPTree3 = this.getRemainingRegion().getTree(false).split(bSPTree2);
        bSPTree = this.getRemainingRegion().isEmpty(bSPTree3.getPlus()) ? new BSPTree<Euclidean1D>(Boolean.FALSE) : new BSPTree(bSPTree, new BSPTree(Boolean.FALSE), bSPTree3.getPlus(), null);
        bSPTree2 = this.getRemainingRegion().isEmpty(bSPTree3.getMinus()) ? new BSPTree<Euclidean1D>(Boolean.FALSE) : new BSPTree(bSPTree2, new BSPTree(Boolean.FALSE), bSPTree3.getMinus(), null);
        return new SubHyperplane$SplitSubHyperplane<Euclidean2D>(new SubLine(line.copySelf(), new IntervalsSet(bSPTree, d2)), new SubLine(line.copySelf(), new IntervalsSet(bSPTree2, d2)));
    }
}

