/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Euclidean1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Line;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.PolygonsSet$ConnectableSegment;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.PolygonsSet$Edge;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.PolygonsSet$SegmentsBuilder;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.PolygonsSet$Vertex;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Segment;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.AbstractRegion;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTree;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Hyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Side;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonsSet
extends AbstractRegion<Euclidean2D, Euclidean1D> {
    private static final double DEFAULT_TOLERANCE = 1.0E-10;
    private Vector2D[][] vertices;

    public PolygonsSet(double d2) {
        super(d2);
    }

    public PolygonsSet(BSPTree<Euclidean2D> bSPTree, double d2) {
        super(bSPTree, d2);
    }

    public PolygonsSet(Collection<SubHyperplane<Euclidean2D>> collection, double d2) {
        super(collection, d2);
    }

    public PolygonsSet(double d2, double d3, double d4, double d5, double d6) {
        super(PolygonsSet.boxBoundary(d2, d3, d4, d5, d6), d6);
    }

    public PolygonsSet(double d2, Vector2D ... vector2DArray) {
        super(PolygonsSet.verticesToTree(d2, vector2DArray), d2);
    }

    @Deprecated
    public PolygonsSet() {
        this(1.0E-10);
    }

    @Deprecated
    public PolygonsSet(BSPTree<Euclidean2D> bSPTree) {
        this(bSPTree, 1.0E-10);
    }

    @Deprecated
    public PolygonsSet(Collection<SubHyperplane<Euclidean2D>> collection) {
        this(collection, 1.0E-10);
    }

    @Deprecated
    public PolygonsSet(double d2, double d3, double d4, double d5) {
        this(d2, d3, d4, d5, 1.0E-10);
    }

    private static Line[] boxBoundary(double d2, double d3, double d4, double d5, double d6) {
        if (d2 >= d3 - d6 || d4 >= d5 - d6) {
            return null;
        }
        Vector2D vector2D = new Vector2D(d2, d4);
        Vector2D vector2D2 = new Vector2D(d2, d5);
        Vector2D vector2D3 = new Vector2D(d3, d4);
        Vector2D vector2D4 = new Vector2D(d3, d5);
        return new Line[]{new Line(vector2D, vector2D3, d6), new Line(vector2D3, vector2D4, d6), new Line(vector2D4, vector2D2, d6), new Line(vector2D2, vector2D, d6)};
    }

    private static BSPTree<Euclidean2D> verticesToTree(double d2, Vector2D ... vector2DArray) {
        int n = vector2DArray.length;
        if (n == 0) {
            return new BSPTree<Euclidean2D>(Boolean.TRUE);
        }
        PolygonsSet$Vertex[] polygonsSet$VertexArray = new PolygonsSet$Vertex[n];
        for (int i2 = 0; i2 < n; ++i2) {
            polygonsSet$VertexArray[i2] = new PolygonsSet$Vertex(vector2DArray[i2]);
        }
        ArrayList<PolygonsSet$Edge> arrayList = new ArrayList<PolygonsSet$Edge>(n);
        for (int i3 = 0; i3 < n; ++i3) {
            PolygonsSet$Vertex polygonsSet$Vertex = polygonsSet$VertexArray[i3];
            PolygonsSet$Vertex polygonsSet$Vertex2 = polygonsSet$VertexArray[(i3 + 1) % n];
            Line line = polygonsSet$Vertex.sharedLineWith(polygonsSet$Vertex2);
            if (line == null) {
                line = new Line(polygonsSet$Vertex.getLocation(), polygonsSet$Vertex2.getLocation(), d2);
            }
            arrayList.add(new PolygonsSet$Edge(polygonsSet$Vertex, polygonsSet$Vertex2, line));
            PolygonsSet$Vertex[] polygonsSet$VertexArray2 = polygonsSet$VertexArray;
            int n2 = polygonsSet$VertexArray.length;
            for (int i4 = 0; i4 < n2; ++i4) {
                PolygonsSet$Vertex polygonsSet$Vertex3 = polygonsSet$VertexArray2[i4];
                if (polygonsSet$Vertex3 == polygonsSet$Vertex || polygonsSet$Vertex3 == polygonsSet$Vertex2 || !(FastMath.abs(line.getOffset(polygonsSet$Vertex3.getLocation())) <= d2)) continue;
                polygonsSet$Vertex3.bindWith(line);
            }
        }
        BSPTree<Euclidean2D> bSPTree = new BSPTree<Euclidean2D>();
        PolygonsSet.insertEdges(d2, bSPTree, arrayList);
        return bSPTree;
    }

    private static void insertEdges(double d2, BSPTree<Euclidean2D> bSPTree, List<PolygonsSet$Edge> object) {
        int n = 0;
        PolygonsSet$Edge polygonsSet$Edge = null;
        while (polygonsSet$Edge == null && n < object.size()) {
            if ((polygonsSet$Edge = object.get(n++)).getNode() == null) {
                if (bSPTree.insertCut(polygonsSet$Edge.getLine())) {
                    polygonsSet$Edge.setNode(bSPTree);
                    continue;
                }
                polygonsSet$Edge = null;
                continue;
            }
            polygonsSet$Edge = null;
        }
        if (polygonsSet$Edge == null) {
            BSPTree<Euclidean2D> bSPTree2 = bSPTree.getParent();
            if (bSPTree2 == null || bSPTree == bSPTree2.getMinus()) {
                bSPTree.setAttribute(Boolean.TRUE);
                return;
            }
            bSPTree.setAttribute(Boolean.FALSE);
            return;
        }
        ArrayList<PolygonsSet$Edge> arrayList = new ArrayList<PolygonsSet$Edge>();
        ArrayList<PolygonsSet$Edge> arrayList2 = new ArrayList<PolygonsSet$Edge>();
        object = object.iterator();
        block5: while (object.hasNext()) {
            Side side;
            Object object2 = (PolygonsSet$Edge)object.next();
            if (object2 == polygonsSet$Edge) continue;
            double d3 = polygonsSet$Edge.getLine().getOffset(((PolygonsSet$Edge)object2).getStart().getLocation());
            double d4 = polygonsSet$Edge.getLine().getOffset(((PolygonsSet$Edge)object2).getEnd().getLocation());
            Side side2 = FastMath.abs(d3) <= d2 ? Side.HYPER : (side = d3 < 0.0 ? Side.MINUS : Side.PLUS);
            Side side3 = FastMath.abs(d4) <= d2 ? Side.HYPER : (d4 < 0.0 ? Side.MINUS : Side.PLUS);
            switch (side) {
                case PLUS: {
                    if (side3 == Side.MINUS) {
                        object2 = ((PolygonsSet$Edge)object2).split(polygonsSet$Edge.getLine());
                        arrayList2.add(((PolygonsSet$Vertex)object2).getOutgoing());
                        arrayList.add(((PolygonsSet$Vertex)object2).getIncoming());
                        continue block5;
                    }
                    arrayList.add((PolygonsSet$Edge)object2);
                    continue block5;
                }
                case MINUS: {
                    if (side3 == Side.PLUS) {
                        object2 = ((PolygonsSet$Edge)object2).split(polygonsSet$Edge.getLine());
                        arrayList2.add(((PolygonsSet$Vertex)object2).getIncoming());
                        arrayList.add(((PolygonsSet$Vertex)object2).getOutgoing());
                        continue block5;
                    }
                    arrayList2.add((PolygonsSet$Edge)object2);
                    continue block5;
                }
            }
            if (side3 == Side.PLUS) {
                arrayList.add((PolygonsSet$Edge)object2);
                continue;
            }
            if (side3 != Side.MINUS) continue;
            arrayList2.add((PolygonsSet$Edge)object2);
        }
        if (!arrayList.isEmpty()) {
            PolygonsSet.insertEdges(d2, bSPTree.getPlus(), arrayList);
        } else {
            bSPTree.getPlus().setAttribute(Boolean.FALSE);
        }
        if (!arrayList2.isEmpty()) {
            PolygonsSet.insertEdges(d2, bSPTree.getMinus(), arrayList2);
            return;
        }
        bSPTree.getMinus().setAttribute(Boolean.TRUE);
    }

    public PolygonsSet buildNew(BSPTree<Euclidean2D> bSPTree) {
        return new PolygonsSet(bSPTree, this.getTolerance());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void computeGeometricalProperties() {
        Vector2D[][] vector2DArray = this.getVertices();
        if (vector2DArray.length == 0) {
            BSPTree bSPTree = this.getTree(false);
            if (bSPTree.getCut() == null && ((Boolean)bSPTree.getAttribute()).booleanValue()) {
                this.setSize(Double.POSITIVE_INFINITY);
                this.setBarycenter(Vector2D.NaN);
                return;
            }
            this.setSize(0.0);
            this.setBarycenter(new Vector2D(0.0, 0.0));
            return;
        }
        if (vector2DArray[0][0] == null) {
            this.setSize(Double.POSITIVE_INFINITY);
            this.setBarycenter(Vector2D.NaN);
            return;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (Vector2D[] vector2DArray2 : vector2DArray) {
            double d5;
            double d6;
            double d7;
            double d8 = vector2DArray2[vector2DArray2.length - 1].getX();
            double d9 = vector2DArray2[vector2DArray2.length - 1].getY();
            int n = vector2DArray2.length;
            for (int i2 = 0; i2 < n; d2 += d7, d3 += d7 * (d6 + d8), d4 += d7 * (d5 + d9), ++i2) {
                Vector2D vector2D = vector2DArray2[i2];
                d6 = d8;
                d5 = d9;
                d8 = vector2D.getX();
                d9 = vector2D.getY();
                d7 = d6 * d9 - d5 * d8;
            }
        }
        if (d2 < 0.0) {
            this.setSize(Double.POSITIVE_INFINITY);
            this.setBarycenter(Vector2D.NaN);
            return;
        }
        this.setSize(d2 / 2.0);
        this.setBarycenter(new Vector2D(d3 / (d2 * 3.0), d4 / (d2 * 3.0)));
    }

    public Vector2D[][] getVertices() {
        if (this.vertices == null) {
            if (this.getTree(false).getCut() == null) {
                this.vertices = new Vector2D[0][];
            } else {
                PolygonsSet$SegmentsBuilder object2 = new PolygonsSet$SegmentsBuilder(this.getTolerance());
                this.getTree(true).visit(object2);
                List<PolygonsSet$ConnectableSegment> list = object2.getSegments();
                int n = list.size();
                if ((n -= this.naturalFollowerConnections(list)) > 0) {
                    n -= this.splitEdgeConnections(list);
                }
                if (n > 0) {
                    this.closeVerticesConnections(list);
                }
                Vector2D[] vector2DArray = new ArrayList<Object>();
                PolygonsSet$ConnectableSegment polygonsSet$ConnectableSegment = this.getUnprocessed(list);
                while (polygonsSet$ConnectableSegment != null) {
                    List<Segment> list2 = this.followLoop(polygonsSet$ConnectableSegment);
                    if (list2 != null) {
                        if (list2.get(0).getStart() == null) {
                            vector2DArray.add(0, list2);
                        } else {
                            vector2DArray.add(list2);
                        }
                    }
                    polygonsSet$ConnectableSegment = this.getUnprocessed(list);
                }
                this.vertices = new Vector2D[vector2DArray.size()][];
                int n2 = 0;
                for (List list3 : vector2DArray) {
                    int n3;
                    if (list3.size() < 2 || list3.size() == 2 && ((Segment)list3.get(0)).getStart() == null && ((Segment)list3.get(1)).getEnd() == null) {
                        vector2DArray = ((Segment)list3.get(0)).getLine();
                        this.vertices[n2++] = new Vector2D[]{null, vector2DArray.toSpace((Point)new Vector1D(-3.4028234663852886E38)), vector2DArray.toSpace((Point)new Vector1D(3.4028234663852886E38))};
                        continue;
                    }
                    if (((Segment)list3.get(0)).getStart() == null) {
                        vector2DArray = new Vector2D[list3.size() + 2];
                        n3 = 0;
                        for (Segment segment : list3) {
                            double d2;
                            if (n3 == 0) {
                                d2 = ((Vector1D)segment.getLine().toSubSpace((Point)segment.getEnd())).getX();
                                d2 -= FastMath.max(1.0, FastMath.abs(d2 / 2.0));
                                vector2DArray[n3++] = null;
                                vector2DArray[n3++] = segment.getLine().toSpace((Point)new Vector1D(d2));
                            }
                            if (n3 < vector2DArray.length - 1) {
                                vector2DArray[n3++] = segment.getEnd();
                            }
                            if (n3 != vector2DArray.length - 1) continue;
                            d2 = ((Vector1D)segment.getLine().toSubSpace((Point)segment.getStart())).getX();
                            d2 += FastMath.max(1.0, FastMath.abs(d2 / 2.0));
                            vector2DArray[n3++] = segment.getLine().toSpace((Point)new Vector1D(d2));
                        }
                        this.vertices[n2++] = vector2DArray;
                        continue;
                    }
                    vector2DArray = new Vector2D[list3.size()];
                    n3 = 0;
                    for (Segment segment : list3) {
                        vector2DArray[n3++] = segment.getStart();
                    }
                    this.vertices[n2++] = vector2DArray;
                }
            }
        }
        return (Vector2D[][])this.vertices.clone();
    }

    private int naturalFollowerConnections(List<PolygonsSet$ConnectableSegment> list) {
        int n = 0;
        block0: for (PolygonsSet$ConnectableSegment polygonsSet$ConnectableSegment : list) {
            if (polygonsSet$ConnectableSegment.getNext() != null) continue;
            BSPTree<Euclidean2D> bSPTree = polygonsSet$ConnectableSegment.getNode();
            BSPTree<Euclidean2D> bSPTree2 = polygonsSet$ConnectableSegment.getEndNode();
            for (PolygonsSet$ConnectableSegment polygonsSet$ConnectableSegment2 : list) {
                if (polygonsSet$ConnectableSegment2.getPrevious() != null || polygonsSet$ConnectableSegment2.getNode() != bSPTree2 || polygonsSet$ConnectableSegment2.getStartNode() != bSPTree) continue;
                polygonsSet$ConnectableSegment.setNext(polygonsSet$ConnectableSegment2);
                polygonsSet$ConnectableSegment2.setPrevious(polygonsSet$ConnectableSegment);
                ++n;
                continue block0;
            }
        }
        return n;
    }

    private int splitEdgeConnections(List<PolygonsSet$ConnectableSegment> list) {
        int n = 0;
        block0: for (PolygonsSet$ConnectableSegment polygonsSet$ConnectableSegment : list) {
            if (polygonsSet$ConnectableSegment.getNext() != null) continue;
            Hyperplane<Euclidean2D> hyperplane = polygonsSet$ConnectableSegment.getNode().getCut().getHyperplane();
            BSPTree<Euclidean2D> bSPTree = polygonsSet$ConnectableSegment.getEndNode();
            for (PolygonsSet$ConnectableSegment polygonsSet$ConnectableSegment2 : list) {
                if (polygonsSet$ConnectableSegment2.getPrevious() != null || polygonsSet$ConnectableSegment2.getNode().getCut().getHyperplane() != hyperplane || polygonsSet$ConnectableSegment2.getStartNode() != bSPTree) continue;
                polygonsSet$ConnectableSegment.setNext(polygonsSet$ConnectableSegment2);
                polygonsSet$ConnectableSegment2.setPrevious(polygonsSet$ConnectableSegment);
                ++n;
                continue block0;
            }
        }
        return n;
    }

    private int closeVerticesConnections(List<PolygonsSet$ConnectableSegment> list) {
        int n = 0;
        for (PolygonsSet$ConnectableSegment polygonsSet$ConnectableSegment : list) {
            if (polygonsSet$ConnectableSegment.getNext() != null || polygonsSet$ConnectableSegment.getEnd() == null) continue;
            Vector2D vector2D = polygonsSet$ConnectableSegment.getEnd();
            PolygonsSet$ConnectableSegment polygonsSet$ConnectableSegment2 = null;
            double d2 = Double.POSITIVE_INFINITY;
            for (PolygonsSet$ConnectableSegment polygonsSet$ConnectableSegment3 : list) {
                double d3;
                if (polygonsSet$ConnectableSegment3.getPrevious() != null || polygonsSet$ConnectableSegment3.getStart() == null) continue;
                double d4 = Vector2D.distance(vector2D, polygonsSet$ConnectableSegment3.getStart());
                if (!(d3 < d2)) continue;
                polygonsSet$ConnectableSegment2 = polygonsSet$ConnectableSegment3;
                d2 = d4;
            }
            if (!(d2 <= this.getTolerance())) continue;
            polygonsSet$ConnectableSegment.setNext(polygonsSet$ConnectableSegment2);
            polygonsSet$ConnectableSegment2.setPrevious(polygonsSet$ConnectableSegment);
            ++n;
        }
        return n;
    }

    private PolygonsSet$ConnectableSegment getUnprocessed(List<PolygonsSet$ConnectableSegment> object) {
        object = object.iterator();
        while (object.hasNext()) {
            PolygonsSet$ConnectableSegment polygonsSet$ConnectableSegment = (PolygonsSet$ConnectableSegment)object.next();
            if (polygonsSet$ConnectableSegment.isProcessed()) continue;
            return polygonsSet$ConnectableSegment;
        }
        return null;
    }

    private List<Segment> followLoop(PolygonsSet$ConnectableSegment polygonsSet$ConnectableSegment) {
        PolygonsSet$ConnectableSegment polygonsSet$ConnectableSegment2;
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        arrayList.add(polygonsSet$ConnectableSegment);
        polygonsSet$ConnectableSegment.setProcessed(true);
        for (polygonsSet$ConnectableSegment2 = polygonsSet$ConnectableSegment.getNext(); polygonsSet$ConnectableSegment2 != polygonsSet$ConnectableSegment && polygonsSet$ConnectableSegment2 != null; polygonsSet$ConnectableSegment2 = polygonsSet$ConnectableSegment2.getNext()) {
            arrayList.add(polygonsSet$ConnectableSegment2);
            polygonsSet$ConnectableSegment2.setProcessed(true);
        }
        if (polygonsSet$ConnectableSegment2 == null) {
            for (polygonsSet$ConnectableSegment = polygonsSet$ConnectableSegment.getPrevious(); polygonsSet$ConnectableSegment != null; polygonsSet$ConnectableSegment = polygonsSet$ConnectableSegment.getPrevious()) {
                arrayList.add(0, polygonsSet$ConnectableSegment);
                polygonsSet$ConnectableSegment.setProcessed(true);
            }
        }
        this.filterSpuriousVertices(arrayList);
        if (arrayList.size() == 2 && ((Segment)arrayList.get(0)).getStart() != null) {
            return null;
        }
        return arrayList;
    }

    private void filterSpuriousVertices(List<Segment> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Segment segment = list.get(i2);
            int n = (i2 + 1) % list.size();
            Segment segment2 = list.get(n);
            if (segment2 == null || !Precision.equals(segment.getLine().getAngle(), segment2.getLine().getAngle(), Precision.EPSILON)) continue;
            list.set(n, new Segment(segment.getStart(), segment2.getEnd(), segment.getLine()));
            list.remove(i2--);
        }
    }
}

