/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Interval;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.IntervalsSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Line;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.PolygonsSet$ConnectableSegment;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.AbstractSubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTree;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTreeVisitor$Order;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BoundaryAttribute;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.NodesSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PolygonsSet$SegmentsBuilder
implements BSPTreeVisitor<Euclidean2D> {
    private final double tolerance;
    private final List<PolygonsSet$ConnectableSegment> segments;

    PolygonsSet$SegmentsBuilder(double d2) {
        this.tolerance = d2;
        this.segments = new ArrayList<PolygonsSet$ConnectableSegment>();
    }

    @Override
    public BSPTreeVisitor$Order visitOrder(BSPTree<Euclidean2D> bSPTree) {
        return BSPTreeVisitor$Order.MINUS_SUB_PLUS;
    }

    @Override
    public void visitInternalNode(BSPTree<Euclidean2D> bSPTree) {
        BoundaryAttribute boundaryAttribute = (BoundaryAttribute)bSPTree.getAttribute();
        NodesSet<Euclidean2D> nodesSet = boundaryAttribute.getSplitters();
        if (boundaryAttribute.getPlusOutside() != null) {
            this.addContribution(boundaryAttribute.getPlusOutside(), bSPTree, nodesSet, false);
        }
        if (boundaryAttribute.getPlusInside() != null) {
            this.addContribution(boundaryAttribute.getPlusInside(), bSPTree, nodesSet, true);
        }
    }

    @Override
    public void visitLeafNode(BSPTree<Euclidean2D> bSPTree) {
    }

    private void addContribution(SubHyperplane<Euclidean2D> object, BSPTree<Euclidean2D> bSPTree, Iterable<BSPTree<Euclidean2D>> iterable, boolean bl) {
        Iterator<Interval> iterator = (AbstractSubHyperplane)object;
        object = (Line)object.getHyperplane();
        iterator = ((IntervalsSet)((AbstractSubHyperplane)((Object)iterator)).getRemainingRegion()).asList();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Interval interval = iterator.next();
            Point point = Double.isInfinite(interval.getInf()) ? null : ((Line)object).toSpace((Point)new Vector1D(interval.getInf()));
            interval = Double.isInfinite(interval.getSup()) ? null : ((Line)object).toSpace((Point)new Vector1D(interval.getSup()));
            BSPTree<Euclidean2D> bSPTree2 = this.selectClosest((Vector2D)point, iterable);
            BSPTree<Euclidean2D> bSPTree3 = this.selectClosest((Vector2D)((Object)interval), iterable);
            if (bl) {
                this.segments.add(new PolygonsSet$ConnectableSegment((Vector2D)((Object)interval), (Vector2D)point, ((Line)object).getReverse(), bSPTree, bSPTree3, bSPTree2));
                continue;
            }
            this.segments.add(new PolygonsSet$ConnectableSegment((Vector2D)point, (Vector2D)((Object)interval), (Line)object, bSPTree, bSPTree2, bSPTree3));
        }
    }

    private BSPTree<Euclidean2D> selectClosest(Vector2D vector2D, Iterable<BSPTree<Euclidean2D>> object) {
        BSPTree bSPTree = null;
        double d2 = Double.POSITIVE_INFINITY;
        object = object.iterator();
        while (object.hasNext()) {
            double d3;
            BSPTree bSPTree2 = (BSPTree)object.next();
            double d4 = FastMath.abs(bSPTree2.getCut().getHyperplane().getOffset(vector2D));
            if (!(d3 < d2)) continue;
            bSPTree = bSPTree2;
            d2 = d4;
        }
        if (d2 <= this.tolerance) {
            return bSPTree;
        }
        return null;
    }

    public List<PolygonsSet$ConnectableSegment> getSegments() {
        return this.segments;
    }
}

