/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Euclidean1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.IntervalsSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Line;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.PolygonsSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.SubLine;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Region;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.RegionFactory;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class NestedLoops {
    private Vector2D[] loop;
    private List<NestedLoops> surrounded;
    private Region<Euclidean2D> polygon;
    private boolean originalIsClockwise;
    private final double tolerance;

    NestedLoops(double d2) {
        this.surrounded = new ArrayList<NestedLoops>();
        this.tolerance = d2;
    }

    private NestedLoops(Vector2D[] vector2DArray, double d2) {
        if (vector2DArray[0] == null) {
            throw new MathIllegalArgumentException(LocalizedFormats.OUTLINE_BOUNDARY_LOOP_OPEN, new Object[0]);
        }
        this.loop = vector2DArray;
        this.surrounded = new ArrayList<NestedLoops>();
        this.tolerance = d2;
        ArrayList<SubHyperplane<Euclidean2D>> arrayList = new ArrayList<SubHyperplane<Euclidean2D>>();
        Vector2D vector2D = vector2DArray[vector2DArray.length - 1];
        for (int i2 = 0; i2 < vector2DArray.length; ++i2) {
            Object object = vector2D;
            vector2D = vector2DArray[i2];
            Line line = new Line((Vector2D)object, vector2D, d2);
            object = new IntervalsSet(((Vector1D)line.toSubSpace((Point)object)).getX(), ((Vector1D)line.toSubSpace((Point)vector2D)).getX(), d2);
            arrayList.add(new SubLine(line, (Region<Euclidean1D>)object));
        }
        this.polygon = new PolygonsSet((Collection<SubHyperplane<Euclidean2D>>)arrayList, d2);
        if (Double.isInfinite(this.polygon.getSize())) {
            this.polygon = new RegionFactory<Euclidean2D>().getComplement(this.polygon);
            this.originalIsClockwise = false;
            return;
        }
        this.originalIsClockwise = true;
    }

    public void add(Vector2D[] vector2DArray) {
        this.add(new NestedLoops(vector2DArray, this.tolerance));
    }

    private void add(NestedLoops nestedLoops) {
        NestedLoops nestedLoops2;
        block0: while (true) {
            for (NestedLoops object2 : nestedLoops2.surrounded) {
                if (!object2.polygon.contains(nestedLoops.polygon)) continue;
                nestedLoops2 = object2;
                continue block0;
            }
            break;
        }
        Object object = nestedLoops2.surrounded.iterator();
        while (object.hasNext()) {
            NestedLoops nestedLoops3 = object.next();
            if (!nestedLoops.polygon.contains(nestedLoops3.polygon)) continue;
            nestedLoops.surrounded.add(nestedLoops3);
            object.remove();
        }
        object = new RegionFactory();
        for (NestedLoops nestedLoops4 : nestedLoops2.surrounded) {
            if (((RegionFactory)object).intersection(nestedLoops.polygon, nestedLoops4.polygon).isEmpty()) continue;
            throw new MathIllegalArgumentException(LocalizedFormats.CROSSING_BOUNDARY_LOOPS, new Object[0]);
        }
        nestedLoops2.surrounded.add(nestedLoops);
    }

    public void correctOrientation() {
        for (NestedLoops nestedLoops : this.surrounded) {
            nestedLoops.setClockWise(true);
        }
    }

    private void setClockWise(boolean bl) {
        if (this.originalIsClockwise ^ bl) {
            int n = -1;
            int n2 = this.loop.length;
            while (++n < --n2) {
                Vector2D vector2D = this.loop[n];
                this.loop[n] = this.loop[n2];
                this.loop[n2] = vector2D;
            }
        }
        for (NestedLoops nestedLoops : this.surrounded) {
            nestedLoops.setClockWise(!bl);
        }
    }
}

