/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Vector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Euclidean1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.IntervalsSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Line$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Line$LineTransform;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.PolygonsSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.SubLine;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Embedding;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Hyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Transform;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.awt.geom.AffineTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Line
implements Embedding<Euclidean2D, Euclidean1D>,
Hyperplane<Euclidean2D> {
    private static final double DEFAULT_TOLERANCE = 1.0E-10;
    private double angle;
    private double cos;
    private double sin;
    private double originOffset;
    private final double tolerance;
    private Line reverse;

    public Line(Vector2D vector2D, Vector2D vector2D2, double d2) {
        this.reset(vector2D, vector2D2);
        this.tolerance = d2;
    }

    public Line(Vector2D vector2D, double d2, double d3) {
        this.reset(vector2D, d2);
        this.tolerance = d3;
    }

    private Line(double d2, double d3, double d4, double d5, double d6) {
        this.angle = d2;
        this.cos = d3;
        this.sin = d4;
        this.originOffset = d5;
        this.tolerance = d6;
        this.reverse = null;
    }

    @Deprecated
    public Line(Vector2D vector2D, Vector2D vector2D2) {
        this(vector2D, vector2D2, 1.0E-10);
    }

    @Deprecated
    public Line(Vector2D vector2D, double d2) {
        this(vector2D, d2, 1.0E-10);
    }

    public Line(Line line) {
        this.angle = MathUtils.normalizeAngle(line.angle, Math.PI);
        this.cos = line.cos;
        this.sin = line.sin;
        this.originOffset = line.originOffset;
        this.tolerance = line.tolerance;
        this.reverse = null;
    }

    public Line copySelf() {
        return new Line(this);
    }

    public void reset(Vector2D vector2D, Vector2D vector2D2) {
        this.unlinkReverse();
        double d2 = vector2D2.getX() - vector2D.getX();
        double d3 = vector2D2.getY() - vector2D.getY();
        double d4 = FastMath.hypot(d2, d3);
        if (d4 == 0.0) {
            this.angle = 0.0;
            this.cos = 1.0;
            this.sin = 0.0;
            this.originOffset = vector2D.getY();
            return;
        }
        this.angle = Math.PI + FastMath.atan2(-d3, -d2);
        this.cos = d2 / d4;
        this.sin = d3 / d4;
        this.originOffset = MathArrays.linearCombination(vector2D2.getX(), vector2D.getY(), -vector2D.getX(), vector2D2.getY()) / d4;
    }

    public void reset(Vector2D vector2D, double d2) {
        this.unlinkReverse();
        this.angle = MathUtils.normalizeAngle(d2, Math.PI);
        this.cos = FastMath.cos(this.angle);
        this.sin = FastMath.sin(this.angle);
        this.originOffset = MathArrays.linearCombination(this.cos, vector2D.getY(), -this.sin, vector2D.getX());
    }

    public void revertSelf() {
        this.unlinkReverse();
        this.angle = this.angle < Math.PI ? (this.angle += Math.PI) : (this.angle -= Math.PI);
        this.cos = -this.cos;
        this.sin = -this.sin;
        this.originOffset = -this.originOffset;
    }

    private void unlinkReverse() {
        if (this.reverse != null) {
            this.reverse.reverse = null;
        }
        this.reverse = null;
    }

    public Line getReverse() {
        if (this.reverse == null) {
            this.reverse = new Line(this.angle < Math.PI ? this.angle + Math.PI : this.angle - Math.PI, -this.cos, -this.sin, -this.originOffset, this.tolerance);
            this.reverse.reverse = this;
        }
        return this.reverse;
    }

    public Vector1D toSubSpace(Vector<Euclidean2D> vector) {
        return this.toSubSpace((Point)vector);
    }

    public Vector2D toSpace(Vector<Euclidean1D> vector) {
        return this.toSpace((Point)vector);
    }

    public Vector1D toSubSpace(Point<Euclidean2D> vector2D) {
        vector2D = vector2D;
        return new Vector1D(MathArrays.linearCombination(this.cos, vector2D.getX(), this.sin, vector2D.getY()));
    }

    public Vector2D toSpace(Point<Euclidean1D> point) {
        double d2 = ((Vector1D)point).getX();
        return new Vector2D(MathArrays.linearCombination(d2, this.cos, -this.originOffset, this.sin), MathArrays.linearCombination(d2, this.sin, this.originOffset, this.cos));
    }

    public Vector2D intersection(Line line) {
        double d2;
        double d3 = MathArrays.linearCombination(this.sin, line.cos, -line.sin, this.cos);
        if (FastMath.abs(d2) < this.tolerance) {
            return null;
        }
        return new Vector2D(MathArrays.linearCombination(this.cos, line.originOffset, -line.cos, this.originOffset) / d3, MathArrays.linearCombination(this.sin, line.originOffset, -line.sin, this.originOffset) / d3);
    }

    @Override
    public Point<Euclidean2D> project(Point<Euclidean2D> point) {
        Line line = this;
        return line.toSpace((Vector<Euclidean1D>)line.toSubSpace((Point)point));
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    public SubLine wholeHyperplane() {
        return new SubLine(this, new IntervalsSet(this.tolerance));
    }

    public PolygonsSet wholeSpace() {
        return new PolygonsSet(this.tolerance);
    }

    public double getOffset(Line line) {
        return this.originOffset + (MathArrays.linearCombination(this.cos, line.cos, this.sin, line.sin) > 0.0 ? -line.originOffset : line.originOffset);
    }

    @Override
    public double getOffset(Vector<Euclidean2D> vector) {
        return this.getOffset((Point<Euclidean2D>)vector);
    }

    @Override
    public double getOffset(Point<Euclidean2D> vector2D) {
        vector2D = vector2D;
        return MathArrays.linearCombination(this.sin, vector2D.getX(), -this.cos, vector2D.getY(), 1.0, this.originOffset);
    }

    @Override
    public boolean sameOrientationAs(Hyperplane<Euclidean2D> line) {
        line = line;
        return MathArrays.linearCombination(this.sin, line.sin, this.cos, line.cos) >= 0.0;
    }

    public Vector2D getPointAt(Vector1D vector1D, double d2) {
        double d3 = vector1D.getX();
        double d4 = d2 - this.originOffset;
        return new Vector2D(MathArrays.linearCombination(d3, this.cos, d4, this.sin), MathArrays.linearCombination(d3, this.sin, -d4, this.cos));
    }

    public boolean contains(Vector2D vector2D) {
        return FastMath.abs(this.getOffset(vector2D)) < this.tolerance;
    }

    public double distance(Vector2D vector2D) {
        return FastMath.abs(this.getOffset(vector2D));
    }

    public boolean isParallelTo(Line line) {
        return FastMath.abs(MathArrays.linearCombination(this.sin, line.cos, -this.cos, line.sin)) < this.tolerance;
    }

    public void translateToPoint(Vector2D vector2D) {
        this.originOffset = MathArrays.linearCombination(this.cos, vector2D.getY(), -this.sin, vector2D.getX());
    }

    public double getAngle() {
        return MathUtils.normalizeAngle(this.angle, Math.PI);
    }

    public void setAngle(double d2) {
        this.unlinkReverse();
        this.angle = MathUtils.normalizeAngle(d2, Math.PI);
        this.cos = FastMath.cos(this.angle);
        this.sin = FastMath.sin(this.angle);
    }

    public double getOriginOffset() {
        return this.originOffset;
    }

    public void setOriginOffset(double d2) {
        this.unlinkReverse();
        this.originOffset = d2;
    }

    @Deprecated
    public static Transform<Euclidean2D, Euclidean1D> getTransform(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        return new Line$LineTransform(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
    }

    public static Transform<Euclidean2D, Euclidean1D> getTransform(double d2, double d3, double d4, double d5, double d6, double d7) {
        return new Line$LineTransform(d2, d3, d4, d5, d6, d7);
    }

    static /* synthetic */ double access$000(Line line) {
        return line.cos;
    }

    static /* synthetic */ double access$100(Line line) {
        return line.sin;
    }

    static /* synthetic */ double access$200(Line line) {
        return line.originOffset;
    }

    static /* synthetic */ double access$300(Line line) {
        return line.tolerance;
    }

    /* synthetic */ Line(double d2, double d3, double d4, double d5, double d6, Line$1 line$1) {
        this(d2, d3, d4, d5, d6);
    }
}

