/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathParseException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Vector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.VectorFormat;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Euclidean3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.CompositeFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vector3DFormat
extends VectorFormat<Euclidean3D> {
    public Vector3DFormat() {
        super("{", "}", "; ", CompositeFormat.getDefaultNumberFormat());
    }

    public Vector3DFormat(NumberFormat numberFormat) {
        super("{", "}", "; ", numberFormat);
    }

    public Vector3DFormat(String string, String string2, String string3) {
        super(string, string2, string3, CompositeFormat.getDefaultNumberFormat());
    }

    public Vector3DFormat(String string, String string2, String string3, NumberFormat numberFormat) {
        super(string, string2, string3, numberFormat);
    }

    public static Vector3DFormat getInstance() {
        return Vector3DFormat.getInstance(Locale.getDefault());
    }

    public static Vector3DFormat getInstance(Locale locale) {
        return new Vector3DFormat(CompositeFormat.getDefaultNumberFormat(locale));
    }

    @Override
    public StringBuffer format(Vector<Euclidean3D> vector3D, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        vector3D = vector3D;
        return this.format(stringBuffer, fieldPosition, vector3D.getX(), vector3D.getY(), vector3D.getZ());
    }

    public Vector3D parse(String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        Vector3D vector3D = this.parse(string, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new MathParseException(string, parsePosition.getErrorIndex(), Vector3D.class);
        }
        return vector3D;
    }

    public Vector3D parse(String object, ParsePosition parsePosition) {
        double[] dArray = this.parseCoordinates(3, (String)object, parsePosition);
        object = dArray;
        if (dArray == null) {
            return null;
        }
        return new Vector3D((double)object[0], (double)object[1], (double)object[2]);
    }
}

