/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathArithmeticException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Space;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Vector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Euclidean3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Vector3DFormat;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.Serializable;
import java.text.NumberFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vector3D
implements Vector<Euclidean3D>,
Serializable {
    public static final Vector3D ZERO = new Vector3D(0.0, 0.0, 0.0);
    public static final Vector3D PLUS_I = new Vector3D(1.0, 0.0, 0.0);
    public static final Vector3D MINUS_I = new Vector3D(-1.0, 0.0, 0.0);
    public static final Vector3D PLUS_J = new Vector3D(0.0, 1.0, 0.0);
    public static final Vector3D MINUS_J = new Vector3D(0.0, -1.0, 0.0);
    public static final Vector3D PLUS_K = new Vector3D(0.0, 0.0, 1.0);
    public static final Vector3D MINUS_K = new Vector3D(0.0, 0.0, -1.0);
    public static final Vector3D NaN = new Vector3D(Double.NaN, Double.NaN, Double.NaN);
    public static final Vector3D POSITIVE_INFINITY = new Vector3D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final Vector3D NEGATIVE_INFINITY = new Vector3D(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    private static final long serialVersionUID = 1313493323784566947L;
    private final double x;
    private final double y;
    private final double z;

    public Vector3D(double d2, double d3, double d4) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
    }

    public Vector3D(double[] dArray) {
        if (dArray.length != 3) {
            throw new DimensionMismatchException(dArray.length, 3);
        }
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
    }

    public Vector3D(double d2, double d3) {
        double d4 = FastMath.cos(d3);
        this.x = FastMath.cos(d2) * d4;
        this.y = FastMath.sin(d2) * d4;
        this.z = FastMath.sin(d3);
    }

    public Vector3D(double d2, Vector3D vector3D) {
        this.x = d2 * vector3D.x;
        this.y = d2 * vector3D.y;
        this.z = d2 * vector3D.z;
    }

    public Vector3D(double d2, Vector3D vector3D, double d3, Vector3D vector3D2) {
        this.x = MathArrays.linearCombination(d2, vector3D.x, d3, vector3D2.x);
        this.y = MathArrays.linearCombination(d2, vector3D.y, d3, vector3D2.y);
        this.z = MathArrays.linearCombination(d2, vector3D.z, d3, vector3D2.z);
    }

    public Vector3D(double d2, Vector3D vector3D, double d3, Vector3D vector3D2, double d4, Vector3D vector3D3) {
        this.x = MathArrays.linearCombination(d2, vector3D.x, d3, vector3D2.x, d4, vector3D3.x);
        this.y = MathArrays.linearCombination(d2, vector3D.y, d3, vector3D2.y, d4, vector3D3.y);
        this.z = MathArrays.linearCombination(d2, vector3D.z, d3, vector3D2.z, d4, vector3D3.z);
    }

    public Vector3D(double d2, Vector3D vector3D, double d3, Vector3D vector3D2, double d4, Vector3D vector3D3, double d5, Vector3D vector3D4) {
        this.x = MathArrays.linearCombination(d2, vector3D.x, d3, vector3D2.x, d4, vector3D3.x, d5, vector3D4.x);
        this.y = MathArrays.linearCombination(d2, vector3D.y, d3, vector3D2.y, d4, vector3D3.y, d5, vector3D4.y);
        this.z = MathArrays.linearCombination(d2, vector3D.z, d3, vector3D2.z, d4, vector3D3.z, d5, vector3D4.z);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double[] toArray() {
        return new double[]{this.x, this.y, this.z};
    }

    @Override
    public Space getSpace() {
        return Euclidean3D.getInstance();
    }

    public Vector3D getZero() {
        return ZERO;
    }

    @Override
    public double getNorm1() {
        return FastMath.abs(this.x) + FastMath.abs(this.y) + FastMath.abs(this.z);
    }

    @Override
    public double getNorm() {
        return FastMath.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    @Override
    public double getNormSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    @Override
    public double getNormInf() {
        return FastMath.max(FastMath.max(FastMath.abs(this.x), FastMath.abs(this.y)), FastMath.abs(this.z));
    }

    public double getAlpha() {
        return FastMath.atan2(this.y, this.x);
    }

    public double getDelta() {
        return FastMath.asin(this.z / this.getNorm());
    }

    public Vector3D add(Vector<Euclidean3D> vector3D) {
        vector3D = vector3D;
        return new Vector3D(this.x + vector3D.x, this.y + vector3D.y, this.z + vector3D.z);
    }

    public Vector3D add(double d2, Vector<Euclidean3D> vector) {
        return new Vector3D(1.0, this, d2, (Vector3D)vector);
    }

    public Vector3D subtract(Vector<Euclidean3D> vector3D) {
        vector3D = vector3D;
        return new Vector3D(this.x - vector3D.x, this.y - vector3D.y, this.z - vector3D.z);
    }

    public Vector3D subtract(double d2, Vector<Euclidean3D> vector) {
        return new Vector3D(1.0, this, -d2, (Vector3D)vector);
    }

    public Vector3D normalize() {
        double d2 = this.getNorm();
        if (d2 == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.CANNOT_NORMALIZE_A_ZERO_NORM_VECTOR, new Object[0]);
        }
        return this.scalarMultiply(1.0 / d2);
    }

    public Vector3D orthogonal() {
        double d2 = 0.6 * this.getNorm();
        if (d2 == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        if (FastMath.abs(this.x) <= d2) {
            double d3 = 1.0 / FastMath.sqrt(this.y * this.y + this.z * this.z);
            return new Vector3D(0.0, d3 * this.z, -d3 * this.y);
        }
        if (FastMath.abs(this.y) <= d2) {
            double d4 = 1.0 / FastMath.sqrt(this.x * this.x + this.z * this.z);
            return new Vector3D(-d4 * this.z, 0.0, d4 * this.x);
        }
        double d5 = 1.0 / FastMath.sqrt(this.x * this.x + this.y * this.y);
        return new Vector3D(d5 * this.y, -d5 * this.x, 0.0);
    }

    public static double angle(Vector3D vector3D, Vector3D vector3D2) {
        double d2;
        double d3 = vector3D.getNorm() * vector3D2.getNorm();
        if (d3 == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        double d4 = vector3D.dotProduct(vector3D2);
        if (d4 < -(d2 = d3 * 0.9999) || d4 > d2) {
            vector3D = Vector3D.crossProduct(vector3D, vector3D2);
            if (d4 >= 0.0) {
                return FastMath.asin(vector3D.getNorm() / d3);
            }
            return Math.PI - FastMath.asin(vector3D.getNorm() / d3);
        }
        return FastMath.acos(d4 / d3);
    }

    public Vector3D negate() {
        return new Vector3D(-this.x, -this.y, -this.z);
    }

    public Vector3D scalarMultiply(double d2) {
        return new Vector3D(d2 * this.x, d2 * this.y, d2 * this.z);
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z);
    }

    @Override
    public boolean isInfinite() {
        return !this.isNaN() && (Double.isInfinite(this.x) || Double.isInfinite(this.y) || Double.isInfinite(this.z));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Vector3D) {
            if (((Vector3D)(object = (Vector3D)object)).isNaN()) {
                return this.isNaN();
            }
            return this.x == ((Vector3D)object).x && this.y == ((Vector3D)object).y && this.z == ((Vector3D)object).z;
        }
        return false;
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 642;
        }
        return 643 * (164 * MathUtils.hash(this.x) + 3 * MathUtils.hash(this.y) + MathUtils.hash(this.z));
    }

    @Override
    public double dotProduct(Vector<Euclidean3D> vector3D) {
        vector3D = vector3D;
        return MathArrays.linearCombination(this.x, vector3D.x, this.y, vector3D.y, this.z, vector3D.z);
    }

    public Vector3D crossProduct(Vector<Euclidean3D> vector3D) {
        vector3D = vector3D;
        return new Vector3D(MathArrays.linearCombination(this.y, vector3D.z, -this.z, vector3D.y), MathArrays.linearCombination(this.z, vector3D.x, -this.x, vector3D.z), MathArrays.linearCombination(this.x, vector3D.y, -this.y, vector3D.x));
    }

    @Override
    public double distance1(Vector<Euclidean3D> vector3D) {
        vector3D = vector3D;
        double d2 = FastMath.abs(vector3D.x - this.x);
        double d3 = FastMath.abs(vector3D.y - this.y);
        double d4 = FastMath.abs(vector3D.z - this.z);
        return d2 + d3 + d4;
    }

    @Override
    public double distance(Vector<Euclidean3D> vector) {
        return this.distance((Point<Euclidean3D>)vector);
    }

    @Override
    public double distance(Point<Euclidean3D> vector3D) {
        vector3D = vector3D;
        double d2 = vector3D.x - this.x;
        double d3 = vector3D.y - this.y;
        double d4 = vector3D.z - this.z;
        double d5 = d2;
        double d6 = d3;
        double d7 = d4;
        return FastMath.sqrt(d5 * d5 + d6 * d6 + d7 * d7);
    }

    @Override
    public double distanceInf(Vector<Euclidean3D> vector3D) {
        vector3D = vector3D;
        double d2 = FastMath.abs(vector3D.x - this.x);
        double d3 = FastMath.abs(vector3D.y - this.y);
        double d4 = FastMath.abs(vector3D.z - this.z);
        return FastMath.max(FastMath.max(d2, d3), d4);
    }

    @Override
    public double distanceSq(Vector<Euclidean3D> vector3D) {
        vector3D = vector3D;
        double d2 = vector3D.x - this.x;
        double d3 = vector3D.y - this.y;
        double d4 = vector3D.z - this.z;
        double d5 = d2;
        double d6 = d3;
        double d7 = d4;
        return d5 * d5 + d6 * d6 + d7 * d7;
    }

    public static double dotProduct(Vector3D vector3D, Vector3D vector3D2) {
        return vector3D.dotProduct(vector3D2);
    }

    public static Vector3D crossProduct(Vector3D vector3D, Vector3D vector3D2) {
        return vector3D.crossProduct(vector3D2);
    }

    public static double distance1(Vector3D vector3D, Vector3D vector3D2) {
        return vector3D.distance1(vector3D2);
    }

    public static double distance(Vector3D vector3D, Vector3D vector3D2) {
        return vector3D.distance(vector3D2);
    }

    public static double distanceInf(Vector3D vector3D, Vector3D vector3D2) {
        return vector3D.distanceInf(vector3D2);
    }

    public static double distanceSq(Vector3D vector3D, Vector3D vector3D2) {
        return vector3D.distanceSq(vector3D2);
    }

    public String toString() {
        return Vector3DFormat.getInstance().format(this);
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        return new Vector3DFormat(numberFormat).format(this);
    }
}

