/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Interval;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.IntervalsSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Line;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Segment;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Region$Location;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubLine {
    private static final double DEFAULT_TOLERANCE = 1.0E-10;
    private final Line line;
    private final IntervalsSet remainingRegion;

    public SubLine(Line line, IntervalsSet intervalsSet) {
        this.line = line;
        this.remainingRegion = intervalsSet;
    }

    public SubLine(Vector3D vector3D, Vector3D vector3D2, double d2) {
        this(new Line(vector3D, vector3D2, d2), SubLine.buildIntervalSet(vector3D, vector3D2, d2));
    }

    public SubLine(Vector3D vector3D, Vector3D vector3D2) {
        this(vector3D, vector3D2, 1.0E-10);
    }

    public SubLine(Segment segment) {
        this(segment.getLine(), SubLine.buildIntervalSet(segment.getStart(), segment.getEnd(), segment.getLine().getTolerance()));
    }

    public List<Segment> getSegments() {
        Object object = this.remainingRegion.asList();
        ArrayList<Segment> arrayList = new ArrayList<Segment>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Interval)object.next();
            Point point = this.line.toSpace((Point)new Vector1D(((Interval)object2).getInf()));
            object2 = this.line.toSpace((Point)new Vector1D(((Interval)object2).getSup()));
            arrayList.add(new Segment((Vector3D)point, (Vector3D)object2, this.line));
        }
        return arrayList;
    }

    public Vector3D intersection(SubLine object, boolean bl) {
        Vector3D vector3D = this.line.intersection(object.line);
        if (vector3D == null) {
            return null;
        }
        Region$Location region$Location = this.remainingRegion.checkPoint(this.line.toSubSpace((Point)vector3D));
        object = object.remainingRegion.checkPoint(object.line.toSubSpace((Point)vector3D));
        if (bl) {
            if (region$Location != Region$Location.OUTSIDE && object != Region$Location.OUTSIDE) {
                return vector3D;
            }
            return null;
        }
        if (region$Location == Region$Location.INSIDE && object == Region$Location.INSIDE) {
            return vector3D;
        }
        return null;
    }

    private static IntervalsSet buildIntervalSet(Vector3D vector3D, Vector3D vector3D2, double d2) {
        Line line = new Line(vector3D, vector3D2, d2);
        return new IntervalsSet(((Vector1D)line.toSubSpace((Point)vector3D)).getX(), ((Vector1D)line.toSubSpace((Point)vector3D2)).getX(), d2);
    }
}

