/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.SphericalCoordinates$DataTransferObject;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.io.Serializable;

public class SphericalCoordinates
implements Serializable {
    private static final long serialVersionUID = 20130206L;
    private final Vector3D v;
    private final double r;
    private final double theta;
    private final double phi;
    private double[][] jacobian;
    private double[][] rHessian;
    private double[][] thetaHessian;
    private double[][] phiHessian;

    public SphericalCoordinates(Vector3D vector3D) {
        this.v = vector3D;
        this.r = vector3D.getNorm();
        this.theta = vector3D.getAlpha();
        this.phi = FastMath.acos(vector3D.getZ() / this.r);
    }

    public SphericalCoordinates(double d2, double d3, double d4) {
        double d5 = FastMath.cos(d3);
        double d6 = FastMath.sin(d3);
        double d7 = FastMath.cos(d4);
        double d8 = FastMath.sin(d4);
        this.r = d2;
        this.theta = d3;
        this.phi = d4;
        this.v = new Vector3D(d2 * d5 * d8, d2 * d6 * d8, d2 * d7);
    }

    public Vector3D getCartesian() {
        return this.v;
    }

    public double getR() {
        return this.r;
    }

    public double getTheta() {
        return this.theta;
    }

    public double getPhi() {
        return this.phi;
    }

    public double[] toCartesianGradient(double[] dArray) {
        this.computeJacobian();
        return new double[]{dArray[0] * this.jacobian[0][0] + dArray[1] * this.jacobian[1][0] + dArray[2] * this.jacobian[2][0], dArray[0] * this.jacobian[0][1] + dArray[1] * this.jacobian[1][1] + dArray[2] * this.jacobian[2][1], dArray[0] * this.jacobian[0][2] + dArray[2] * this.jacobian[2][2]};
    }

    public double[][] toCartesianHessian(double[][] dArray, double[] dArray2) {
        this.computeJacobian();
        this.computeHessians();
        double[][] dArray3 = new double[3][3];
        double[][] dArray4 = new double[3][3];
        dArray3[0][0] = dArray[0][0] * this.jacobian[0][0] + dArray[1][0] * this.jacobian[1][0] + dArray[2][0] * this.jacobian[2][0];
        dArray3[0][1] = dArray[0][0] * this.jacobian[0][1] + dArray[1][0] * this.jacobian[1][1] + dArray[2][0] * this.jacobian[2][1];
        dArray3[0][2] = dArray[0][0] * this.jacobian[0][2] + dArray[2][0] * this.jacobian[2][2];
        dArray3[1][0] = dArray[1][0] * this.jacobian[0][0] + dArray[1][1] * this.jacobian[1][0] + dArray[2][1] * this.jacobian[2][0];
        dArray3[1][1] = dArray[1][0] * this.jacobian[0][1] + dArray[1][1] * this.jacobian[1][1] + dArray[2][1] * this.jacobian[2][1];
        dArray3[2][0] = dArray[2][0] * this.jacobian[0][0] + dArray[2][1] * this.jacobian[1][0] + dArray[2][2] * this.jacobian[2][0];
        dArray3[2][1] = dArray[2][0] * this.jacobian[0][1] + dArray[2][1] * this.jacobian[1][1] + dArray[2][2] * this.jacobian[2][1];
        dArray3[2][2] = dArray[2][0] * this.jacobian[0][2] + dArray[2][2] * this.jacobian[2][2];
        dArray4[0][0] = this.jacobian[0][0] * dArray3[0][0] + this.jacobian[1][0] * dArray3[1][0] + this.jacobian[2][0] * dArray3[2][0];
        dArray4[1][0] = this.jacobian[0][1] * dArray3[0][0] + this.jacobian[1][1] * dArray3[1][0] + this.jacobian[2][1] * dArray3[2][0];
        dArray4[2][0] = this.jacobian[0][2] * dArray3[0][0] + this.jacobian[2][2] * dArray3[2][0];
        dArray4[1][1] = this.jacobian[0][1] * dArray3[0][1] + this.jacobian[1][1] * dArray3[1][1] + this.jacobian[2][1] * dArray3[2][1];
        dArray4[2][1] = this.jacobian[0][2] * dArray3[0][1] + this.jacobian[2][2] * dArray3[2][1];
        dArray4[2][2] = this.jacobian[0][2] * dArray3[0][2] + this.jacobian[2][2] * dArray3[2][2];
        double[] dArray5 = dArray4[0];
        dArray5[0] = dArray5[0] + (dArray2[0] * this.rHessian[0][0] + dArray2[1] * this.thetaHessian[0][0] + dArray2[2] * this.phiHessian[0][0]);
        double[] dArray6 = dArray4[1];
        dArray6[0] = dArray6[0] + (dArray2[0] * this.rHessian[1][0] + dArray2[1] * this.thetaHessian[1][0] + dArray2[2] * this.phiHessian[1][0]);
        double[] dArray7 = dArray4[2];
        dArray7[0] = dArray7[0] + (dArray2[0] * this.rHessian[2][0] + dArray2[2] * this.phiHessian[2][0]);
        double[] dArray8 = dArray4[1];
        dArray8[1] = dArray8[1] + (dArray2[0] * this.rHessian[1][1] + dArray2[1] * this.thetaHessian[1][1] + dArray2[2] * this.phiHessian[1][1]);
        double[] dArray9 = dArray4[2];
        dArray9[1] = dArray9[1] + (dArray2[0] * this.rHessian[2][1] + dArray2[2] * this.phiHessian[2][1]);
        double[] dArray10 = dArray4[2];
        dArray10[2] = dArray10[2] + (dArray2[0] * this.rHessian[2][2] + dArray2[2] * this.phiHessian[2][2]);
        dArray4[0][1] = dArray4[1][0];
        dArray4[0][2] = dArray4[2][0];
        dArray4[1][2] = dArray4[2][1];
        return dArray4;
    }

    private void computeJacobian() {
        if (this.jacobian == null) {
            double d2 = this.v.getX();
            double d3 = this.v.getY();
            double d4 = this.v.getZ();
            double d5 = d2;
            double d6 = d3;
            double d7 = d5 * d5 + d6 * d6;
            double d8 = FastMath.sqrt(d7);
            double d9 = d4;
            double d10 = d7 + d9 * d9;
            this.jacobian = new double[3][3];
            this.jacobian[0][0] = d2 / this.r;
            this.jacobian[0][1] = d3 / this.r;
            this.jacobian[0][2] = d4 / this.r;
            this.jacobian[1][0] = -d3 / d7;
            this.jacobian[1][1] = d2 / d7;
            this.jacobian[2][0] = d2 * d4 / (d8 * d10);
            this.jacobian[2][1] = d3 * d4 / (d8 * d10);
            this.jacobian[2][2] = -d8 / d10;
        }
    }

    private void computeHessians() {
        if (this.rHessian == null) {
            double d2 = this.v.getX();
            double d3 = this.v.getY();
            double d4 = this.v.getZ();
            double d5 = d2;
            double d6 = d5 * d5;
            double d7 = d3;
            double d8 = d7 * d7;
            double d9 = d4;
            double d10 = d9 * d9;
            double d11 = d6 + d8;
            double d12 = FastMath.sqrt(d11);
            double d13 = d11 + d10;
            double d14 = d2 / this.r;
            double d15 = d3 / this.r;
            double d16 = d4 / this.r;
            double d17 = d2 / d11;
            double d18 = d3 / d11;
            double d19 = d14 / d13;
            double d20 = d15 / d13;
            double d21 = d16 / d13;
            this.rHessian = new double[3][3];
            this.rHessian[0][0] = d3 * d20 + d4 * d21;
            this.rHessian[1][0] = -d2 * d20;
            this.rHessian[2][0] = -d4 * d19;
            this.rHessian[1][1] = d2 * d19 + d4 * d21;
            this.rHessian[2][1] = -d3 * d21;
            this.rHessian[2][2] = d2 * d19 + d3 * d20;
            this.rHessian[0][1] = this.rHessian[1][0];
            this.rHessian[0][2] = this.rHessian[2][0];
            this.rHessian[1][2] = this.rHessian[2][1];
            this.thetaHessian = new double[2][2];
            this.thetaHessian[0][0] = d17 * 2.0 * d18;
            double d22 = d18;
            double d23 = d17;
            this.thetaHessian[1][0] = d22 * d22 - d23 * d23;
            this.thetaHessian[1][1] = d17 * -2.0 * d18;
            this.thetaHessian[0][1] = this.thetaHessian[1][0];
            double d24 = d12 * d13;
            double d25 = d12 * d24;
            double d26 = d24 * d13;
            double d27 = d26 * d11;
            double d28 = d11 * 3.0 + d10;
            this.phiHessian = new double[3][3];
            this.phiHessian[0][0] = d4 * (d25 - d6 * d28) / d27;
            this.phiHessian[1][0] = -d2 * d3 * d4 * d28 / d27;
            this.phiHessian[2][0] = d2 * (d11 - d10) / d26;
            this.phiHessian[1][1] = d4 * (d25 - d8 * d28) / d27;
            this.phiHessian[2][1] = d3 * (d11 - d10) / d26;
            this.phiHessian[2][2] = d12 * 2.0 * d21 / this.r;
            this.phiHessian[0][1] = this.phiHessian[1][0];
            this.phiHessian[0][2] = this.phiHessian[2][0];
            this.phiHessian[1][2] = this.phiHessian[2][1];
        }
    }

    private Object writeReplace() {
        return new SphericalCoordinates$DataTransferObject(this.v.getX(), this.v.getY(), this.v.getZ());
    }
}

