/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathArithmeticException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Vector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.CardanEulerSingularityException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Euclidean3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.NotARotationMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.RotationConvention;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.RotationOrder;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import java.io.Serializable;

public class Rotation
implements Serializable {
    public static final Rotation IDENTITY = new Rotation(1.0, 0.0, 0.0, 0.0, false);
    private static final long serialVersionUID = -2153622329907944313L;
    private final double q0;
    private final double q1;
    private final double q2;
    private final double q3;

    public Rotation(double d2, double d3, double d4, double d5, boolean bl) {
        if (bl) {
            double d6 = d2;
            double d7 = d3;
            double d8 = d4;
            double d9 = d5;
            double d10 = 1.0 / FastMath.sqrt(d6 * d6 + d7 * d7 + d8 * d8 + d9 * d9);
            d2 *= d10;
            d3 *= d10;
            d4 *= d10;
            d5 *= d10;
        }
        this.q0 = d2;
        this.q1 = d3;
        this.q2 = d4;
        this.q3 = d5;
    }

    @Deprecated
    public Rotation(Vector3D vector3D, double d2) {
        this(vector3D, d2, RotationConvention.VECTOR_OPERATOR);
    }

    public Rotation(Vector3D vector3D, double d2, RotationConvention rotationConvention) {
        double d3 = vector3D.getNorm();
        if (d3 == 0.0) {
            throw new MathIllegalArgumentException(LocalizedFormats.ZERO_NORM_FOR_ROTATION_AXIS, new Object[0]);
        }
        double d4 = rotationConvention == RotationConvention.VECTOR_OPERATOR ? d2 * -0.5 : d2 * 0.5;
        double d5 = FastMath.sin(d4) / d3;
        this.q0 = FastMath.cos(d4);
        this.q1 = d5 * vector3D.getX();
        this.q2 = d5 * vector3D.getY();
        this.q3 = d5 * vector3D.getZ();
    }

    public Rotation(double[][] object, double d2) {
        double d3;
        if (((double[][])object).length != 3 || object[0].length != 3 || object[1].length != 3 || object[2].length != 3) {
            throw new NotARotationMatrixException(LocalizedFormats.ROTATION_MATRIX_DIMENSIONS, ((double[][])object).length, object[0].length);
        }
        object = this.orthogonalizeMatrix((double[][])object, d2);
        double d4 = object[0][0] * (object[1][1] * object[2][2] - object[2][1] * object[1][2]) - object[1][0] * (object[0][1] * object[2][2] - object[2][1] * object[0][2]) + object[2][0] * (object[0][1] * object[1][2] - object[1][1] * object[0][2]);
        if (d3 < 0.0) {
            throw new NotARotationMatrixException(LocalizedFormats.CLOSEST_ORTHOGONAL_MATRIX_HAS_NEGATIVE_DETERMINANT, d4);
        }
        object = Rotation.mat2quat(object);
        this.q0 = (double)object[0];
        this.q1 = (double)object[1];
        this.q2 = (double)object[2];
        this.q3 = (double)object[3];
    }

    public Rotation(Vector3D object, Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        Vector3D vector3D4 = ((Vector3D)object).crossProduct(vector3D).normalize();
        vector3D = vector3D4.crossProduct((Vector<Euclidean3D>)object).normalize();
        object = ((Vector3D)object).normalize();
        Vector3D vector3D5 = vector3D2.crossProduct(vector3D3).normalize();
        vector3D3 = vector3D5.crossProduct(vector3D2).normalize();
        vector3D2 = vector3D2.normalize();
        double[][] dArrayArray = new double[][]{{MathArrays.linearCombination(((Vector3D)object).getX(), vector3D2.getX(), vector3D.getX(), vector3D3.getX(), vector3D4.getX(), vector3D5.getX()), MathArrays.linearCombination(((Vector3D)object).getY(), vector3D2.getX(), vector3D.getY(), vector3D3.getX(), vector3D4.getY(), vector3D5.getX()), MathArrays.linearCombination(((Vector3D)object).getZ(), vector3D2.getX(), vector3D.getZ(), vector3D3.getX(), vector3D4.getZ(), vector3D5.getX())}, {MathArrays.linearCombination(((Vector3D)object).getX(), vector3D2.getY(), vector3D.getX(), vector3D3.getY(), vector3D4.getX(), vector3D5.getY()), MathArrays.linearCombination(((Vector3D)object).getY(), vector3D2.getY(), vector3D.getY(), vector3D3.getY(), vector3D4.getY(), vector3D5.getY()), MathArrays.linearCombination(((Vector3D)object).getZ(), vector3D2.getY(), vector3D.getZ(), vector3D3.getY(), vector3D4.getZ(), vector3D5.getY())}, {MathArrays.linearCombination(((Vector3D)object).getX(), vector3D2.getZ(), vector3D.getX(), vector3D3.getZ(), vector3D4.getX(), vector3D5.getZ()), MathArrays.linearCombination(((Vector3D)object).getY(), vector3D2.getZ(), vector3D.getY(), vector3D3.getZ(), vector3D4.getY(), vector3D5.getZ()), MathArrays.linearCombination(((Vector3D)object).getZ(), vector3D2.getZ(), vector3D.getZ(), vector3D3.getZ(), vector3D4.getZ(), vector3D5.getZ())}};
        object = dArrayArray;
        object = Rotation.mat2quat(dArrayArray);
        this.q0 = (double)object[0];
        this.q1 = (double)object[1];
        this.q2 = (double)object[2];
        this.q3 = (double)object[3];
    }

    public Rotation(Vector3D vector3D, Vector3D vector3D2) {
        double d2;
        double d3 = vector3D.getNorm() * vector3D2.getNorm();
        if (d3 == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM_FOR_ROTATION_DEFINING_VECTOR, new Object[0]);
        }
        double d4 = vector3D.dotProduct(vector3D2);
        if (d2 < d3 * -0.999999999999998) {
            Vector3D vector3D3 = vector3D.orthogonal();
            this.q0 = 0.0;
            this.q1 = -vector3D3.getX();
            this.q2 = -vector3D3.getY();
            this.q3 = -vector3D3.getZ();
            return;
        }
        this.q0 = FastMath.sqrt(0.5 * (1.0 + d4 / d3));
        double d5 = 1.0 / (2.0 * this.q0 * d3);
        vector3D = vector3D2.crossProduct(vector3D);
        this.q1 = d5 * vector3D.getX();
        this.q2 = d5 * vector3D.getY();
        this.q3 = d5 * vector3D.getZ();
    }

    @Deprecated
    public Rotation(RotationOrder rotationOrder, double d2, double d3, double d4) {
        this(rotationOrder, RotationConvention.VECTOR_OPERATOR, d2, d3, d4);
    }

    public Rotation(RotationOrder object, RotationConvention rotationConvention, double d2, double d3, double d4) {
        Rotation rotation = new Rotation(((RotationOrder)object).getA1(), d2, rotationConvention);
        Rotation rotation2 = new Rotation(((RotationOrder)object).getA2(), d3, rotationConvention);
        object = new Rotation(((RotationOrder)object).getA3(), d4, rotationConvention);
        object = rotation.compose(rotation2.compose((Rotation)object, rotationConvention), rotationConvention);
        this.q0 = ((Rotation)object).q0;
        this.q1 = ((Rotation)object).q1;
        this.q2 = ((Rotation)object).q2;
        this.q3 = ((Rotation)object).q3;
    }

    private static double[] mat2quat(double[][] dArray) {
        double d2;
        double[] dArray2 = new double[4];
        double d3 = dArray[0][0] + dArray[1][1] + dArray[2][2];
        if (d2 > -0.19) {
            dArray2[0] = 0.5 * FastMath.sqrt(d3 + 1.0);
            double d4 = 0.25 / dArray2[0];
            dArray2[1] = d4 * (dArray[1][2] - dArray[2][1]);
            dArray2[2] = d4 * (dArray[2][0] - dArray[0][2]);
            dArray2[3] = d4 * (dArray[0][1] - dArray[1][0]);
        } else {
            double d5;
            d3 = dArray[0][0] - dArray[1][1] - dArray[2][2];
            if (d5 > -0.19) {
                dArray2[1] = 0.5 * FastMath.sqrt(d3 + 1.0);
                double d6 = 0.25 / dArray2[1];
                dArray2[0] = d6 * (dArray[1][2] - dArray[2][1]);
                dArray2[2] = d6 * (dArray[0][1] + dArray[1][0]);
                dArray2[3] = d6 * (dArray[0][2] + dArray[2][0]);
            } else {
                double d7;
                d3 = dArray[1][1] - dArray[0][0] - dArray[2][2];
                if (d7 > -0.19) {
                    dArray2[2] = 0.5 * FastMath.sqrt(d3 + 1.0);
                    double d8 = 0.25 / dArray2[2];
                    dArray2[0] = d8 * (dArray[2][0] - dArray[0][2]);
                    dArray2[1] = d8 * (dArray[0][1] + dArray[1][0]);
                    dArray2[3] = d8 * (dArray[2][1] + dArray[1][2]);
                } else {
                    d3 = dArray[2][2] - dArray[0][0] - dArray[1][1];
                    dArray2[3] = 0.5 * FastMath.sqrt(d3 + 1.0);
                    double d9 = 0.25 / dArray2[3];
                    dArray2[0] = d9 * (dArray[0][1] - dArray[1][0]);
                    dArray2[1] = d9 * (dArray[0][2] + dArray[2][0]);
                    dArray2[2] = d9 * (dArray[2][1] + dArray[1][2]);
                }
            }
        }
        return dArray2;
    }

    public Rotation revert() {
        return new Rotation(-this.q0, this.q1, this.q2, this.q3, false);
    }

    public double getQ0() {
        return this.q0;
    }

    public double getQ1() {
        return this.q1;
    }

    public double getQ2() {
        return this.q2;
    }

    public double getQ3() {
        return this.q3;
    }

    @Deprecated
    public Vector3D getAxis() {
        return this.getAxis(RotationConvention.VECTOR_OPERATOR);
    }

    public Vector3D getAxis(RotationConvention rotationConvention) {
        double d2;
        double d3 = this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3;
        if (d3 == 0.0) {
            if (rotationConvention == RotationConvention.VECTOR_OPERATOR) {
                return Vector3D.PLUS_I;
            }
            return Vector3D.MINUS_I;
        }
        double d4 = d2 = rotationConvention == RotationConvention.VECTOR_OPERATOR ? 1.0 : -1.0;
        if (this.q0 < 0.0) {
            double d5 = d2 / FastMath.sqrt(d3);
            return new Vector3D(this.q1 * d5, this.q2 * d5, this.q3 * d5);
        }
        double d6 = -d2 / FastMath.sqrt(d3);
        return new Vector3D(this.q1 * d6, this.q2 * d6, this.q3 * d6);
    }

    public double getAngle() {
        if (this.q0 < -0.1 || this.q0 > 0.1) {
            return 2.0 * FastMath.asin(FastMath.sqrt(this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3));
        }
        if (this.q0 < 0.0) {
            return 2.0 * FastMath.acos(-this.q0);
        }
        return 2.0 * FastMath.acos(this.q0);
    }

    @Deprecated
    public double[] getAngles(RotationOrder rotationOrder) {
        return this.getAngles(rotationOrder, RotationConvention.VECTOR_OPERATOR);
    }

    public double[] getAngles(RotationOrder object, RotationConvention object2) {
        if (object2 == RotationConvention.VECTOR_OPERATOR) {
            if (object == RotationOrder.XYZ) {
                object = this.applyTo(Vector3D.PLUS_K);
                object2 = this.applyInverseTo(Vector3D.PLUS_I);
                if (((Vector3D)object2).getZ() < -0.9999999999 || ((Vector3D)object2).getZ() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return new double[]{FastMath.atan2(-((Vector3D)object).getY(), ((Vector3D)object).getZ()), FastMath.asin(((Vector3D)object2).getZ()), FastMath.atan2(-((Vector3D)object2).getY(), ((Vector3D)object2).getX())};
            }
            if (object == RotationOrder.XZY) {
                object = this.applyTo(Vector3D.PLUS_J);
                object2 = this.applyInverseTo(Vector3D.PLUS_I);
                if (((Vector3D)object2).getY() < -0.9999999999 || ((Vector3D)object2).getY() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return new double[]{FastMath.atan2(((Vector3D)object).getZ(), ((Vector3D)object).getY()), -FastMath.asin(((Vector3D)object2).getY()), FastMath.atan2(((Vector3D)object2).getZ(), ((Vector3D)object2).getX())};
            }
            if (object == RotationOrder.YXZ) {
                object = this.applyTo(Vector3D.PLUS_K);
                object2 = this.applyInverseTo(Vector3D.PLUS_J);
                if (((Vector3D)object2).getZ() < -0.9999999999 || ((Vector3D)object2).getZ() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return new double[]{FastMath.atan2(((Vector3D)object).getX(), ((Vector3D)object).getZ()), -FastMath.asin(((Vector3D)object2).getZ()), FastMath.atan2(((Vector3D)object2).getX(), ((Vector3D)object2).getY())};
            }
            if (object == RotationOrder.YZX) {
                object = this.applyTo(Vector3D.PLUS_I);
                object2 = this.applyInverseTo(Vector3D.PLUS_J);
                if (((Vector3D)object2).getX() < -0.9999999999 || ((Vector3D)object2).getX() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return new double[]{FastMath.atan2(-((Vector3D)object).getZ(), ((Vector3D)object).getX()), FastMath.asin(((Vector3D)object2).getX()), FastMath.atan2(-((Vector3D)object2).getZ(), ((Vector3D)object2).getY())};
            }
            if (object == RotationOrder.ZXY) {
                object = this.applyTo(Vector3D.PLUS_J);
                object2 = this.applyInverseTo(Vector3D.PLUS_K);
                if (((Vector3D)object2).getY() < -0.9999999999 || ((Vector3D)object2).getY() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return new double[]{FastMath.atan2(-((Vector3D)object).getX(), ((Vector3D)object).getY()), FastMath.asin(((Vector3D)object2).getY()), FastMath.atan2(-((Vector3D)object2).getX(), ((Vector3D)object2).getZ())};
            }
            if (object == RotationOrder.ZYX) {
                object = this.applyTo(Vector3D.PLUS_I);
                object2 = this.applyInverseTo(Vector3D.PLUS_K);
                if (((Vector3D)object2).getX() < -0.9999999999 || ((Vector3D)object2).getX() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return new double[]{FastMath.atan2(((Vector3D)object).getY(), ((Vector3D)object).getX()), -FastMath.asin(((Vector3D)object2).getX()), FastMath.atan2(((Vector3D)object2).getY(), ((Vector3D)object2).getZ())};
            }
            if (object == RotationOrder.XYX) {
                object = this.applyTo(Vector3D.PLUS_I);
                object2 = this.applyInverseTo(Vector3D.PLUS_I);
                if (((Vector3D)object2).getX() < -0.9999999999 || ((Vector3D)object2).getX() > 0.9999999999) {
                    throw new CardanEulerSingularityException(false);
                }
                return new double[]{FastMath.atan2(((Vector3D)object).getY(), -((Vector3D)object).getZ()), FastMath.acos(((Vector3D)object2).getX()), FastMath.atan2(((Vector3D)object2).getY(), ((Vector3D)object2).getZ())};
            }
            if (object == RotationOrder.XZX) {
                object = this.applyTo(Vector3D.PLUS_I);
                object2 = this.applyInverseTo(Vector3D.PLUS_I);
                if (((Vector3D)object2).getX() < -0.9999999999 || ((Vector3D)object2).getX() > 0.9999999999) {
                    throw new CardanEulerSingularityException(false);
                }
                return new double[]{FastMath.atan2(((Vector3D)object).getZ(), ((Vector3D)object).getY()), FastMath.acos(((Vector3D)object2).getX()), FastMath.atan2(((Vector3D)object2).getZ(), -((Vector3D)object2).getY())};
            }
            if (object == RotationOrder.YXY) {
                object = this.applyTo(Vector3D.PLUS_J);
                object2 = this.applyInverseTo(Vector3D.PLUS_J);
                if (((Vector3D)object2).getY() < -0.9999999999 || ((Vector3D)object2).getY() > 0.9999999999) {
                    throw new CardanEulerSingularityException(false);
                }
                return new double[]{FastMath.atan2(((Vector3D)object).getX(), ((Vector3D)object).getZ()), FastMath.acos(((Vector3D)object2).getY()), FastMath.atan2(((Vector3D)object2).getX(), -((Vector3D)object2).getZ())};
            }
            if (object == RotationOrder.YZY) {
                object = this.applyTo(Vector3D.PLUS_J);
                object2 = this.applyInverseTo(Vector3D.PLUS_J);
                if (((Vector3D)object2).getY() < -0.9999999999 || ((Vector3D)object2).getY() > 0.9999999999) {
                    throw new CardanEulerSingularityException(false);
                }
                return new double[]{FastMath.atan2(((Vector3D)object).getZ(), -((Vector3D)object).getX()), FastMath.acos(((Vector3D)object2).getY()), FastMath.atan2(((Vector3D)object2).getZ(), ((Vector3D)object2).getX())};
            }
            if (object == RotationOrder.ZXZ) {
                object = this.applyTo(Vector3D.PLUS_K);
                object2 = this.applyInverseTo(Vector3D.PLUS_K);
                if (((Vector3D)object2).getZ() < -0.9999999999 || ((Vector3D)object2).getZ() > 0.9999999999) {
                    throw new CardanEulerSingularityException(false);
                }
                return new double[]{FastMath.atan2(((Vector3D)object).getX(), -((Vector3D)object).getY()), FastMath.acos(((Vector3D)object2).getZ()), FastMath.atan2(((Vector3D)object2).getX(), ((Vector3D)object2).getY())};
            }
            object = this.applyTo(Vector3D.PLUS_K);
            object2 = this.applyInverseTo(Vector3D.PLUS_K);
            if (((Vector3D)object2).getZ() < -0.9999999999 || ((Vector3D)object2).getZ() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return new double[]{FastMath.atan2(((Vector3D)object).getY(), ((Vector3D)object).getX()), FastMath.acos(((Vector3D)object2).getZ()), FastMath.atan2(((Vector3D)object2).getY(), -((Vector3D)object2).getX())};
        }
        if (object == RotationOrder.XYZ) {
            object = this.applyTo(Vector3D.PLUS_I);
            object2 = this.applyInverseTo(Vector3D.PLUS_K);
            if (((Vector3D)object2).getX() < -0.9999999999 || ((Vector3D)object2).getX() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return new double[]{FastMath.atan2(-((Vector3D)object2).getY(), ((Vector3D)object2).getZ()), FastMath.asin(((Vector3D)object2).getX()), FastMath.atan2(-((Vector3D)object).getY(), ((Vector3D)object).getX())};
        }
        if (object == RotationOrder.XZY) {
            object = this.applyTo(Vector3D.PLUS_I);
            object2 = this.applyInverseTo(Vector3D.PLUS_J);
            if (((Vector3D)object2).getX() < -0.9999999999 || ((Vector3D)object2).getX() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return new double[]{FastMath.atan2(((Vector3D)object2).getZ(), ((Vector3D)object2).getY()), -FastMath.asin(((Vector3D)object2).getX()), FastMath.atan2(((Vector3D)object).getZ(), ((Vector3D)object).getX())};
        }
        if (object == RotationOrder.YXZ) {
            object = this.applyTo(Vector3D.PLUS_J);
            object2 = this.applyInverseTo(Vector3D.PLUS_K);
            if (((Vector3D)object2).getY() < -0.9999999999 || ((Vector3D)object2).getY() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return new double[]{FastMath.atan2(((Vector3D)object2).getX(), ((Vector3D)object2).getZ()), -FastMath.asin(((Vector3D)object2).getY()), FastMath.atan2(((Vector3D)object).getX(), ((Vector3D)object).getY())};
        }
        if (object == RotationOrder.YZX) {
            object = this.applyTo(Vector3D.PLUS_J);
            object2 = this.applyInverseTo(Vector3D.PLUS_I);
            if (((Vector3D)object2).getY() < -0.9999999999 || ((Vector3D)object2).getY() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return new double[]{FastMath.atan2(-((Vector3D)object2).getZ(), ((Vector3D)object2).getX()), FastMath.asin(((Vector3D)object2).getY()), FastMath.atan2(-((Vector3D)object).getZ(), ((Vector3D)object).getY())};
        }
        if (object == RotationOrder.ZXY) {
            object = this.applyTo(Vector3D.PLUS_K);
            object2 = this.applyInverseTo(Vector3D.PLUS_J);
            if (((Vector3D)object2).getZ() < -0.9999999999 || ((Vector3D)object2).getZ() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return new double[]{FastMath.atan2(-((Vector3D)object2).getX(), ((Vector3D)object2).getY()), FastMath.asin(((Vector3D)object2).getZ()), FastMath.atan2(-((Vector3D)object).getX(), ((Vector3D)object).getZ())};
        }
        if (object == RotationOrder.ZYX) {
            object = this.applyTo(Vector3D.PLUS_K);
            object2 = this.applyInverseTo(Vector3D.PLUS_I);
            if (((Vector3D)object2).getZ() < -0.9999999999 || ((Vector3D)object2).getZ() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return new double[]{FastMath.atan2(((Vector3D)object2).getY(), ((Vector3D)object2).getX()), -FastMath.asin(((Vector3D)object2).getZ()), FastMath.atan2(((Vector3D)object).getY(), ((Vector3D)object).getZ())};
        }
        if (object == RotationOrder.XYX) {
            object = this.applyTo(Vector3D.PLUS_I);
            object2 = this.applyInverseTo(Vector3D.PLUS_I);
            if (((Vector3D)object2).getX() < -0.9999999999 || ((Vector3D)object2).getX() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return new double[]{FastMath.atan2(((Vector3D)object2).getY(), -((Vector3D)object2).getZ()), FastMath.acos(((Vector3D)object2).getX()), FastMath.atan2(((Vector3D)object).getY(), ((Vector3D)object).getZ())};
        }
        if (object == RotationOrder.XZX) {
            object = this.applyTo(Vector3D.PLUS_I);
            object2 = this.applyInverseTo(Vector3D.PLUS_I);
            if (((Vector3D)object2).getX() < -0.9999999999 || ((Vector3D)object2).getX() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return new double[]{FastMath.atan2(((Vector3D)object2).getZ(), ((Vector3D)object2).getY()), FastMath.acos(((Vector3D)object2).getX()), FastMath.atan2(((Vector3D)object).getZ(), -((Vector3D)object).getY())};
        }
        if (object == RotationOrder.YXY) {
            object = this.applyTo(Vector3D.PLUS_J);
            object2 = this.applyInverseTo(Vector3D.PLUS_J);
            if (((Vector3D)object2).getY() < -0.9999999999 || ((Vector3D)object2).getY() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return new double[]{FastMath.atan2(((Vector3D)object2).getX(), ((Vector3D)object2).getZ()), FastMath.acos(((Vector3D)object2).getY()), FastMath.atan2(((Vector3D)object).getX(), -((Vector3D)object).getZ())};
        }
        if (object == RotationOrder.YZY) {
            object = this.applyTo(Vector3D.PLUS_J);
            object2 = this.applyInverseTo(Vector3D.PLUS_J);
            if (((Vector3D)object2).getY() < -0.9999999999 || ((Vector3D)object2).getY() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return new double[]{FastMath.atan2(((Vector3D)object2).getZ(), -((Vector3D)object2).getX()), FastMath.acos(((Vector3D)object2).getY()), FastMath.atan2(((Vector3D)object).getZ(), ((Vector3D)object).getX())};
        }
        if (object == RotationOrder.ZXZ) {
            object = this.applyTo(Vector3D.PLUS_K);
            object2 = this.applyInverseTo(Vector3D.PLUS_K);
            if (((Vector3D)object2).getZ() < -0.9999999999 || ((Vector3D)object2).getZ() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return new double[]{FastMath.atan2(((Vector3D)object2).getX(), -((Vector3D)object2).getY()), FastMath.acos(((Vector3D)object2).getZ()), FastMath.atan2(((Vector3D)object).getX(), ((Vector3D)object).getY())};
        }
        object = this.applyTo(Vector3D.PLUS_K);
        object2 = this.applyInverseTo(Vector3D.PLUS_K);
        if (((Vector3D)object2).getZ() < -0.9999999999 || ((Vector3D)object2).getZ() > 0.9999999999) {
            throw new CardanEulerSingularityException(false);
        }
        return new double[]{FastMath.atan2(((Vector3D)object2).getY(), ((Vector3D)object2).getX()), FastMath.acos(((Vector3D)object2).getZ()), FastMath.atan2(((Vector3D)object).getY(), -((Vector3D)object).getX())};
    }

    public double[][] getMatrix() {
        double d2 = this.q0 * this.q0;
        double d3 = this.q0 * this.q1;
        double d4 = this.q0 * this.q2;
        double d5 = this.q0 * this.q3;
        double d6 = this.q1 * this.q1;
        double d7 = this.q1 * this.q2;
        double d8 = this.q1 * this.q3;
        double d9 = this.q2 * this.q2;
        double d10 = this.q2 * this.q3;
        double d11 = this.q3 * this.q3;
        double[][] dArrayArray = new double[3][];
        double[][] dArrayArray2 = dArrayArray;
        dArrayArray[0] = new double[3];
        dArrayArray2[1] = new double[3];
        dArrayArray2[2] = new double[3];
        dArrayArray2[0][0] = 2.0 * (d2 + d6) - 1.0;
        dArrayArray2[1][0] = 2.0 * (d7 - d5);
        dArrayArray2[2][0] = 2.0 * (d8 + d4);
        dArrayArray2[0][1] = 2.0 * (d7 + d5);
        dArrayArray2[1][1] = 2.0 * (d2 + d9) - 1.0;
        dArrayArray2[2][1] = 2.0 * (d10 - d3);
        dArrayArray2[0][2] = 2.0 * (d8 - d4);
        dArrayArray2[1][2] = 2.0 * (d10 + d3);
        dArrayArray2[2][2] = 2.0 * (d2 + d11) - 1.0;
        return dArrayArray2;
    }

    public Vector3D applyTo(Vector3D vector3D) {
        double d2 = vector3D.getX();
        double d3 = vector3D.getY();
        double d4 = vector3D.getZ();
        double d5 = this.q1 * d2 + this.q2 * d3 + this.q3 * d4;
        return new Vector3D(2.0 * (this.q0 * (d2 * this.q0 - (this.q2 * d4 - this.q3 * d3)) + d5 * this.q1) - d2, 2.0 * (this.q0 * (d3 * this.q0 - (this.q3 * d2 - this.q1 * d4)) + d5 * this.q2) - d3, 2.0 * (this.q0 * (d4 * this.q0 - (this.q1 * d3 - this.q2 * d2)) + d5 * this.q3) - d4);
    }

    public void applyTo(double[] dArray, double[] dArray2) {
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = this.q1 * d2 + this.q2 * d3 + this.q3 * d4;
        dArray2[0] = 2.0 * (this.q0 * (d2 * this.q0 - (this.q2 * d4 - this.q3 * d3)) + d5 * this.q1) - d2;
        dArray2[1] = 2.0 * (this.q0 * (d3 * this.q0 - (this.q3 * d2 - this.q1 * d4)) + d5 * this.q2) - d3;
        dArray2[2] = 2.0 * (this.q0 * (d4 * this.q0 - (this.q1 * d3 - this.q2 * d2)) + d5 * this.q3) - d4;
    }

    public Vector3D applyInverseTo(Vector3D vector3D) {
        double d2 = vector3D.getX();
        double d3 = vector3D.getY();
        double d4 = vector3D.getZ();
        double d5 = this.q1 * d2 + this.q2 * d3 + this.q3 * d4;
        double d6 = -this.q0;
        return new Vector3D(2.0 * (d6 * (d2 * d6 - (this.q2 * d4 - this.q3 * d3)) + d5 * this.q1) - d2, 2.0 * (d6 * (d3 * d6 - (this.q3 * d2 - this.q1 * d4)) + d5 * this.q2) - d3, 2.0 * (d6 * (d4 * d6 - (this.q1 * d3 - this.q2 * d2)) + d5 * this.q3) - d4);
    }

    public void applyInverseTo(double[] dArray, double[] dArray2) {
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = this.q1 * d2 + this.q2 * d3 + this.q3 * d4;
        double d6 = -this.q0;
        dArray2[0] = 2.0 * (d6 * (d2 * d6 - (this.q2 * d4 - this.q3 * d3)) + d5 * this.q1) - d2;
        dArray2[1] = 2.0 * (d6 * (d3 * d6 - (this.q3 * d2 - this.q1 * d4)) + d5 * this.q2) - d3;
        dArray2[2] = 2.0 * (d6 * (d4 * d6 - (this.q1 * d3 - this.q2 * d2)) + d5 * this.q3) - d4;
    }

    public Rotation applyTo(Rotation rotation) {
        return this.compose(rotation, RotationConvention.VECTOR_OPERATOR);
    }

    public Rotation compose(Rotation rotation, RotationConvention rotationConvention) {
        if (rotationConvention == RotationConvention.VECTOR_OPERATOR) {
            return this.composeInternal(rotation);
        }
        return rotation.composeInternal(this);
    }

    private Rotation composeInternal(Rotation rotation) {
        return new Rotation(rotation.q0 * this.q0 - (rotation.q1 * this.q1 + rotation.q2 * this.q2 + rotation.q3 * this.q3), rotation.q1 * this.q0 + rotation.q0 * this.q1 + (rotation.q2 * this.q3 - rotation.q3 * this.q2), rotation.q2 * this.q0 + rotation.q0 * this.q2 + (rotation.q3 * this.q1 - rotation.q1 * this.q3), rotation.q3 * this.q0 + rotation.q0 * this.q3 + (rotation.q1 * this.q2 - rotation.q2 * this.q1), false);
    }

    public Rotation applyInverseTo(Rotation rotation) {
        return this.composeInverse(rotation, RotationConvention.VECTOR_OPERATOR);
    }

    public Rotation composeInverse(Rotation rotation, RotationConvention rotationConvention) {
        if (rotationConvention == RotationConvention.VECTOR_OPERATOR) {
            return this.composeInverseInternal(rotation);
        }
        return rotation.composeInternal(this.revert());
    }

    private Rotation composeInverseInternal(Rotation rotation) {
        return new Rotation(-rotation.q0 * this.q0 - (rotation.q1 * this.q1 + rotation.q2 * this.q2 + rotation.q3 * this.q3), -rotation.q1 * this.q0 + rotation.q0 * this.q1 + (rotation.q2 * this.q3 - rotation.q3 * this.q2), -rotation.q2 * this.q0 + rotation.q0 * this.q2 + (rotation.q3 * this.q1 - rotation.q1 * this.q3), -rotation.q3 * this.q0 + rotation.q0 * this.q3 + (rotation.q1 * this.q2 - rotation.q2 * this.q1), false);
    }

    private double[][] orthogonalizeMatrix(double[][] object, double d2) {
        double[] dArray = object[0];
        double[] dArray2 = object[1];
        object = object[2];
        double d3 = dArray[0];
        double d4 = dArray[1];
        double d5 = dArray[2];
        double d6 = dArray2[0];
        double d7 = dArray2[1];
        double d8 = dArray2[2];
        Object object2 = object[0];
        Object object3 = object[1];
        Object object4 = object[2];
        double d9 = 0.0;
        double[][] dArray3 = new double[3][3];
        double[] dArray4 = dArray3[0];
        double[] dArray5 = dArray3[1];
        double[] dArray6 = dArray3[2];
        int n = 0;
        while (++n < 11) {
            double d10;
            double d11 = dArray[0] * d3 + dArray2[0] * d6 + object[0] * object2;
            double d12 = dArray[1] * d3 + dArray2[1] * d6 + object[1] * object2;
            double d13 = dArray[2] * d3 + dArray2[2] * d6 + object[2] * object2;
            double d14 = dArray[0] * d4 + dArray2[0] * d7 + object[0] * object3;
            double d15 = dArray[1] * d4 + dArray2[1] * d7 + object[1] * object3;
            double d16 = dArray[2] * d4 + dArray2[2] * d7 + object[2] * object3;
            double d17 = dArray[0] * d5 + dArray2[0] * d8 + object[0] * object4;
            double d18 = dArray[1] * d5 + dArray2[1] * d8 + object[1] * object4;
            double d19 = dArray[2] * d5 + dArray2[2] * d8 + object[2] * object4;
            dArray4[0] = d3 - 0.5 * (d3 * d11 + d4 * d12 + d5 * d13 - dArray[0]);
            dArray4[1] = d4 - 0.5 * (d3 * d14 + d4 * d15 + d5 * d16 - dArray[1]);
            dArray4[2] = d5 - 0.5 * (d3 * d17 + d4 * d18 + d5 * d19 - dArray[2]);
            dArray5[0] = d6 - 0.5 * (d6 * d11 + d7 * d12 + d8 * d13 - dArray2[0]);
            dArray5[1] = d7 - 0.5 * (d6 * d14 + d7 * d15 + d8 * d16 - dArray2[1]);
            dArray5[2] = d8 - 0.5 * (d6 * d17 + d7 * d18 + d8 * d19 - dArray2[2]);
            dArray6[0] = (double)(object2 - 0.5 * (object2 * d11 + object3 * d12 + object4 * d13 - object[0]));
            dArray6[1] = (double)(object3 - 0.5 * (object2 * d14 + object3 * d15 + object4 * d16 - object[1]));
            dArray6[2] = (double)(object4 - 0.5 * (object2 * d17 + object3 * d18 + object4 * d19 - object[2]));
            double d20 = dArray4[0] - dArray[0];
            double d21 = dArray4[1] - dArray[1];
            double d22 = dArray4[2] - dArray[2];
            double d23 = dArray5[0] - dArray2[0];
            double d24 = dArray5[1] - dArray2[1];
            double d25 = dArray5[2] - dArray2[2];
            double d26 = dArray6[0] - object[0];
            double d27 = dArray6[1] - object[1];
            double d28 = dArray6[2] - object[2];
            double d29 = d20;
            double d30 = d21;
            double d31 = d22;
            double d32 = d23;
            double d33 = d24;
            double d34 = d25;
            double d35 = d26;
            double d36 = d27;
            double d37 = d28;
            double d38 = d29 * d29 + d30 * d30 + d31 * d31 + d32 * d32 + d33 * d33 + d34 * d34 + d35 * d35 + d36 * d36 + d37 * d37;
            if (FastMath.abs(d10 - d9) <= d2) {
                return dArray3;
            }
            d3 = dArray4[0];
            d4 = dArray4[1];
            d5 = dArray4[2];
            d6 = dArray5[0];
            d7 = dArray5[1];
            d8 = dArray5[2];
            object2 = dArray6[0];
            object3 = dArray6[1];
            object4 = dArray6[2];
            d9 = d38;
        }
        throw new NotARotationMatrixException(LocalizedFormats.UNABLE_TO_ORTHOGONOLIZE_MATRIX, n - 1);
    }

    public static double distance(Rotation rotation, Rotation rotation2) {
        return rotation.composeInverseInternal(rotation2).getAngle();
    }
}

