/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Vector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Euclidean3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Line;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Plane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.PolyhedronsSet$FacetsContributionVisitor;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.PolyhedronsSet$RotationTransform;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.PolyhedronsSet$TranslationTransform;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Rotation;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.SubPlane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.PolygonsSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.AbstractRegion;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTree;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BoundaryAttribute;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Hyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Region$Location;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.RegionFactory;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolyhedronsSet
extends AbstractRegion<Euclidean3D, Euclidean2D> {
    private static final double DEFAULT_TOLERANCE = 1.0E-10;

    public PolyhedronsSet(double d2) {
        super(d2);
    }

    public PolyhedronsSet(BSPTree<Euclidean3D> bSPTree, double d2) {
        super(bSPTree, d2);
    }

    public PolyhedronsSet(Collection<SubHyperplane<Euclidean3D>> collection, double d2) {
        super(collection, d2);
    }

    public PolyhedronsSet(List<Vector3D> list, List<int[]> list2, double d2) {
        super(PolyhedronsSet.buildBoundary(list, list2, d2), d2);
    }

    public PolyhedronsSet(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        super(PolyhedronsSet.buildBoundary(d2, d3, d4, d5, d6, d7, d8), d8);
    }

    @Deprecated
    public PolyhedronsSet() {
        this(1.0E-10);
    }

    @Deprecated
    public PolyhedronsSet(BSPTree<Euclidean3D> bSPTree) {
        this(bSPTree, 1.0E-10);
    }

    @Deprecated
    public PolyhedronsSet(Collection<SubHyperplane<Euclidean3D>> collection) {
        this(collection, 1.0E-10);
    }

    @Deprecated
    public PolyhedronsSet(double d2, double d3, double d4, double d5, double d6, double d7) {
        this(d2, d3, d4, d5, d6, d7, 1.0E-10);
    }

    private static BSPTree<Euclidean3D> buildBoundary(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        if (d2 >= d3 - d8 || d4 >= d5 - d8 || d6 >= d7 - d8) {
            return new BSPTree<Euclidean3D>(Boolean.FALSE);
        }
        Object object = new Plane(new Vector3D(d2, 0.0, 0.0), Vector3D.MINUS_I, d8);
        Plane plane = new Plane(new Vector3D(d3, 0.0, 0.0), Vector3D.PLUS_I, d8);
        Plane plane2 = new Plane(new Vector3D(0.0, d4, 0.0), Vector3D.MINUS_J, d8);
        Plane plane3 = new Plane(new Vector3D(0.0, d5, 0.0), Vector3D.PLUS_J, d8);
        Plane plane4 = new Plane(new Vector3D(0.0, 0.0, d6), Vector3D.MINUS_K, d8);
        Plane plane5 = new Plane(new Vector3D(0.0, 0.0, d7), Vector3D.PLUS_K, d8);
        object = new RegionFactory().buildConvex(new Hyperplane[]{object, plane, plane2, plane3, plane4, plane5});
        return object.getTree(false);
    }

    private static List<SubHyperplane<Euclidean3D>> buildBoundary(List<Vector3D> list, List<int[]> list2, double d2) {
        Object object;
        int n;
        int n2;
        Object object2;
        for (int i2 = 0; i2 < list.size() - 1; ++i2) {
            object2 = list.get(i2);
            for (n2 = i2 + 1; n2 < list.size(); ++n2) {
                if (!(Vector3D.distance((Vector3D)object2, list.get(n2)) <= d2)) continue;
                throw new MathIllegalArgumentException(LocalizedFormats.CLOSE_VERTICES, ((Vector3D)object2).getX(), ((Vector3D)object2).getY(), ((Vector3D)object2).getZ());
            }
        }
        Object object3 = PolyhedronsSet.findReferences(list, list2);
        object2 = PolyhedronsSet.successors(list, list2, (int[][])object3);
        for (n2 = 0; n2 < list.size(); ++n2) {
            Object object4 = object2[n2];
            object3 = object4;
            int n3 = ((Object)object4).length;
            for (int i3 = 0; i3 < n3; ++i3) {
                Object object5 = object3[i3];
                if (object5 < 0) continue;
                n = 0;
                for (Object object6 : object2[object5]) {
                    n = n != 0 || object6 == n2 ? 1 : 0;
                }
                if (n != 0) continue;
                object = list.get(n2);
                Vector3D vector3D = list.get((int)object5);
                throw new MathIllegalArgumentException(LocalizedFormats.EDGE_CONNECTED_TO_ONE_FACET, ((Vector3D)object).getX(), ((Vector3D)object).getY(), ((Vector3D)object).getZ(), vector3D.getX(), vector3D.getY(), vector3D.getZ());
            }
        }
        ArrayList<SubHyperplane<Euclidean3D>> arrayList = new ArrayList<SubHyperplane<Euclidean3D>>();
        object3 = list2.iterator();
        while (object3.hasNext()) {
            int[] nArray = (int[])object3.next();
            Plane plane = new Plane(list.get(nArray[0]), list.get(nArray[1]), list.get(nArray[2]), d2);
            Vector2D[] vector2DArray = new Vector2D[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                object = list.get(nArray[n]);
                if (!plane.contains((Vector3D)object)) {
                    throw new MathIllegalArgumentException(LocalizedFormats.OUT_OF_PLANE, ((Vector3D)object).getX(), ((Vector3D)object).getY(), ((Vector3D)object).getZ());
                }
                vector2DArray[n] = plane.toSubSpace((Vector<Euclidean3D>)object);
            }
            arrayList.add(new SubPlane(plane, new PolygonsSet(d2, vector2DArray)));
        }
        return arrayList;
    }

    private static int[][] findReferences(List<Vector3D> list, List<int[]> list2) {
        int n;
        Object object2;
        int[] nArray = new int[list.size()];
        int n2 = 0;
        for (Object object2 : list2) {
            if (((int[])object2).length < 3) {
                throw new NumberIsTooSmallException((Localizable)LocalizedFormats.WRONG_NUMBER_OF_POINTS, (Number)3, ((int[])object2).length, true);
            }
            Object object3 = object2;
            n = ((int[])object2).length;
            for (int i2 = 0; i2 < n; ++i2) {
                int n3;
                int n4 = n3 = object3[i2];
                int n5 = nArray[n4] + 1;
                nArray[n4] = n5;
                n2 = FastMath.max(n2, n5);
            }
        }
        int[][] nArray2 = new int[list.size()][n2];
        Object object4 = nArray2;
        object2 = nArray2;
        int n6 = nArray2.length;
        for (n = 0; n < n6; ++n) {
            int n7 = object2[n];
            Arrays.fill((int[])n7, -1);
        }
        for (int i3 = 0; i3 < list2.size(); ++i3) {
            for (int n3 : list2.get(i3)) {
                for (int i4 = 0; i4 < n2 && object4[n3][i4] >= 0; ++i4) {
                }
                object4[n3][i4] = i3;
            }
        }
        return object4;
    }

    private static int[][] successors(List<Vector3D> object, List<int[]> object2, int[][] nArray) {
        int n;
        int[][] nArray2;
        int[][] nArray3 = nArray2 = new int[object.size()][nArray[0].length];
        int n2 = nArray2.length;
        for (n = 0; n < n2; ++n) {
            int[] nArray4 = nArray3[n];
            Arrays.fill(nArray4, -1);
        }
        for (int i2 = 0; i2 < object.size(); ++i2) {
            for (n2 = 0; n2 < nArray2[i2].length && nArray[i2][n2] >= 0; ++n2) {
                int n3;
                int[] nArray5 = object2.get(nArray[i2][n2]);
                for (n3 = 0; n3 < nArray5.length && nArray5[n3] != i2; ++n3) {
                }
                nArray2[i2][n2] = nArray5[(n3 + 1) % nArray5.length];
                for (n = 0; n < n2; ++n) {
                    if (nArray2[i2][n] != nArray2[i2][n2]) continue;
                    object2 = object.get(i2);
                    object = object.get(nArray2[i2][n2]);
                    throw new MathIllegalArgumentException(LocalizedFormats.FACET_ORIENTATION_MISMATCH, ((Vector3D)object2).getX(), ((Vector3D)object2).getY(), ((Vector3D)object2).getZ(), ((Vector3D)object).getX(), ((Vector3D)object).getY(), ((Vector3D)object).getZ());
                }
            }
        }
        return nArray2;
    }

    public PolyhedronsSet buildNew(BSPTree<Euclidean3D> bSPTree) {
        return new PolyhedronsSet(bSPTree, this.getTolerance());
    }

    @Override
    protected void computeGeometricalProperties() {
        this.getTree(true).visit(new PolyhedronsSet$FacetsContributionVisitor(this));
        if (this.getSize() < 0.0) {
            this.setSize(Double.POSITIVE_INFINITY);
            this.setBarycenter(Vector3D.NaN);
            return;
        }
        PolyhedronsSet polyhedronsSet = this;
        polyhedronsSet.setSize(polyhedronsSet.getSize() / 3.0);
        this.setBarycenter(new Vector3D(1.0 / (4.0 * this.getSize()), (Vector3D)this.getBarycenter()));
    }

    public SubHyperplane<Euclidean3D> firstIntersection(Vector3D vector3D, Line line) {
        PolyhedronsSet polyhedronsSet = this;
        return polyhedronsSet.recurseFirstIntersection(polyhedronsSet.getTree(true), vector3D, line);
    }

    private SubHyperplane<Euclidean3D> recurseFirstIntersection(BSPTree<Euclidean3D> object, Vector3D vector3D, Line line) {
        Object object2;
        while ((object2 = ((BSPTree)object).getCut()) != null) {
            BSPTree<Euclidean3D> bSPTree;
            double d2;
            boolean bl;
            BSPTree<Euclidean3D> bSPTree2 = ((BSPTree)object).getMinus();
            SubHyperplane<Euclidean3D> subHyperplane = ((BSPTree)object).getPlus();
            object2 = (Plane)object2.getHyperplane();
            double d3 = ((Plane)object2).getOffset(vector3D);
            boolean bl2 = bl = FastMath.abs(d2) < this.getTolerance();
            if (d3 < 0.0) {
                bSPTree = bSPTree2;
                bSPTree2 = subHyperplane;
            } else {
                bSPTree = subHyperplane;
            }
            if (bl && (subHyperplane = this.boundaryFacet(vector3D, (BSPTree<Euclidean3D>)object)) != null) {
                return subHyperplane;
            }
            subHyperplane = this.recurseFirstIntersection(bSPTree, vector3D, line);
            if (subHyperplane != null) {
                return subHyperplane;
            }
            if (!bl && (object2 = ((Plane)object2).intersection(line)) != null && line.getAbscissa((Vector3D)object2) > line.getAbscissa(vector3D) && (object = this.boundaryFacet((Vector3D)object2, (BSPTree<Euclidean3D>)object)) != null) {
                return object;
            }
            object = bSPTree2;
        }
        return null;
    }

    private SubHyperplane<Euclidean3D> boundaryFacet(Vector3D point, BSPTree<Euclidean3D> object) {
        point = ((Plane)((BSPTree)object).getCut().getHyperplane()).toSubSpace((Point)point);
        if (((BoundaryAttribute)(object = (BoundaryAttribute)((BSPTree)object).getAttribute())).getPlusOutside() != null && ((SubPlane)((BoundaryAttribute)object).getPlusOutside()).getRemainingRegion().checkPoint(point) == Region$Location.INSIDE) {
            return ((BoundaryAttribute)object).getPlusOutside();
        }
        if (((BoundaryAttribute)object).getPlusInside() != null && ((SubPlane)((BoundaryAttribute)object).getPlusInside()).getRemainingRegion().checkPoint(point) == Region$Location.INSIDE) {
            return ((BoundaryAttribute)object).getPlusInside();
        }
        return null;
    }

    public PolyhedronsSet rotate(Vector3D vector3D, Rotation rotation) {
        return (PolyhedronsSet)this.applyTransform(new PolyhedronsSet$RotationTransform(vector3D, rotation));
    }

    public PolyhedronsSet translate(Vector3D vector3D) {
        return (PolyhedronsSet)this.applyTransform(new PolyhedronsSet$TranslationTransform(vector3D));
    }

    static /* synthetic */ void access$000(PolyhedronsSet polyhedronsSet, double d2) {
        polyhedronsSet.setSize(d2);
    }

    static /* synthetic */ void access$100(PolyhedronsSet polyhedronsSet, Point point) {
        polyhedronsSet.setBarycenter(point);
    }

    static /* synthetic */ void access$200(PolyhedronsSet polyhedronsSet, double d2) {
        polyhedronsSet.setSize(d2);
    }

    static /* synthetic */ void access$300(PolyhedronsSet polyhedronsSet, Point point) {
        polyhedronsSet.setBarycenter(point);
    }

    static /* synthetic */ void access$400(PolyhedronsSet polyhedronsSet, double d2) {
        polyhedronsSet.setSize(d2);
    }

    static /* synthetic */ void access$500(PolyhedronsSet polyhedronsSet, Point point) {
        polyhedronsSet.setBarycenter(point);
    }
}

