/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathArithmeticException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Vector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Euclidean3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Line;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.PolyhedronsSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Rotation;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.SubPlane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.PolygonsSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Embedding;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Hyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plane
implements Embedding<Euclidean3D, Euclidean2D>,
Hyperplane<Euclidean3D> {
    private static final double DEFAULT_TOLERANCE = 1.0E-10;
    private double originOffset;
    private Vector3D origin;
    private Vector3D u;
    private Vector3D v;
    private Vector3D w;
    private final double tolerance;

    public Plane(Vector3D vector3D, double d2) {
        this.setNormal(vector3D);
        this.tolerance = d2;
        this.originOffset = 0.0;
        this.setFrame();
    }

    public Plane(Vector3D vector3D, Vector3D vector3D2, double d2) {
        this.setNormal(vector3D2);
        this.tolerance = d2;
        this.originOffset = -vector3D.dotProduct(this.w);
        this.setFrame();
    }

    public Plane(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, double d2) {
        this(vector3D, ((Vector3D)vector3D2.subtract((Vector)vector3D)).crossProduct(vector3D3.subtract((Vector)vector3D)), d2);
    }

    @Deprecated
    public Plane(Vector3D vector3D) {
        this(vector3D, 1.0E-10);
    }

    @Deprecated
    public Plane(Vector3D vector3D, Vector3D vector3D2) {
        this(vector3D, vector3D2, 1.0E-10);
    }

    @Deprecated
    public Plane(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        this(vector3D, vector3D2, vector3D3, 1.0E-10);
    }

    public Plane(Plane plane) {
        this.originOffset = plane.originOffset;
        this.origin = plane.origin;
        this.u = plane.u;
        this.v = plane.v;
        this.w = plane.w;
        this.tolerance = plane.tolerance;
    }

    public Plane copySelf() {
        return new Plane(this);
    }

    public void reset(Vector3D vector3D, Vector3D vector3D2) {
        this.setNormal(vector3D2);
        this.originOffset = -vector3D.dotProduct(this.w);
        this.setFrame();
    }

    public void reset(Plane plane) {
        this.originOffset = plane.originOffset;
        this.origin = plane.origin;
        this.u = plane.u;
        this.v = plane.v;
        this.w = plane.w;
    }

    private void setNormal(Vector3D vector3D) {
        double d2;
        double d3 = vector3D.getNorm();
        if (d2 < 1.0E-10) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        this.w = new Vector3D(1.0 / d3, vector3D);
    }

    private void setFrame() {
        this.origin = new Vector3D(-this.originOffset, this.w);
        this.u = this.w.orthogonal();
        this.v = Vector3D.crossProduct(this.w, this.u);
    }

    public Vector3D getOrigin() {
        return this.origin;
    }

    public Vector3D getNormal() {
        return this.w;
    }

    public Vector3D getU() {
        return this.u;
    }

    public Vector3D getV() {
        return this.v;
    }

    @Override
    public Point<Euclidean3D> project(Point<Euclidean3D> point) {
        Plane plane = this;
        return plane.toSpace((Vector<Euclidean2D>)plane.toSubSpace((Point)point));
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    public void revertSelf() {
        Vector3D vector3D = this.u;
        this.u = this.v;
        this.v = vector3D;
        this.w = this.w.negate();
        this.originOffset = -this.originOffset;
    }

    public Vector2D toSubSpace(Vector<Euclidean3D> vector) {
        return this.toSubSpace((Point)vector);
    }

    public Vector3D toSpace(Vector<Euclidean2D> vector) {
        return this.toSpace((Point)vector);
    }

    public Vector2D toSubSpace(Point<Euclidean3D> vector3D) {
        vector3D = vector3D;
        return new Vector2D(vector3D.dotProduct(this.u), vector3D.dotProduct(this.v));
    }

    public Vector3D toSpace(Point<Euclidean2D> vector2D) {
        vector2D = vector2D;
        return new Vector3D(vector2D.getX(), this.u, vector2D.getY(), this.v, -this.originOffset, this.w);
    }

    public Vector3D getPointAt(Vector2D vector2D, double d2) {
        return new Vector3D(vector2D.getX(), this.u, vector2D.getY(), this.v, d2 - this.originOffset, this.w);
    }

    public boolean isSimilarTo(Plane plane) {
        double d2;
        double d3 = Vector3D.angle(this.w, plane.w);
        return d2 < 1.0E-10 && FastMath.abs(this.originOffset - plane.originOffset) < this.tolerance || d3 > 3.141592653489793 && FastMath.abs(this.originOffset + plane.originOffset) < this.tolerance;
    }

    public Plane rotate(Vector3D object, Rotation rotation) {
        Vector vector = this.origin.subtract((Vector)object);
        object = new Plane((Vector3D)((Vector3D)object).add((Vector)rotation.applyTo((Vector3D)vector)), rotation.applyTo(this.w), this.tolerance);
        v0.u = rotation.applyTo(this.u);
        ((Plane)object).v = rotation.applyTo(this.v);
        return object;
    }

    public Plane translate(Vector3D object) {
        object = new Plane((Vector3D)this.origin.add((Vector)object), this.w, this.tolerance);
        v0.u = this.u;
        ((Plane)object).v = this.v;
        return object;
    }

    public Vector3D intersection(Line object) {
        double d2;
        Vector3D vector3D = ((Line)object).getDirection();
        double d3 = this.w.dotProduct(vector3D);
        if (FastMath.abs(d2) < 1.0E-10) {
            return null;
        }
        object = ((Line)object).toSpace((Point)Vector1D.ZERO);
        double d4 = -(this.originOffset + this.w.dotProduct((Vector<Euclidean3D>)object)) / d3;
        return new Vector3D(1.0, (Vector3D)object, d4, vector3D);
    }

    public Line intersection(Plane object) {
        Vector3D vector3D;
        Vector3D vector3D2 = Vector3D.crossProduct(this.w, ((Plane)object).w);
        if (vector3D.getNorm() < this.tolerance) {
            return null;
        }
        Object object2 = object = Plane.intersection(this, (Plane)object, new Plane(vector3D2, this.tolerance));
        return new Line((Vector3D)object2, (Vector3D)((Vector3D)object2).add((Vector)vector3D2), this.tolerance);
    }

    public static Vector3D intersection(Plane plane, Plane plane2, Plane plane3) {
        double d2;
        double d3 = plane.w.getX();
        double d4 = plane.w.getY();
        double d5 = plane.w.getZ();
        double d6 = plane.originOffset;
        double d7 = plane2.w.getX();
        double d8 = plane2.w.getY();
        double d9 = plane2.w.getZ();
        double d10 = plane2.originOffset;
        double d11 = plane3.w.getX();
        double d12 = plane3.w.getY();
        double d13 = plane3.w.getZ();
        double d14 = plane3.originOffset;
        double d15 = d8 * d13 - d12 * d9;
        double d16 = d9 * d11 - d13 * d7;
        double d17 = d7 * d12 - d11 * d8;
        double d18 = d3 * d15 + d4 * d16 + d5 * d17;
        if (FastMath.abs(d2) < 1.0E-10) {
            return null;
        }
        double d19 = 1.0 / d18;
        return new Vector3D((-d15 * d6 - (d5 * d12 - d13 * d4) * d10 - (d9 * d4 - d5 * d8) * d14) * d19, (-d16 * d6 - (d13 * d3 - d5 * d11) * d10 - (d5 * d7 - d9 * d3) * d14) * d19, (-d17 * d6 - (d4 * d11 - d12 * d3) * d10 - (d8 * d3 - d4 * d7) * d14) * d19);
    }

    public SubPlane wholeHyperplane() {
        return new SubPlane(this, new PolygonsSet(this.tolerance));
    }

    public PolyhedronsSet wholeSpace() {
        return new PolyhedronsSet(this.tolerance);
    }

    public boolean contains(Vector3D vector3D) {
        return FastMath.abs(this.getOffset(vector3D)) < this.tolerance;
    }

    public double getOffset(Plane plane) {
        return this.originOffset + (this.sameOrientationAs(plane) ? -plane.originOffset : plane.originOffset);
    }

    @Override
    public double getOffset(Vector<Euclidean3D> vector) {
        return this.getOffset((Point<Euclidean3D>)vector);
    }

    @Override
    public double getOffset(Point<Euclidean3D> point) {
        return ((Vector3D)point).dotProduct(this.w) + this.originOffset;
    }

    @Override
    public boolean sameOrientationAs(Hyperplane<Euclidean3D> hyperplane) {
        return ((Plane)hyperplane).w.dotProduct(this.w) > 0.0;
    }
}

