/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.OutlineExtractor$BoundaryProjector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.PolyhedronsSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class OutlineExtractor {
    private Vector3D u;
    private Vector3D v;
    private Vector3D w;

    public OutlineExtractor(Vector3D vector3D, Vector3D vector3D2) {
        this.u = vector3D;
        this.v = vector3D2;
        this.w = Vector3D.crossProduct(vector3D, vector3D2);
    }

    public Vector2D[][] getOutline(PolyhedronsSet vector2DArray) {
        OutlineExtractor$BoundaryProjector outlineExtractor$BoundaryProjector = new OutlineExtractor$BoundaryProjector(this, vector2DArray.getTolerance());
        vector2DArray.getTree(true).visit(outlineExtractor$BoundaryProjector);
        vector2DArray = outlineExtractor$BoundaryProjector.getProjected();
        vector2DArray = vector2DArray.getVertices();
        for (int i2 = 0; i2 < vector2DArray.length; ++i2) {
            Vector2D[] vector2DArray2 = vector2DArray[i2];
            int n = vector2DArray2.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.pointIsBetween(vector2DArray2, n, n2)) {
                    for (int i3 = n2; i3 < n - 1; ++i3) {
                        vector2DArray2[i3] = vector2DArray2[i3 + 1];
                    }
                    --n;
                    continue;
                }
                ++n2;
            }
            if (n == vector2DArray2.length) continue;
            vector2DArray[i2] = new Vector2D[n];
            System.arraycopy(vector2DArray2, 0, vector2DArray[i2], 0, n);
        }
        return vector2DArray;
    }

    private boolean pointIsBetween(Vector2D[] object, int n, int n2) {
        Vector2D vector2D = object[(n2 + n - 1) % n];
        Vector2D vector2D2 = object[n2];
        object = object[(n2 + 1) % n];
        double d2 = vector2D2.getX() - vector2D.getX();
        double d3 = vector2D2.getY() - vector2D.getY();
        double d4 = ((Vector2D)object).getX() - vector2D2.getX();
        double d5 = ((Vector2D)object).getY() - vector2D2.getY();
        double d6 = d2 * d5 - d4 * d3;
        double d7 = d2 * d4 + d3 * d5;
        double d8 = d2;
        double d9 = d3;
        double d10 = d4;
        double d11 = d5;
        double d12 = FastMath.sqrt((d8 * d8 + d9 * d9) * (d10 * d10 + d11 * d11));
        return FastMath.abs(d6) <= d12 * 1.0E-6 && d7 >= 0.0;
    }

    static /* synthetic */ Vector3D access$000(OutlineExtractor outlineExtractor) {
        return outlineExtractor.w;
    }

    static /* synthetic */ Vector3D access$100(OutlineExtractor outlineExtractor) {
        return outlineExtractor.u;
    }

    static /* synthetic */ Vector3D access$200(OutlineExtractor outlineExtractor) {
        return outlineExtractor.v;
    }
}

