/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Vector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Euclidean1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.IntervalsSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Euclidean3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.SubLine;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Embedding;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Line
implements Embedding<Euclidean3D, Euclidean1D> {
    private static final double DEFAULT_TOLERANCE = 1.0E-10;
    private Vector3D direction;
    private Vector3D zero;
    private final double tolerance;

    public Line(Vector3D vector3D, Vector3D vector3D2, double d2) {
        this.reset(vector3D, vector3D2);
        this.tolerance = d2;
    }

    public Line(Line line) {
        this.direction = line.direction;
        this.zero = line.zero;
        this.tolerance = line.tolerance;
    }

    @Deprecated
    public Line(Vector3D vector3D, Vector3D vector3D2) {
        this(vector3D, vector3D2, 1.0E-10);
    }

    public void reset(Vector3D vector3D, Vector3D vector) {
        double d2 = (vector = vector.subtract((Vector)vector3D)).getNormSq();
        if (d2 == 0.0) {
            throw new MathIllegalArgumentException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        this.direction = new Vector3D(1.0 / FastMath.sqrt(d2), (Vector3D)vector);
        Vector3D vector3D2 = vector3D;
        this.zero = new Vector3D(1.0, vector3D2, -vector3D2.dotProduct(vector) / d2, (Vector3D)vector);
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public Line revert() {
        Line line = new Line(this);
        new Line(this).direction = line.direction.negate();
        return line;
    }

    public Vector3D getDirection() {
        return this.direction;
    }

    public Vector3D getOrigin() {
        return this.zero;
    }

    public double getAbscissa(Vector3D vector3D) {
        return ((Vector3D)vector3D.subtract((Vector)this.zero)).dotProduct(this.direction);
    }

    public Vector3D pointAt(double d2) {
        return new Vector3D(1.0, this.zero, d2, this.direction);
    }

    public Vector1D toSubSpace(Vector<Euclidean3D> vector) {
        return this.toSubSpace((Point)vector);
    }

    public Vector3D toSpace(Vector<Euclidean1D> vector) {
        return this.toSpace((Point)vector);
    }

    public Vector1D toSubSpace(Point<Euclidean3D> point) {
        return new Vector1D(this.getAbscissa((Vector3D)point));
    }

    public Vector3D toSpace(Point<Euclidean1D> point) {
        return this.pointAt(((Vector1D)point).getX());
    }

    public boolean isSimilarTo(Line line) {
        double d2 = Vector3D.angle(this.direction, line.direction);
        return (d2 < this.tolerance || d2 > Math.PI - this.tolerance) && this.contains(line.zero);
    }

    public boolean contains(Vector3D vector3D) {
        return this.distance(vector3D) < this.tolerance;
    }

    public double distance(Vector3D vector) {
        Vector<Euclidean3D> vector2 = vector = ((Vector3D)vector).subtract((Vector)this.zero);
        vector = new Vector3D(1.0, (Vector3D)vector2, -((Vector3D)vector2).dotProduct(this.direction), this.direction);
        return ((Vector3D)vector).getNorm();
    }

    public double distance(Line line) {
        double d2;
        Vector3D vector3D = Vector3D.crossProduct(this.direction, line.direction);
        double d3 = vector3D.getNorm();
        if (d2 < Precision.SAFE_MIN) {
            return this.distance(line.zero);
        }
        double d4 = ((Vector3D)line.zero.subtract((Vector)this.zero)).dotProduct(vector3D) / d3;
        return FastMath.abs(d4);
    }

    public Vector3D closestPoint(Line line) {
        double d2;
        double d3;
        double d4 = d3 = this.direction.dotProduct(line.direction);
        double d5 = 1.0 - d4 * d4;
        if (d2 < Precision.EPSILON) {
            return this.zero;
        }
        Vector vector = line.zero.subtract((Vector)this.zero);
        double d6 = ((Vector3D)vector).dotProduct(this.direction);
        double d7 = ((Vector3D)vector).dotProduct(line.direction);
        return new Vector3D(1.0, this.zero, (d6 - d7 * d3) / d5, this.direction);
    }

    public Vector3D intersection(Line line) {
        Vector3D vector3D = this.closestPoint(line);
        if (line.contains(vector3D)) {
            return vector3D;
        }
        return null;
    }

    public SubLine wholeLine() {
        return new SubLine(this, new IntervalsSet(this.tolerance));
    }
}

