/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.Field;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.RealFieldElement;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathArithmeticException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.CardanEulerSingularityException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.NotARotationMatrixException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Rotation;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.RotationConvention;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.RotationOrder;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldRotation<T extends RealFieldElement<T>>
implements Serializable {
    private static final long serialVersionUID = 20130224L;
    private final T q0;
    private final T q1;
    private final T q2;
    private final T q3;

    public FieldRotation(T t, T t2, T t3, T t4, boolean bl) {
        if (bl) {
            T t5 = t;
            T t6 = t2;
            T t7 = t3;
            T t8 = t4;
            RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)t5.multiply(t5)).add(t6.multiply(t6))).add(t7.multiply(t7))).add(t8.multiply(t8))).sqrt()).reciprocal();
            this.q0 = (RealFieldElement)realFieldElement.multiply(t);
            this.q1 = (RealFieldElement)realFieldElement.multiply(t2);
            this.q2 = (RealFieldElement)realFieldElement.multiply(t3);
            this.q3 = (RealFieldElement)realFieldElement.multiply(t4);
            return;
        }
        this.q0 = t;
        this.q1 = t2;
        this.q2 = t3;
        this.q3 = t4;
    }

    @Deprecated
    public FieldRotation(FieldVector3D<T> fieldVector3D, T t) {
        this(fieldVector3D, t, RotationConvention.VECTOR_OPERATOR);
    }

    public FieldRotation(FieldVector3D<T> fieldVector3D, T object, RotationConvention object2) {
        T t = fieldVector3D.getNorm();
        if (t.getReal() == 0.0) {
            throw new MathIllegalArgumentException(LocalizedFormats.ZERO_NORM_FOR_ROTATION_AXIS, new Object[0]);
        }
        object = (RealFieldElement)object.multiply(object2 == RotationConvention.VECTOR_OPERATOR ? -0.5 : 0.5);
        object2 = (RealFieldElement)((RealFieldElement)object.sin()).divide(t);
        this.q0 = (RealFieldElement)object.cos();
        this.q1 = (RealFieldElement)object2.multiply(fieldVector3D.getX());
        this.q2 = (RealFieldElement)object2.multiply(fieldVector3D.getY());
        this.q3 = (RealFieldElement)object2.multiply(fieldVector3D.getZ());
    }

    public FieldRotation(T[][] object, double d2) {
        RealFieldElement realFieldElement;
        if (((T[][])object).length != 3 || object[0].length != 3 || object[1].length != 3 || object[2].length != 3) {
            throw new NotARotationMatrixException(LocalizedFormats.ROTATION_MATRIX_DIMENSIONS, ((T[][])object).length, object[0].length);
        }
        object = this.orthogonalizeMatrix((RealFieldElement[][])object, d2);
        RealFieldElement realFieldElement2 = (RealFieldElement)((RealFieldElement)object[1][1].multiply(object[2][2])).subtract(object[2][1].multiply(object[1][2]));
        RealFieldElement realFieldElement3 = (RealFieldElement)((RealFieldElement)object[0][1].multiply(object[2][2])).subtract(object[2][1].multiply(object[0][2]));
        RealFieldElement realFieldElement4 = (RealFieldElement)((RealFieldElement)object[0][1].multiply(object[1][2])).subtract(object[1][1].multiply(object[0][2]));
        realFieldElement2 = object[0][0].multiply((RealFieldElement)realFieldElement2).subtract(object[1][0].multiply((RealFieldElement)realFieldElement3)).add(object[2][0].multiply((RealFieldElement)realFieldElement4));
        if (realFieldElement.getReal() < 0.0) {
            throw new NotARotationMatrixException(LocalizedFormats.CLOSEST_ORTHOGONAL_MATRIX_HAS_NEGATIVE_DETERMINANT, realFieldElement2);
        }
        object = this.mat2quat((RealFieldElement[][])object);
        this.q0 = object[0];
        this.q1 = object[1];
        this.q2 = object[2];
        this.q3 = object[3];
    }

    public FieldRotation(FieldVector3D<T> realFieldElementArray, FieldVector3D<T> fieldVector3D, FieldVector3D<T> fieldVector3D2, FieldVector3D<T> fieldVector3D3) {
        FieldVector3D<T> fieldVector3D4 = FieldVector3D.crossProduct(realFieldElementArray, fieldVector3D).normalize();
        fieldVector3D = FieldVector3D.crossProduct(fieldVector3D4, realFieldElementArray).normalize();
        realFieldElementArray = realFieldElementArray.normalize();
        FieldVector3D<T> fieldVector3D5 = FieldVector3D.crossProduct(fieldVector3D2, fieldVector3D3).normalize();
        fieldVector3D3 = FieldVector3D.crossProduct(fieldVector3D5, fieldVector3D2).normalize();
        fieldVector3D2 = fieldVector3D2.normalize();
        RealFieldElement[][] realFieldElementArray2 = (RealFieldElement[][])MathArrays.buildArray(realFieldElementArray.getX().getField(), 3, 3);
        realFieldElementArray2[0][0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElementArray.getX().multiply(fieldVector3D2.getX())).add(fieldVector3D.getX().multiply(fieldVector3D3.getX()))).add(fieldVector3D4.getX().multiply(fieldVector3D5.getX()));
        realFieldElementArray2[0][1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElementArray.getY().multiply(fieldVector3D2.getX())).add(fieldVector3D.getY().multiply(fieldVector3D3.getX()))).add(fieldVector3D4.getY().multiply(fieldVector3D5.getX()));
        realFieldElementArray2[0][2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElementArray.getZ().multiply(fieldVector3D2.getX())).add(fieldVector3D.getZ().multiply(fieldVector3D3.getX()))).add(fieldVector3D4.getZ().multiply(fieldVector3D5.getX()));
        realFieldElementArray2[1][0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElementArray.getX().multiply(fieldVector3D2.getY())).add(fieldVector3D.getX().multiply(fieldVector3D3.getY()))).add(fieldVector3D4.getX().multiply(fieldVector3D5.getY()));
        realFieldElementArray2[1][1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElementArray.getY().multiply(fieldVector3D2.getY())).add(fieldVector3D.getY().multiply(fieldVector3D3.getY()))).add(fieldVector3D4.getY().multiply(fieldVector3D5.getY()));
        realFieldElementArray2[1][2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElementArray.getZ().multiply(fieldVector3D2.getY())).add(fieldVector3D.getZ().multiply(fieldVector3D3.getY()))).add(fieldVector3D4.getZ().multiply(fieldVector3D5.getY()));
        realFieldElementArray2[2][0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElementArray.getX().multiply(fieldVector3D2.getZ())).add(fieldVector3D.getX().multiply(fieldVector3D3.getZ()))).add(fieldVector3D4.getX().multiply(fieldVector3D5.getZ()));
        realFieldElementArray2[2][1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElementArray.getY().multiply(fieldVector3D2.getZ())).add(fieldVector3D.getY().multiply(fieldVector3D3.getZ()))).add(fieldVector3D4.getY().multiply(fieldVector3D5.getZ()));
        realFieldElementArray2[2][2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElementArray.getZ().multiply(fieldVector3D2.getZ())).add(fieldVector3D.getZ().multiply(fieldVector3D3.getZ()))).add(fieldVector3D4.getZ().multiply(fieldVector3D5.getZ()));
        realFieldElementArray = this.mat2quat(realFieldElementArray2);
        this.q0 = realFieldElementArray[0];
        this.q1 = realFieldElementArray[1];
        this.q2 = realFieldElementArray[2];
        this.q3 = realFieldElementArray[3];
    }

    public FieldRotation(FieldVector3D<T> fieldVector3D, FieldVector3D<T> fieldVector3D2) {
        RealFieldElement realFieldElement;
        RealFieldElement realFieldElement2 = (RealFieldElement)fieldVector3D.getNorm().multiply(fieldVector3D2.getNorm());
        if (realFieldElement2.getReal() == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM_FOR_ROTATION_DEFINING_VECTOR, new Object[0]);
        }
        Object object = FieldVector3D.dotProduct(fieldVector3D, fieldVector3D2);
        if (realFieldElement.getReal() < -0.999999999999998 * realFieldElement2.getReal()) {
            object = fieldVector3D.orthogonal();
            this.q0 = (RealFieldElement)realFieldElement2.getField().getZero();
            this.q1 = (RealFieldElement)((FieldVector3D)object).getX().negate();
            this.q2 = (RealFieldElement)((FieldVector3D)object).getY().negate();
            this.q3 = (RealFieldElement)((FieldVector3D)object).getZ().negate();
            return;
        }
        this.q0 = (RealFieldElement)((RealFieldElement)((RealFieldElement)object.divide((RealFieldElement)realFieldElement2).add(1.0)).multiply(0.5)).sqrt();
        object = (RealFieldElement)((RealFieldElement)this.q0.multiply((RealFieldElement)realFieldElement2).multiply(2.0)).reciprocal();
        fieldVector3D = FieldVector3D.crossProduct(fieldVector3D2, fieldVector3D);
        this.q1 = (RealFieldElement)object.multiply(fieldVector3D.getX());
        this.q2 = (RealFieldElement)object.multiply(fieldVector3D.getY());
        this.q3 = (RealFieldElement)object.multiply(fieldVector3D.getZ());
    }

    @Deprecated
    public FieldRotation(RotationOrder rotationOrder, T t, T t2, T t3) {
        this(rotationOrder, RotationConvention.VECTOR_OPERATOR, t, t2, t3);
    }

    public FieldRotation(RotationOrder fieldRotation, RotationConvention rotationConvention, T object, T object2, T t) {
        RealFieldElement realFieldElement = (RealFieldElement)object.getField().getOne();
        object = new FieldRotation<RealFieldElement>(new FieldVector3D<RealFieldElement>(realFieldElement, ((RotationOrder)((Object)fieldRotation)).getA1()), (RealFieldElement)object, rotationConvention);
        object2 = new FieldRotation<RealFieldElement>(new FieldVector3D<RealFieldElement>(realFieldElement, ((RotationOrder)((Object)fieldRotation)).getA2()), (RealFieldElement)object2, rotationConvention);
        fieldRotation = new FieldRotation<RealFieldElement>(new FieldVector3D<RealFieldElement>(realFieldElement, ((RotationOrder)((Object)fieldRotation)).getA3()), (RealFieldElement)t, rotationConvention);
        fieldRotation = ((FieldRotation)object).compose(((FieldRotation)object2).compose(fieldRotation, rotationConvention), rotationConvention);
        this.q0 = fieldRotation.q0;
        this.q1 = fieldRotation.q1;
        this.q2 = fieldRotation.q2;
        this.q3 = fieldRotation.q3;
    }

    private T[] mat2quat(T[][] TArray) {
        RealFieldElement realFieldElement;
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(TArray[0][0].getField(), 4);
        RealFieldElement realFieldElement2 = (RealFieldElement)((RealFieldElement)TArray[0][0].add(TArray[1][1])).add(TArray[2][2]);
        if (realFieldElement.getReal() > -0.19) {
            realFieldElementArray[0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement2.add(1.0)).sqrt()).multiply(0.5);
            realFieldElement2 = (RealFieldElement)((RealFieldElement)realFieldElementArray[0].reciprocal()).multiply(0.25);
            realFieldElementArray[1] = (RealFieldElement)realFieldElement2.multiply(TArray[1][2].subtract(TArray[2][1]));
            realFieldElementArray[2] = (RealFieldElement)realFieldElement2.multiply(TArray[2][0].subtract(TArray[0][2]));
            realFieldElementArray[3] = (RealFieldElement)realFieldElement2.multiply(TArray[0][1].subtract(TArray[1][0]));
        } else {
            RealFieldElement realFieldElement3;
            realFieldElement2 = (RealFieldElement)((RealFieldElement)TArray[0][0].subtract(TArray[1][1])).subtract(TArray[2][2]);
            if (realFieldElement3.getReal() > -0.19) {
                realFieldElementArray[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement2.add(1.0)).sqrt()).multiply(0.5);
                realFieldElement2 = (RealFieldElement)((RealFieldElement)realFieldElementArray[1].reciprocal()).multiply(0.25);
                realFieldElementArray[0] = (RealFieldElement)realFieldElement2.multiply(TArray[1][2].subtract(TArray[2][1]));
                realFieldElementArray[2] = (RealFieldElement)realFieldElement2.multiply(TArray[0][1].add(TArray[1][0]));
                realFieldElementArray[3] = (RealFieldElement)realFieldElement2.multiply(TArray[0][2].add(TArray[2][0]));
            } else {
                RealFieldElement realFieldElement4;
                realFieldElement2 = (RealFieldElement)((RealFieldElement)TArray[1][1].subtract(TArray[0][0])).subtract(TArray[2][2]);
                if (realFieldElement4.getReal() > -0.19) {
                    realFieldElementArray[2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement2.add(1.0)).sqrt()).multiply(0.5);
                    realFieldElement2 = (RealFieldElement)((RealFieldElement)realFieldElementArray[2].reciprocal()).multiply(0.25);
                    realFieldElementArray[0] = (RealFieldElement)realFieldElement2.multiply(TArray[2][0].subtract(TArray[0][2]));
                    realFieldElementArray[1] = (RealFieldElement)realFieldElement2.multiply(TArray[0][1].add(TArray[1][0]));
                    realFieldElementArray[3] = (RealFieldElement)realFieldElement2.multiply(TArray[2][1].add(TArray[1][2]));
                } else {
                    realFieldElement2 = (RealFieldElement)((RealFieldElement)TArray[2][2].subtract(TArray[0][0])).subtract(TArray[1][1]);
                    realFieldElementArray[3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement2.add(1.0)).sqrt()).multiply(0.5);
                    realFieldElement2 = (RealFieldElement)((RealFieldElement)realFieldElementArray[3].reciprocal()).multiply(0.25);
                    realFieldElementArray[0] = (RealFieldElement)realFieldElement2.multiply(TArray[0][1].subtract(TArray[1][0]));
                    realFieldElementArray[1] = (RealFieldElement)realFieldElement2.multiply(TArray[0][2].add(TArray[2][0]));
                    realFieldElementArray[2] = (RealFieldElement)realFieldElement2.multiply(TArray[2][1].add(TArray[1][2]));
                }
            }
        }
        return realFieldElementArray;
    }

    public FieldRotation<T> revert() {
        return new FieldRotation<RealFieldElement>((RealFieldElement)this.q0.negate(), (RealFieldElement)this.q1, (RealFieldElement)this.q2, (RealFieldElement)this.q3, false);
    }

    public T getQ0() {
        return this.q0;
    }

    public T getQ1() {
        return this.q1;
    }

    public T getQ2() {
        return this.q2;
    }

    public T getQ3() {
        return this.q3;
    }

    @Deprecated
    public FieldVector3D<T> getAxis() {
        return this.getAxis(RotationConvention.VECTOR_OPERATOR);
    }

    public FieldVector3D<T> getAxis(RotationConvention object) {
        double d2;
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q1.multiply(this.q1)).add(this.q2.multiply(this.q2))).add(this.q3.multiply(this.q3));
        if (realFieldElement.getReal() == 0.0) {
            Field field = realFieldElement.getField();
            return new FieldVector3D<RealFieldElement>(object == RotationConvention.VECTOR_OPERATOR ? (RealFieldElement)field.getOne() : (RealFieldElement)((RealFieldElement)field.getOne()).negate(), (RealFieldElement)field.getZero(), (RealFieldElement)field.getZero());
        }
        double d3 = d2 = object == RotationConvention.VECTOR_OPERATOR ? 1.0 : -1.0;
        if (this.q0.getReal() < 0.0) {
            object = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.sqrt()).reciprocal()).multiply(d2);
            return new FieldVector3D<RealFieldElement>((RealFieldElement)((Object)this.q1.multiply((RotationConvention)((Object)object))), (RealFieldElement)((Object)this.q2.multiply((RotationConvention)((Object)object))), (RealFieldElement)((Object)this.q3.multiply((RotationConvention)((Object)object))));
        }
        object = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.sqrt()).reciprocal()).negate()).multiply(d2);
        return new FieldVector3D<RealFieldElement>((RealFieldElement)((Object)this.q1.multiply((RotationConvention)((Object)object))), (RealFieldElement)((Object)this.q2.multiply((RotationConvention)((Object)object))), (RealFieldElement)((Object)this.q3.multiply((RotationConvention)((Object)object))));
    }

    public T getAngle() {
        if (this.q0.getReal() < -0.1 || this.q0.getReal() > 0.1) {
            return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q1.multiply(this.q1)).add(this.q2.multiply(this.q2))).add(this.q3.multiply(this.q3))).sqrt()).asin()).multiply(2));
        }
        if (this.q0.getReal() < 0.0) {
            return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.negate()).acos()).multiply(2));
        }
        return (T)((RealFieldElement)((RealFieldElement)this.q0.acos()).multiply(2));
    }

    @Deprecated
    public T[] getAngles(RotationOrder rotationOrder) {
        return this.getAngles(rotationOrder, RotationConvention.VECTOR_OPERATOR);
    }

    public T[] getAngles(RotationOrder fieldVector3D, RotationConvention object) {
        if (object == RotationConvention.VECTOR_OPERATOR) {
            if (fieldVector3D == RotationOrder.XYZ) {
                FieldRotation fieldRotation = this;
                fieldVector3D = fieldRotation.applyTo(fieldRotation.vector(0.0, 0.0, 1.0));
                FieldRotation fieldRotation2 = this;
                object = fieldRotation2.applyInverseTo(fieldRotation2.vector(1.0, 0.0, 0.0));
                if (((FieldVector3D)object).getZ().getReal() < -0.9999999999 || ((FieldVector3D)object).getZ().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return this.buildArray((RealFieldElement)((RealFieldElement)fieldVector3D.getY().negate()).atan2(fieldVector3D.getZ()), (RealFieldElement)((FieldVector3D)object).getZ().asin(), (RealFieldElement)((RealFieldElement)((FieldVector3D)object).getY().negate()).atan2(((FieldVector3D)object).getX()));
            }
            if (fieldVector3D == RotationOrder.XZY) {
                FieldRotation fieldRotation = this;
                fieldVector3D = fieldRotation.applyTo(fieldRotation.vector(0.0, 1.0, 0.0));
                FieldRotation fieldRotation3 = this;
                object = fieldRotation3.applyInverseTo(fieldRotation3.vector(1.0, 0.0, 0.0));
                if (((FieldVector3D)object).getY().getReal() < -0.9999999999 || ((FieldVector3D)object).getY().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return this.buildArray((RealFieldElement)fieldVector3D.getZ().atan2(fieldVector3D.getY()), (RealFieldElement)((RealFieldElement)((FieldVector3D)object).getY().asin()).negate(), (RealFieldElement)((FieldVector3D)object).getZ().atan2(((FieldVector3D)object).getX()));
            }
            if (fieldVector3D == RotationOrder.YXZ) {
                FieldRotation fieldRotation = this;
                fieldVector3D = fieldRotation.applyTo(fieldRotation.vector(0.0, 0.0, 1.0));
                FieldRotation fieldRotation4 = this;
                object = fieldRotation4.applyInverseTo(fieldRotation4.vector(0.0, 1.0, 0.0));
                if (((FieldVector3D)object).getZ().getReal() < -0.9999999999 || ((FieldVector3D)object).getZ().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return this.buildArray((RealFieldElement)fieldVector3D.getX().atan2(fieldVector3D.getZ()), (RealFieldElement)((RealFieldElement)((FieldVector3D)object).getZ().asin()).negate(), (RealFieldElement)((FieldVector3D)object).getX().atan2(((FieldVector3D)object).getY()));
            }
            if (fieldVector3D == RotationOrder.YZX) {
                FieldRotation fieldRotation = this;
                fieldVector3D = fieldRotation.applyTo(fieldRotation.vector(1.0, 0.0, 0.0));
                FieldRotation fieldRotation5 = this;
                object = fieldRotation5.applyInverseTo(fieldRotation5.vector(0.0, 1.0, 0.0));
                if (((FieldVector3D)object).getX().getReal() < -0.9999999999 || ((FieldVector3D)object).getX().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return this.buildArray((RealFieldElement)((RealFieldElement)fieldVector3D.getZ().negate()).atan2(fieldVector3D.getX()), (RealFieldElement)((FieldVector3D)object).getX().asin(), (RealFieldElement)((RealFieldElement)((FieldVector3D)object).getZ().negate()).atan2(((FieldVector3D)object).getY()));
            }
            if (fieldVector3D == RotationOrder.ZXY) {
                FieldRotation fieldRotation = this;
                fieldVector3D = fieldRotation.applyTo(fieldRotation.vector(0.0, 1.0, 0.0));
                FieldRotation fieldRotation6 = this;
                object = fieldRotation6.applyInverseTo(fieldRotation6.vector(0.0, 0.0, 1.0));
                if (((FieldVector3D)object).getY().getReal() < -0.9999999999 || ((FieldVector3D)object).getY().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return this.buildArray((RealFieldElement)((RealFieldElement)fieldVector3D.getX().negate()).atan2(fieldVector3D.getY()), (RealFieldElement)((FieldVector3D)object).getY().asin(), (RealFieldElement)((RealFieldElement)((FieldVector3D)object).getX().negate()).atan2(((FieldVector3D)object).getZ()));
            }
            if (fieldVector3D == RotationOrder.ZYX) {
                FieldRotation fieldRotation = this;
                fieldVector3D = fieldRotation.applyTo(fieldRotation.vector(1.0, 0.0, 0.0));
                FieldRotation fieldRotation7 = this;
                object = fieldRotation7.applyInverseTo(fieldRotation7.vector(0.0, 0.0, 1.0));
                if (((FieldVector3D)object).getX().getReal() < -0.9999999999 || ((FieldVector3D)object).getX().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return this.buildArray((RealFieldElement)fieldVector3D.getY().atan2(fieldVector3D.getX()), (RealFieldElement)((RealFieldElement)((FieldVector3D)object).getX().asin()).negate(), (RealFieldElement)((FieldVector3D)object).getY().atan2(((FieldVector3D)object).getZ()));
            }
            if (fieldVector3D == RotationOrder.XYX) {
                FieldRotation fieldRotation = this;
                fieldVector3D = fieldRotation.applyTo(fieldRotation.vector(1.0, 0.0, 0.0));
                FieldRotation fieldRotation8 = this;
                object = fieldRotation8.applyInverseTo(fieldRotation8.vector(1.0, 0.0, 0.0));
                if (((FieldVector3D)object).getX().getReal() < -0.9999999999 || ((FieldVector3D)object).getX().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(false);
                }
                return this.buildArray((RealFieldElement)fieldVector3D.getY().atan2(fieldVector3D.getZ().negate()), (RealFieldElement)((FieldVector3D)object).getX().acos(), (RealFieldElement)((FieldVector3D)object).getY().atan2(((FieldVector3D)object).getZ()));
            }
            if (fieldVector3D == RotationOrder.XZX) {
                FieldRotation fieldRotation = this;
                fieldVector3D = fieldRotation.applyTo(fieldRotation.vector(1.0, 0.0, 0.0));
                FieldRotation fieldRotation9 = this;
                object = fieldRotation9.applyInverseTo(fieldRotation9.vector(1.0, 0.0, 0.0));
                if (((FieldVector3D)object).getX().getReal() < -0.9999999999 || ((FieldVector3D)object).getX().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(false);
                }
                return this.buildArray((RealFieldElement)fieldVector3D.getZ().atan2(fieldVector3D.getY()), (RealFieldElement)((FieldVector3D)object).getX().acos(), (RealFieldElement)((FieldVector3D)object).getZ().atan2(((FieldVector3D)object).getY().negate()));
            }
            if (fieldVector3D == RotationOrder.YXY) {
                FieldRotation fieldRotation = this;
                fieldVector3D = fieldRotation.applyTo(fieldRotation.vector(0.0, 1.0, 0.0));
                FieldRotation fieldRotation10 = this;
                object = fieldRotation10.applyInverseTo(fieldRotation10.vector(0.0, 1.0, 0.0));
                if (((FieldVector3D)object).getY().getReal() < -0.9999999999 || ((FieldVector3D)object).getY().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(false);
                }
                return this.buildArray((RealFieldElement)fieldVector3D.getX().atan2(fieldVector3D.getZ()), (RealFieldElement)((FieldVector3D)object).getY().acos(), (RealFieldElement)((FieldVector3D)object).getX().atan2(((FieldVector3D)object).getZ().negate()));
            }
            if (fieldVector3D == RotationOrder.YZY) {
                FieldRotation fieldRotation = this;
                fieldVector3D = fieldRotation.applyTo(fieldRotation.vector(0.0, 1.0, 0.0));
                FieldRotation fieldRotation11 = this;
                object = fieldRotation11.applyInverseTo(fieldRotation11.vector(0.0, 1.0, 0.0));
                if (((FieldVector3D)object).getY().getReal() < -0.9999999999 || ((FieldVector3D)object).getY().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(false);
                }
                return this.buildArray((RealFieldElement)fieldVector3D.getZ().atan2(fieldVector3D.getX().negate()), (RealFieldElement)((FieldVector3D)object).getY().acos(), (RealFieldElement)((FieldVector3D)object).getZ().atan2(((FieldVector3D)object).getX()));
            }
            if (fieldVector3D == RotationOrder.ZXZ) {
                FieldRotation fieldRotation = this;
                fieldVector3D = fieldRotation.applyTo(fieldRotation.vector(0.0, 0.0, 1.0));
                FieldRotation fieldRotation12 = this;
                object = fieldRotation12.applyInverseTo(fieldRotation12.vector(0.0, 0.0, 1.0));
                if (((FieldVector3D)object).getZ().getReal() < -0.9999999999 || ((FieldVector3D)object).getZ().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(false);
                }
                return this.buildArray((RealFieldElement)fieldVector3D.getX().atan2(fieldVector3D.getY().negate()), (RealFieldElement)((FieldVector3D)object).getZ().acos(), (RealFieldElement)((FieldVector3D)object).getX().atan2(((FieldVector3D)object).getY()));
            }
            FieldRotation fieldRotation = this;
            fieldVector3D = fieldRotation.applyTo(fieldRotation.vector(0.0, 0.0, 1.0));
            FieldRotation fieldRotation13 = this;
            object = fieldRotation13.applyInverseTo(fieldRotation13.vector(0.0, 0.0, 1.0));
            if (((FieldVector3D)object).getZ().getReal() < -0.9999999999 || ((FieldVector3D)object).getZ().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return this.buildArray((RealFieldElement)fieldVector3D.getY().atan2(fieldVector3D.getX()), (RealFieldElement)((FieldVector3D)object).getZ().acos(), (RealFieldElement)((FieldVector3D)object).getY().atan2(((FieldVector3D)object).getX().negate()));
        }
        if (fieldVector3D == RotationOrder.XYZ) {
            fieldVector3D = this.applyTo(Vector3D.PLUS_I);
            object = this.applyInverseTo(Vector3D.PLUS_K);
            if (((FieldVector3D)object).getX().getReal() < -0.9999999999 || ((FieldVector3D)object).getX().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return this.buildArray((RealFieldElement)((RealFieldElement)((FieldVector3D)object).getY().negate()).atan2(((FieldVector3D)object).getZ()), (RealFieldElement)((FieldVector3D)object).getX().asin(), (RealFieldElement)((RealFieldElement)fieldVector3D.getY().negate()).atan2(fieldVector3D.getX()));
        }
        if (fieldVector3D == RotationOrder.XZY) {
            fieldVector3D = this.applyTo(Vector3D.PLUS_I);
            object = this.applyInverseTo(Vector3D.PLUS_J);
            if (((FieldVector3D)object).getX().getReal() < -0.9999999999 || ((FieldVector3D)object).getX().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return this.buildArray((RealFieldElement)((FieldVector3D)object).getZ().atan2(((FieldVector3D)object).getY()), (RealFieldElement)((RealFieldElement)((FieldVector3D)object).getX().asin()).negate(), (RealFieldElement)fieldVector3D.getZ().atan2(fieldVector3D.getX()));
        }
        if (fieldVector3D == RotationOrder.YXZ) {
            fieldVector3D = this.applyTo(Vector3D.PLUS_J);
            object = this.applyInverseTo(Vector3D.PLUS_K);
            if (((FieldVector3D)object).getY().getReal() < -0.9999999999 || ((FieldVector3D)object).getY().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return this.buildArray((RealFieldElement)((FieldVector3D)object).getX().atan2(((FieldVector3D)object).getZ()), (RealFieldElement)((RealFieldElement)((FieldVector3D)object).getY().asin()).negate(), (RealFieldElement)fieldVector3D.getX().atan2(fieldVector3D.getY()));
        }
        if (fieldVector3D == RotationOrder.YZX) {
            fieldVector3D = this.applyTo(Vector3D.PLUS_J);
            object = this.applyInverseTo(Vector3D.PLUS_I);
            if (((FieldVector3D)object).getY().getReal() < -0.9999999999 || ((FieldVector3D)object).getY().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return this.buildArray((RealFieldElement)((RealFieldElement)((FieldVector3D)object).getZ().negate()).atan2(((FieldVector3D)object).getX()), (RealFieldElement)((FieldVector3D)object).getY().asin(), (RealFieldElement)((RealFieldElement)fieldVector3D.getZ().negate()).atan2(fieldVector3D.getY()));
        }
        if (fieldVector3D == RotationOrder.ZXY) {
            fieldVector3D = this.applyTo(Vector3D.PLUS_K);
            object = this.applyInverseTo(Vector3D.PLUS_J);
            if (((FieldVector3D)object).getZ().getReal() < -0.9999999999 || ((FieldVector3D)object).getZ().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return this.buildArray((RealFieldElement)((RealFieldElement)((FieldVector3D)object).getX().negate()).atan2(((FieldVector3D)object).getY()), (RealFieldElement)((FieldVector3D)object).getZ().asin(), (RealFieldElement)((RealFieldElement)fieldVector3D.getX().negate()).atan2(fieldVector3D.getZ()));
        }
        if (fieldVector3D == RotationOrder.ZYX) {
            fieldVector3D = this.applyTo(Vector3D.PLUS_K);
            object = this.applyInverseTo(Vector3D.PLUS_I);
            if (((FieldVector3D)object).getZ().getReal() < -0.9999999999 || ((FieldVector3D)object).getZ().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return this.buildArray((RealFieldElement)((FieldVector3D)object).getY().atan2(((FieldVector3D)object).getX()), (RealFieldElement)((RealFieldElement)((FieldVector3D)object).getZ().asin()).negate(), (RealFieldElement)fieldVector3D.getY().atan2(fieldVector3D.getZ()));
        }
        if (fieldVector3D == RotationOrder.XYX) {
            fieldVector3D = this.applyTo(Vector3D.PLUS_I);
            object = this.applyInverseTo(Vector3D.PLUS_I);
            if (((FieldVector3D)object).getX().getReal() < -0.9999999999 || ((FieldVector3D)object).getX().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return this.buildArray((RealFieldElement)((FieldVector3D)object).getY().atan2(((FieldVector3D)object).getZ().negate()), (RealFieldElement)((FieldVector3D)object).getX().acos(), (RealFieldElement)fieldVector3D.getY().atan2(fieldVector3D.getZ()));
        }
        if (fieldVector3D == RotationOrder.XZX) {
            fieldVector3D = this.applyTo(Vector3D.PLUS_I);
            object = this.applyInverseTo(Vector3D.PLUS_I);
            if (((FieldVector3D)object).getX().getReal() < -0.9999999999 || ((FieldVector3D)object).getX().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return this.buildArray((RealFieldElement)((FieldVector3D)object).getZ().atan2(((FieldVector3D)object).getY()), (RealFieldElement)((FieldVector3D)object).getX().acos(), (RealFieldElement)fieldVector3D.getZ().atan2(fieldVector3D.getY().negate()));
        }
        if (fieldVector3D == RotationOrder.YXY) {
            fieldVector3D = this.applyTo(Vector3D.PLUS_J);
            object = this.applyInverseTo(Vector3D.PLUS_J);
            if (((FieldVector3D)object).getY().getReal() < -0.9999999999 || ((FieldVector3D)object).getY().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return this.buildArray((RealFieldElement)((FieldVector3D)object).getX().atan2(((FieldVector3D)object).getZ()), (RealFieldElement)((FieldVector3D)object).getY().acos(), (RealFieldElement)fieldVector3D.getX().atan2(fieldVector3D.getZ().negate()));
        }
        if (fieldVector3D == RotationOrder.YZY) {
            fieldVector3D = this.applyTo(Vector3D.PLUS_J);
            object = this.applyInverseTo(Vector3D.PLUS_J);
            if (((FieldVector3D)object).getY().getReal() < -0.9999999999 || ((FieldVector3D)object).getY().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return this.buildArray((RealFieldElement)((FieldVector3D)object).getZ().atan2(((FieldVector3D)object).getX().negate()), (RealFieldElement)((FieldVector3D)object).getY().acos(), (RealFieldElement)fieldVector3D.getZ().atan2(fieldVector3D.getX()));
        }
        if (fieldVector3D == RotationOrder.ZXZ) {
            fieldVector3D = this.applyTo(Vector3D.PLUS_K);
            object = this.applyInverseTo(Vector3D.PLUS_K);
            if (((FieldVector3D)object).getZ().getReal() < -0.9999999999 || ((FieldVector3D)object).getZ().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return this.buildArray((RealFieldElement)((FieldVector3D)object).getX().atan2(((FieldVector3D)object).getY().negate()), (RealFieldElement)((FieldVector3D)object).getZ().acos(), (RealFieldElement)fieldVector3D.getX().atan2(fieldVector3D.getY()));
        }
        fieldVector3D = this.applyTo(Vector3D.PLUS_K);
        object = this.applyInverseTo(Vector3D.PLUS_K);
        if (((FieldVector3D)object).getZ().getReal() < -0.9999999999 || ((FieldVector3D)object).getZ().getReal() > 0.9999999999) {
            throw new CardanEulerSingularityException(false);
        }
        return this.buildArray((RealFieldElement)((FieldVector3D)object).getY().atan2(((FieldVector3D)object).getX()), (RealFieldElement)((FieldVector3D)object).getZ().acos(), (RealFieldElement)fieldVector3D.getY().atan2(fieldVector3D.getX().negate()));
    }

    private T[] buildArray(T t, T t2, T t3) {
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(t.getField(), 3);
        RealFieldElement[] realFieldElementArray2 = realFieldElementArray;
        realFieldElementArray[0] = t;
        realFieldElementArray2[1] = t2;
        realFieldElementArray2[2] = t3;
        return realFieldElementArray2;
    }

    private FieldVector3D<T> vector(double d2, double d3, double d4) {
        RealFieldElement realFieldElement = (RealFieldElement)this.q0.getField().getZero();
        return new FieldVector3D<RealFieldElement>((RealFieldElement)realFieldElement.add(d2), (RealFieldElement)realFieldElement.add(d3), (RealFieldElement)realFieldElement.add(d4));
    }

    public T[][] getMatrix() {
        RealFieldElement realFieldElement = (RealFieldElement)this.q0.multiply(this.q0);
        RealFieldElement realFieldElement2 = (RealFieldElement)this.q0.multiply(this.q1);
        RealFieldElement realFieldElement3 = (RealFieldElement)this.q0.multiply(this.q2);
        RealFieldElement realFieldElement4 = (RealFieldElement)this.q0.multiply(this.q3);
        RealFieldElement realFieldElement5 = (RealFieldElement)this.q1.multiply(this.q1);
        RealFieldElement realFieldElement6 = (RealFieldElement)this.q1.multiply(this.q2);
        RealFieldElement realFieldElement7 = (RealFieldElement)this.q1.multiply(this.q3);
        RealFieldElement realFieldElement8 = (RealFieldElement)this.q2.multiply(this.q2);
        RealFieldElement realFieldElement9 = (RealFieldElement)this.q2.multiply(this.q3);
        RealFieldElement realFieldElement10 = (RealFieldElement)this.q3.multiply(this.q3);
        RealFieldElement[][] realFieldElementArray = (RealFieldElement[][])MathArrays.buildArray(this.q0.getField(), 3, 3);
        realFieldElementArray[0][0] = (RealFieldElement)((RealFieldElement)realFieldElement.add(realFieldElement5).multiply(2)).subtract(1.0);
        realFieldElementArray[1][0] = (RealFieldElement)realFieldElement6.subtract(realFieldElement4).multiply(2);
        realFieldElementArray[2][0] = (RealFieldElement)realFieldElement7.add(realFieldElement3).multiply(2);
        realFieldElementArray[0][1] = (RealFieldElement)realFieldElement6.add(realFieldElement4).multiply(2);
        realFieldElementArray[1][1] = (RealFieldElement)((RealFieldElement)realFieldElement.add(realFieldElement8).multiply(2)).subtract(1.0);
        realFieldElementArray[2][1] = (RealFieldElement)realFieldElement9.subtract(realFieldElement2).multiply(2);
        realFieldElementArray[0][2] = (RealFieldElement)realFieldElement7.subtract(realFieldElement3).multiply(2);
        realFieldElementArray[1][2] = (RealFieldElement)realFieldElement9.add(realFieldElement2).multiply(2);
        realFieldElementArray[2][2] = (RealFieldElement)((RealFieldElement)realFieldElement.add(realFieldElement10).multiply(2)).subtract(1.0);
        return realFieldElementArray;
    }

    public Rotation toRotation() {
        return new Rotation(this.q0.getReal(), this.q1.getReal(), this.q2.getReal(), this.q3.getReal(), false);
    }

    public FieldVector3D<T> applyTo(FieldVector3D<T> fieldVector3D) {
        T t = fieldVector3D.getX();
        T t2 = fieldVector3D.getY();
        fieldVector3D = fieldVector3D.getZ();
        RealFieldElement realFieldElement = (RealFieldElement)((Object)((RealFieldElement)((RealFieldElement)this.q1.multiply(t)).add(this.q2.multiply(t2))).add(this.q3.multiply(fieldVector3D)));
        return new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)t.multiply(this.q0)).subtract(((RealFieldElement)((Object)this.q2.multiply(fieldVector3D))).subtract(this.q3.multiply(t2))))).add(realFieldElement.multiply(this.q1))).multiply(2)).subtract(t), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((Object)this.q0.multiply(((RealFieldElement)t2.multiply(this.q0)).subtract(((RealFieldElement)this.q3.multiply(t)).subtract(this.q1.multiply(fieldVector3D)))))).add(realFieldElement.multiply(this.q2))).multiply(2)).subtract(t2), (RealFieldElement)((Object)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)fieldVector3D.multiply(this.q0)).subtract(((RealFieldElement)this.q1.multiply(t2)).subtract(this.q2.multiply(t))))).add(realFieldElement.multiply(this.q3))).multiply(2)).subtract(fieldVector3D)));
    }

    public FieldVector3D<T> applyTo(Vector3D object) {
        double d2 = ((Vector3D)object).getX();
        double d3 = ((Vector3D)object).getY();
        double d4 = ((Vector3D)object).getZ();
        object = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q1.multiply(d2)).add(this.q2.multiply(d3))).add(this.q3.multiply(d4));
        return new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)this.q0.multiply(d2)).subtract(((RealFieldElement)this.q2.multiply(d4)).subtract(this.q3.multiply(d3))))).add(object.multiply(this.q1))).multiply(2)).subtract(d2), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)this.q0.multiply(d3)).subtract(((RealFieldElement)this.q3.multiply(d2)).subtract(this.q1.multiply(d4))))).add(object.multiply(this.q2))).multiply(2)).subtract(d3), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)this.q0.multiply(d4)).subtract(((RealFieldElement)this.q1.multiply(d3)).subtract(this.q2.multiply(d2))))).add(object.multiply(this.q3))).multiply(2)).subtract(d4));
    }

    public void applyTo(T[] object, T[] TArray) {
        T t = object[0];
        T t2 = object[1];
        object = object[2];
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q1.multiply(t)).add(this.q2.multiply(t2))).add(this.q3.multiply(object));
        TArray[0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)t.multiply(this.q0)).subtract(((RealFieldElement)this.q2.multiply(object)).subtract(this.q3.multiply(t2))))).add(realFieldElement.multiply(this.q1))).multiply(2)).subtract(t);
        TArray[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)t2.multiply(this.q0)).subtract(((RealFieldElement)this.q3.multiply(t)).subtract(this.q1.multiply(object))))).add(realFieldElement.multiply(this.q2))).multiply(2)).subtract(t2);
        TArray[2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)object.multiply(this.q0)).subtract(((RealFieldElement)this.q1.multiply(t2)).subtract(this.q2.multiply(t))))).add(realFieldElement.multiply(this.q3))).multiply(2)).subtract(object);
    }

    public void applyTo(double[] object, T[] TArray) {
        double d2 = object[0];
        double d3 = object[1];
        double d4 = object[2];
        object = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q1.multiply(d2)).add(this.q2.multiply(d3))).add(this.q3.multiply(d4));
        TArray[0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)this.q0.multiply(d2)).subtract(((RealFieldElement)this.q2.multiply(d4)).subtract(this.q3.multiply(d3))))).add(object.multiply(this.q1))).multiply(2)).subtract(d2);
        TArray[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)this.q0.multiply(d3)).subtract(((RealFieldElement)this.q3.multiply(d2)).subtract(this.q1.multiply(d4))))).add(object.multiply(this.q2))).multiply(2)).subtract(d3);
        TArray[2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)this.q0.multiply(d4)).subtract(((RealFieldElement)this.q1.multiply(d3)).subtract(this.q2.multiply(d2))))).add(object.multiply(this.q3))).multiply(2)).subtract(d4);
    }

    public static <T extends RealFieldElement<T>> FieldVector3D<T> applyTo(Rotation rotation, FieldVector3D<T> fieldVector3D) {
        T t = fieldVector3D.getX();
        T t2 = fieldVector3D.getY();
        fieldVector3D = fieldVector3D.getZ();
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)t.multiply(rotation.getQ1())).add(t2.multiply(rotation.getQ2()))).add(fieldVector3D.multiply(rotation.getQ3()));
        return new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)t.multiply(rotation.getQ0())).subtract(((RealFieldElement)fieldVector3D.multiply(rotation.getQ2())).subtract(t2.multiply(rotation.getQ3())))).multiply(rotation.getQ0())).add(realFieldElement.multiply(rotation.getQ1()))).multiply(2)).subtract(t), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)t2.multiply(rotation.getQ0())).subtract(((RealFieldElement)t.multiply(rotation.getQ3())).subtract(fieldVector3D.multiply(rotation.getQ1())))).multiply(rotation.getQ0())).add(realFieldElement.multiply(rotation.getQ2()))).multiply(2)).subtract(t2), (RealFieldElement)((Object)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)fieldVector3D.multiply(rotation.getQ0())).subtract(((RealFieldElement)t2.multiply(rotation.getQ1())).subtract(t.multiply(rotation.getQ2())))).multiply(rotation.getQ0())).add(realFieldElement.multiply(rotation.getQ3()))).multiply(2)).subtract(fieldVector3D)));
    }

    public FieldVector3D<T> applyInverseTo(FieldVector3D<T> fieldVector3D) {
        RealFieldElement realFieldElement = fieldVector3D.getX();
        RealFieldElement realFieldElement2 = fieldVector3D.getY();
        fieldVector3D = fieldVector3D.getZ();
        RealFieldElement realFieldElement3 = (RealFieldElement)((Object)((RealFieldElement)((RealFieldElement)this.q1.multiply(realFieldElement)).add(this.q2.multiply(realFieldElement2))).add(this.q3.multiply(fieldVector3D)));
        RealFieldElement realFieldElement4 = (RealFieldElement)this.q0.negate();
        return new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement4.multiply(realFieldElement.multiply((RealFieldElement)realFieldElement4).subtract(((RealFieldElement)((Object)this.q2.multiply(fieldVector3D))).subtract(this.q3.multiply(realFieldElement2))))).add(realFieldElement3.multiply(this.q1))).multiply(2)).subtract(realFieldElement), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((Object)realFieldElement4.multiply(realFieldElement2.multiply((RealFieldElement)realFieldElement4).subtract(((RealFieldElement)this.q3.multiply(realFieldElement)).subtract(this.q1.multiply(fieldVector3D)))))).add(realFieldElement3.multiply(this.q2))).multiply(2)).subtract(realFieldElement2), (RealFieldElement)((Object)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement4.multiply(fieldVector3D.multiply(realFieldElement4).subtract(((RealFieldElement)this.q1.multiply(realFieldElement2)).subtract(this.q2.multiply(realFieldElement))))).add(realFieldElement3.multiply(this.q3))).multiply(2)).subtract(fieldVector3D)));
    }

    public FieldVector3D<T> applyInverseTo(Vector3D object) {
        RealFieldElement realFieldElement;
        double d2 = ((Vector3D)object).getX();
        double d3 = ((Vector3D)object).getY();
        double d4 = ((Vector3D)object).getZ();
        object = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q1.multiply(d2)).add(this.q2.multiply(d3))).add(this.q3.multiply(d4));
        RealFieldElement realFieldElement2 = realFieldElement = (RealFieldElement)this.q0.negate();
        RealFieldElement realFieldElement3 = realFieldElement;
        RealFieldElement realFieldElement4 = realFieldElement;
        return new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement2.multiply(((RealFieldElement)realFieldElement2.multiply(d2)).subtract(((RealFieldElement)this.q2.multiply(d4)).subtract(this.q3.multiply(d3))))).add(object.multiply(this.q1))).multiply(2)).subtract(d2), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement3.multiply(((RealFieldElement)realFieldElement3.multiply(d3)).subtract(((RealFieldElement)this.q3.multiply(d2)).subtract(this.q1.multiply(d4))))).add(object.multiply(this.q2))).multiply(2)).subtract(d3), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement4.multiply(((RealFieldElement)realFieldElement4.multiply(d4)).subtract(((RealFieldElement)this.q1.multiply(d3)).subtract(this.q2.multiply(d2))))).add(object.multiply(this.q3))).multiply(2)).subtract(d4));
    }

    public void applyInverseTo(T[] object, T[] TArray) {
        RealFieldElement realFieldElement = object[0];
        RealFieldElement realFieldElement2 = object[1];
        object = object[2];
        RealFieldElement realFieldElement3 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q1.multiply(realFieldElement)).add(this.q2.multiply(realFieldElement2))).add(this.q3.multiply(object));
        RealFieldElement realFieldElement4 = (RealFieldElement)this.q0.negate();
        TArray[0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement4.multiply(realFieldElement.multiply((RealFieldElement)realFieldElement4).subtract(((RealFieldElement)this.q2.multiply(object)).subtract(this.q3.multiply(realFieldElement2))))).add(realFieldElement3.multiply(this.q1))).multiply(2)).subtract(realFieldElement);
        TArray[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement4.multiply(realFieldElement2.multiply((RealFieldElement)realFieldElement4).subtract(((RealFieldElement)this.q3.multiply(realFieldElement)).subtract(this.q1.multiply(object))))).add(realFieldElement3.multiply(this.q2))).multiply(2)).subtract(realFieldElement2);
        TArray[2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement4.multiply(object.multiply(realFieldElement4).subtract(((RealFieldElement)this.q1.multiply(realFieldElement2)).subtract(this.q2.multiply(realFieldElement))))).add(realFieldElement3.multiply(this.q3))).multiply(2)).subtract(object);
    }

    public void applyInverseTo(double[] object, T[] TArray) {
        RealFieldElement realFieldElement;
        double d2 = object[0];
        double d3 = object[1];
        double d4 = object[2];
        object = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q1.multiply(d2)).add(this.q2.multiply(d3))).add(this.q3.multiply(d4));
        RealFieldElement realFieldElement2 = realFieldElement = (RealFieldElement)this.q0.negate();
        TArray[0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement2.multiply(((RealFieldElement)realFieldElement2.multiply(d2)).subtract(((RealFieldElement)this.q2.multiply(d4)).subtract(this.q3.multiply(d3))))).add(object.multiply(this.q1))).multiply(2)).subtract(d2);
        RealFieldElement realFieldElement3 = realFieldElement;
        TArray[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement3.multiply(((RealFieldElement)realFieldElement3.multiply(d3)).subtract(((RealFieldElement)this.q3.multiply(d2)).subtract(this.q1.multiply(d4))))).add(object.multiply(this.q2))).multiply(2)).subtract(d3);
        RealFieldElement realFieldElement4 = realFieldElement;
        TArray[2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement4.multiply(((RealFieldElement)realFieldElement4.multiply(d4)).subtract(((RealFieldElement)this.q1.multiply(d3)).subtract(this.q2.multiply(d2))))).add(object.multiply(this.q3))).multiply(2)).subtract(d4);
    }

    public static <T extends RealFieldElement<T>> FieldVector3D<T> applyInverseTo(Rotation rotation, FieldVector3D<T> fieldVector3D) {
        T t = fieldVector3D.getX();
        T t2 = fieldVector3D.getY();
        fieldVector3D = fieldVector3D.getZ();
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)t.multiply(rotation.getQ1())).add(t2.multiply(rotation.getQ2()))).add(fieldVector3D.multiply(rotation.getQ3()));
        double d2 = -rotation.getQ0();
        return new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)t.multiply(d2)).subtract(((RealFieldElement)fieldVector3D.multiply(rotation.getQ2())).subtract(t2.multiply(rotation.getQ3())))).multiply(d2)).add(realFieldElement.multiply(rotation.getQ1()))).multiply(2)).subtract(t), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)t2.multiply(d2)).subtract(((RealFieldElement)t.multiply(rotation.getQ3())).subtract(fieldVector3D.multiply(rotation.getQ1())))).multiply(d2)).add(realFieldElement.multiply(rotation.getQ2()))).multiply(2)).subtract(t2), (RealFieldElement)((Object)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)fieldVector3D.multiply(d2)).subtract(((RealFieldElement)t2.multiply(rotation.getQ1())).subtract(t.multiply(rotation.getQ2())))).multiply(d2)).add(realFieldElement.multiply(rotation.getQ3()))).multiply(2)).subtract(fieldVector3D)));
    }

    public FieldRotation<T> applyTo(FieldRotation<T> fieldRotation) {
        return this.compose(fieldRotation, RotationConvention.VECTOR_OPERATOR);
    }

    public FieldRotation<T> compose(FieldRotation<T> fieldRotation, RotationConvention rotationConvention) {
        if (rotationConvention == RotationConvention.VECTOR_OPERATOR) {
            return this.composeInternal(fieldRotation);
        }
        return super.composeInternal(this);
    }

    private FieldRotation<T> composeInternal(FieldRotation<T> fieldRotation) {
        return new FieldRotation<RealFieldElement>((RealFieldElement)((RealFieldElement)fieldRotation.q0.multiply(this.q0)).subtract(((RealFieldElement)((RealFieldElement)fieldRotation.q1.multiply(this.q1)).add(fieldRotation.q2.multiply(this.q2))).add(fieldRotation.q3.multiply(this.q3))), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q1.multiply(this.q0)).add(fieldRotation.q0.multiply(this.q1))).add(((RealFieldElement)fieldRotation.q2.multiply(this.q3)).subtract(fieldRotation.q3.multiply(this.q2))), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q2.multiply(this.q0)).add(fieldRotation.q0.multiply(this.q2))).add(((RealFieldElement)fieldRotation.q3.multiply(this.q1)).subtract(fieldRotation.q1.multiply(this.q3))), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q3.multiply(this.q0)).add(fieldRotation.q0.multiply(this.q3))).add(((RealFieldElement)fieldRotation.q1.multiply(this.q2)).subtract(fieldRotation.q2.multiply(this.q1))), false);
    }

    public FieldRotation<T> applyTo(Rotation rotation) {
        return this.compose(rotation, RotationConvention.VECTOR_OPERATOR);
    }

    public FieldRotation<T> compose(Rotation rotation, RotationConvention rotationConvention) {
        if (rotationConvention == RotationConvention.VECTOR_OPERATOR) {
            return this.composeInternal(rotation);
        }
        return FieldRotation.applyTo(rotation, this);
    }

    private FieldRotation<T> composeInternal(Rotation rotation) {
        return new FieldRotation<RealFieldElement>((RealFieldElement)((RealFieldElement)this.q0.multiply(rotation.getQ0())).subtract(((RealFieldElement)((RealFieldElement)this.q1.multiply(rotation.getQ1())).add(this.q2.multiply(rotation.getQ2()))).add(this.q3.multiply(rotation.getQ3()))), (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(rotation.getQ1())).add(this.q1.multiply(rotation.getQ0()))).add(((RealFieldElement)this.q3.multiply(rotation.getQ2())).subtract(this.q2.multiply(rotation.getQ3()))), (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(rotation.getQ2())).add(this.q2.multiply(rotation.getQ0()))).add(((RealFieldElement)this.q1.multiply(rotation.getQ3())).subtract(this.q3.multiply(rotation.getQ1()))), (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(rotation.getQ3())).add(this.q3.multiply(rotation.getQ0()))).add(((RealFieldElement)this.q2.multiply(rotation.getQ1())).subtract(this.q1.multiply(rotation.getQ2()))), false);
    }

    public static <T extends RealFieldElement<T>> FieldRotation<T> applyTo(Rotation rotation, FieldRotation<T> fieldRotation) {
        return new FieldRotation<RealFieldElement>((RealFieldElement)((RealFieldElement)fieldRotation.q0.multiply(rotation.getQ0())).subtract(((RealFieldElement)((RealFieldElement)fieldRotation.q1.multiply(rotation.getQ1())).add(fieldRotation.q2.multiply(rotation.getQ2()))).add(fieldRotation.q3.multiply(rotation.getQ3()))), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q1.multiply(rotation.getQ0())).add(fieldRotation.q0.multiply(rotation.getQ1()))).add(((RealFieldElement)fieldRotation.q2.multiply(rotation.getQ3())).subtract(fieldRotation.q3.multiply(rotation.getQ2()))), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q2.multiply(rotation.getQ0())).add(fieldRotation.q0.multiply(rotation.getQ2()))).add(((RealFieldElement)fieldRotation.q3.multiply(rotation.getQ1())).subtract(fieldRotation.q1.multiply(rotation.getQ3()))), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q3.multiply(rotation.getQ0())).add(fieldRotation.q0.multiply(rotation.getQ3()))).add(((RealFieldElement)fieldRotation.q1.multiply(rotation.getQ2())).subtract(fieldRotation.q2.multiply(rotation.getQ1()))), false);
    }

    public FieldRotation<T> applyInverseTo(FieldRotation<T> fieldRotation) {
        return this.composeInverse(fieldRotation, RotationConvention.VECTOR_OPERATOR);
    }

    public FieldRotation<T> composeInverse(FieldRotation<T> fieldRotation, RotationConvention rotationConvention) {
        if (rotationConvention == RotationConvention.VECTOR_OPERATOR) {
            return this.composeInverseInternal(fieldRotation);
        }
        return super.composeInternal(this.revert());
    }

    private FieldRotation<T> composeInverseInternal(FieldRotation<T> fieldRotation) {
        return new FieldRotation<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q0.multiply(this.q0)).add(((RealFieldElement)((RealFieldElement)fieldRotation.q1.multiply(this.q1)).add(fieldRotation.q2.multiply(this.q2))).add(fieldRotation.q3.multiply(this.q3)))).negate(), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q0.multiply(this.q1)).add(((RealFieldElement)fieldRotation.q2.multiply(this.q3)).subtract(fieldRotation.q3.multiply(this.q2)))).subtract(fieldRotation.q1.multiply(this.q0)), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q0.multiply(this.q2)).add(((RealFieldElement)fieldRotation.q3.multiply(this.q1)).subtract(fieldRotation.q1.multiply(this.q3)))).subtract(fieldRotation.q2.multiply(this.q0)), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q0.multiply(this.q3)).add(((RealFieldElement)fieldRotation.q1.multiply(this.q2)).subtract(fieldRotation.q2.multiply(this.q1)))).subtract(fieldRotation.q3.multiply(this.q0)), false);
    }

    public FieldRotation<T> applyInverseTo(Rotation rotation) {
        return this.composeInverse(rotation, RotationConvention.VECTOR_OPERATOR);
    }

    public FieldRotation<T> composeInverse(Rotation rotation, RotationConvention rotationConvention) {
        if (rotationConvention == RotationConvention.VECTOR_OPERATOR) {
            return this.composeInverseInternal(rotation);
        }
        return FieldRotation.applyTo(rotation, this.revert());
    }

    private FieldRotation<T> composeInverseInternal(Rotation rotation) {
        return new FieldRotation<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(rotation.getQ0())).add(((RealFieldElement)((RealFieldElement)this.q1.multiply(rotation.getQ1())).add(this.q2.multiply(rotation.getQ2()))).add(this.q3.multiply(rotation.getQ3())))).negate(), (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q1.multiply(rotation.getQ0())).add(((RealFieldElement)this.q3.multiply(rotation.getQ2())).subtract(this.q2.multiply(rotation.getQ3())))).subtract(this.q0.multiply(rotation.getQ1())), (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q2.multiply(rotation.getQ0())).add(((RealFieldElement)this.q1.multiply(rotation.getQ3())).subtract(this.q3.multiply(rotation.getQ1())))).subtract(this.q0.multiply(rotation.getQ2())), (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q3.multiply(rotation.getQ0())).add(((RealFieldElement)this.q2.multiply(rotation.getQ1())).subtract(this.q1.multiply(rotation.getQ2())))).subtract(this.q0.multiply(rotation.getQ3())), false);
    }

    public static <T extends RealFieldElement<T>> FieldRotation<T> applyInverseTo(Rotation rotation, FieldRotation<T> fieldRotation) {
        return new FieldRotation<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q0.multiply(rotation.getQ0())).add(((RealFieldElement)((RealFieldElement)fieldRotation.q1.multiply(rotation.getQ1())).add(fieldRotation.q2.multiply(rotation.getQ2()))).add(fieldRotation.q3.multiply(rotation.getQ3())))).negate(), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q0.multiply(rotation.getQ1())).add(((RealFieldElement)fieldRotation.q2.multiply(rotation.getQ3())).subtract(fieldRotation.q3.multiply(rotation.getQ2())))).subtract(fieldRotation.q1.multiply(rotation.getQ0())), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q0.multiply(rotation.getQ2())).add(((RealFieldElement)fieldRotation.q3.multiply(rotation.getQ1())).subtract(fieldRotation.q1.multiply(rotation.getQ3())))).subtract(fieldRotation.q2.multiply(rotation.getQ0())), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q0.multiply(rotation.getQ3())).add(((RealFieldElement)fieldRotation.q1.multiply(rotation.getQ2())).subtract(fieldRotation.q2.multiply(rotation.getQ1())))).subtract(fieldRotation.q3.multiply(rotation.getQ0())), false);
    }

    private T[][] orthogonalizeMatrix(T[][] TArray, double d2) {
        RealFieldElement realFieldElement = TArray[0][0];
        RealFieldElement realFieldElement2 = TArray[0][1];
        RealFieldElement realFieldElement3 = TArray[0][2];
        RealFieldElement realFieldElement4 = TArray[1][0];
        RealFieldElement realFieldElement5 = TArray[1][1];
        RealFieldElement realFieldElement6 = TArray[1][2];
        RealFieldElement realFieldElement7 = TArray[2][0];
        RealFieldElement realFieldElement8 = TArray[2][1];
        RealFieldElement realFieldElement9 = TArray[2][2];
        double d3 = 0.0;
        RealFieldElement[][] realFieldElementArray = (RealFieldElement[][])MathArrays.buildArray(TArray[0][0].getField(), 3, 3);
        int n = 0;
        while (++n < 11) {
            double d4;
            RealFieldElement realFieldElement10 = (RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][0].multiply(realFieldElement)).add(TArray[1][0].multiply(realFieldElement4))).add(TArray[2][0].multiply(realFieldElement7));
            RealFieldElement realFieldElement11 = (RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][1].multiply(realFieldElement)).add(TArray[1][1].multiply(realFieldElement4))).add(TArray[2][1].multiply(realFieldElement7));
            RealFieldElement realFieldElement12 = (RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][2].multiply(realFieldElement)).add(TArray[1][2].multiply(realFieldElement4))).add(TArray[2][2].multiply(realFieldElement7));
            RealFieldElement realFieldElement13 = (RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][0].multiply(realFieldElement2)).add(TArray[1][0].multiply(realFieldElement5))).add(TArray[2][0].multiply(realFieldElement8));
            RealFieldElement realFieldElement14 = (RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][1].multiply(realFieldElement2)).add(TArray[1][1].multiply(realFieldElement5))).add(TArray[2][1].multiply(realFieldElement8));
            RealFieldElement realFieldElement15 = (RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][2].multiply(realFieldElement2)).add(TArray[1][2].multiply(realFieldElement5))).add(TArray[2][2].multiply(realFieldElement8));
            RealFieldElement realFieldElement16 = (RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][0].multiply(realFieldElement3)).add(TArray[1][0].multiply(realFieldElement6))).add(TArray[2][0].multiply(realFieldElement9));
            RealFieldElement realFieldElement17 = (RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][1].multiply(realFieldElement3)).add(TArray[1][1].multiply(realFieldElement6))).add(TArray[2][1].multiply(realFieldElement9));
            RealFieldElement realFieldElement18 = (RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][2].multiply(realFieldElement3)).add(TArray[1][2].multiply(realFieldElement6))).add(TArray[2][2].multiply(realFieldElement9));
            RealFieldElement realFieldElement19 = realFieldElement;
            realFieldElementArray[0][0] = (RealFieldElement)realFieldElement19.subtract(((RealFieldElement)realFieldElement19.multiply((RealFieldElement)realFieldElement10).add(realFieldElement2.multiply((RealFieldElement)realFieldElement11)).add(realFieldElement3.multiply((RealFieldElement)realFieldElement12)).subtract(TArray[0][0])).multiply(0.5));
            realFieldElementArray[0][1] = (RealFieldElement)realFieldElement2.subtract(((RealFieldElement)realFieldElement.multiply((RealFieldElement)realFieldElement13).add(realFieldElement2.multiply((RealFieldElement)realFieldElement14)).add(realFieldElement3.multiply((RealFieldElement)realFieldElement15)).subtract(TArray[0][1])).multiply(0.5));
            realFieldElementArray[0][2] = (RealFieldElement)realFieldElement3.subtract(((RealFieldElement)realFieldElement.multiply((RealFieldElement)realFieldElement16).add(realFieldElement2.multiply((RealFieldElement)realFieldElement17)).add(realFieldElement3.multiply((RealFieldElement)realFieldElement18)).subtract(TArray[0][2])).multiply(0.5));
            RealFieldElement realFieldElement20 = realFieldElement4;
            realFieldElementArray[1][0] = (RealFieldElement)realFieldElement20.subtract(((RealFieldElement)realFieldElement20.multiply((RealFieldElement)realFieldElement10).add(realFieldElement5.multiply((RealFieldElement)realFieldElement11)).add(realFieldElement6.multiply((RealFieldElement)realFieldElement12)).subtract(TArray[1][0])).multiply(0.5));
            realFieldElementArray[1][1] = (RealFieldElement)realFieldElement5.subtract(((RealFieldElement)realFieldElement4.multiply((RealFieldElement)realFieldElement13).add(realFieldElement5.multiply((RealFieldElement)realFieldElement14)).add(realFieldElement6.multiply((RealFieldElement)realFieldElement15)).subtract(TArray[1][1])).multiply(0.5));
            realFieldElementArray[1][2] = (RealFieldElement)realFieldElement6.subtract(((RealFieldElement)realFieldElement4.multiply((RealFieldElement)realFieldElement16).add(realFieldElement5.multiply((RealFieldElement)realFieldElement17)).add(realFieldElement6.multiply((RealFieldElement)realFieldElement18)).subtract(TArray[1][2])).multiply(0.5));
            RealFieldElement realFieldElement21 = realFieldElement7;
            realFieldElementArray[2][0] = (RealFieldElement)realFieldElement21.subtract(((RealFieldElement)realFieldElement21.multiply((RealFieldElement)realFieldElement10).add(realFieldElement8.multiply((RealFieldElement)realFieldElement11)).add(realFieldElement9.multiply((RealFieldElement)realFieldElement12)).subtract(TArray[2][0])).multiply(0.5));
            realFieldElementArray[2][1] = (RealFieldElement)realFieldElement8.subtract(((RealFieldElement)realFieldElement7.multiply((RealFieldElement)realFieldElement13).add(realFieldElement8.multiply((RealFieldElement)realFieldElement14)).add(realFieldElement9.multiply((RealFieldElement)realFieldElement15)).subtract(TArray[2][1])).multiply(0.5));
            realFieldElementArray[2][2] = (RealFieldElement)realFieldElement9.subtract(((RealFieldElement)realFieldElement7.multiply((RealFieldElement)realFieldElement16).add(realFieldElement8.multiply((RealFieldElement)realFieldElement17)).add(realFieldElement9.multiply((RealFieldElement)realFieldElement18)).subtract(TArray[2][2])).multiply(0.5));
            double d5 = realFieldElementArray[0][0].getReal() - TArray[0][0].getReal();
            double d6 = realFieldElementArray[0][1].getReal() - TArray[0][1].getReal();
            double d7 = realFieldElementArray[0][2].getReal() - TArray[0][2].getReal();
            double d8 = realFieldElementArray[1][0].getReal() - TArray[1][0].getReal();
            double d9 = realFieldElementArray[1][1].getReal() - TArray[1][1].getReal();
            double d10 = realFieldElementArray[1][2].getReal() - TArray[1][2].getReal();
            double d11 = realFieldElementArray[2][0].getReal() - TArray[2][0].getReal();
            double d12 = realFieldElementArray[2][1].getReal() - TArray[2][1].getReal();
            double d13 = realFieldElementArray[2][2].getReal() - TArray[2][2].getReal();
            double d14 = d5;
            double d15 = d6;
            double d16 = d7;
            double d17 = d8;
            double d18 = d9;
            double d19 = d10;
            double d20 = d11;
            double d21 = d12;
            double d22 = d13;
            double d23 = d14 * d14 + d15 * d15 + d16 * d16 + d17 * d17 + d18 * d18 + d19 * d19 + d20 * d20 + d21 * d21 + d22 * d22;
            if (FastMath.abs(d4 - d3) <= d2) {
                return realFieldElementArray;
            }
            realFieldElement = realFieldElementArray[0][0];
            realFieldElement2 = realFieldElementArray[0][1];
            realFieldElement3 = realFieldElementArray[0][2];
            realFieldElement4 = realFieldElementArray[1][0];
            realFieldElement5 = realFieldElementArray[1][1];
            realFieldElement6 = realFieldElementArray[1][2];
            realFieldElement7 = realFieldElementArray[2][0];
            realFieldElement8 = realFieldElementArray[2][1];
            realFieldElement9 = realFieldElementArray[2][2];
            d3 = d23;
        }
        throw new NotARotationMatrixException(LocalizedFormats.UNABLE_TO_ORTHOGONOLIZE_MATRIX, n - 1);
    }

    public static <T extends RealFieldElement<T>> T distance(FieldRotation<T> fieldRotation, FieldRotation<T> fieldRotation2) {
        return super.composeInverseInternal(fieldRotation2).getAngle();
    }
}

