/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathArithmeticException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Space;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Vector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Euclidean1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Vector1DFormat;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.text.NumberFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vector1D
implements Vector<Euclidean1D> {
    public static final Vector1D ZERO = new Vector1D(0.0);
    public static final Vector1D ONE = new Vector1D(1.0);
    public static final Vector1D NaN = new Vector1D(Double.NaN);
    public static final Vector1D POSITIVE_INFINITY = new Vector1D(Double.POSITIVE_INFINITY);
    public static final Vector1D NEGATIVE_INFINITY = new Vector1D(Double.NEGATIVE_INFINITY);
    private static final long serialVersionUID = 7556674948671647925L;
    private final double x;

    public Vector1D(double d2) {
        this.x = d2;
    }

    public Vector1D(double d2, Vector1D vector1D) {
        this.x = d2 * vector1D.x;
    }

    public Vector1D(double d2, Vector1D vector1D, double d3, Vector1D vector1D2) {
        this.x = d2 * vector1D.x + d3 * vector1D2.x;
    }

    public Vector1D(double d2, Vector1D vector1D, double d3, Vector1D vector1D2, double d4, Vector1D vector1D3) {
        this.x = d2 * vector1D.x + d3 * vector1D2.x + d4 * vector1D3.x;
    }

    public Vector1D(double d2, Vector1D vector1D, double d3, Vector1D vector1D2, double d4, Vector1D vector1D3, double d5, Vector1D vector1D4) {
        this.x = d2 * vector1D.x + d3 * vector1D2.x + d4 * vector1D3.x + d5 * vector1D4.x;
    }

    public double getX() {
        return this.x;
    }

    @Override
    public Space getSpace() {
        return Euclidean1D.getInstance();
    }

    public Vector1D getZero() {
        return ZERO;
    }

    @Override
    public double getNorm1() {
        return FastMath.abs(this.x);
    }

    @Override
    public double getNorm() {
        return FastMath.abs(this.x);
    }

    @Override
    public double getNormSq() {
        return this.x * this.x;
    }

    @Override
    public double getNormInf() {
        return FastMath.abs(this.x);
    }

    public Vector1D add(Vector<Euclidean1D> vector1D) {
        vector1D = vector1D;
        return new Vector1D(this.x + vector1D.getX());
    }

    public Vector1D add(double d2, Vector<Euclidean1D> vector1D) {
        vector1D = vector1D;
        return new Vector1D(this.x + d2 * vector1D.getX());
    }

    public Vector1D subtract(Vector<Euclidean1D> vector1D) {
        vector1D = vector1D;
        return new Vector1D(this.x - vector1D.x);
    }

    public Vector1D subtract(double d2, Vector<Euclidean1D> vector1D) {
        vector1D = vector1D;
        return new Vector1D(this.x - d2 * vector1D.getX());
    }

    public Vector1D normalize() {
        double d2 = this.getNorm();
        if (d2 == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.CANNOT_NORMALIZE_A_ZERO_NORM_VECTOR, new Object[0]);
        }
        return this.scalarMultiply(1.0 / d2);
    }

    public Vector1D negate() {
        return new Vector1D(-this.x);
    }

    public Vector1D scalarMultiply(double d2) {
        return new Vector1D(d2 * this.x);
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.x);
    }

    @Override
    public boolean isInfinite() {
        return !this.isNaN() && Double.isInfinite(this.x);
    }

    @Override
    public double distance1(Vector<Euclidean1D> vector1D) {
        vector1D = vector1D;
        double d2 = FastMath.abs(vector1D.x - this.x);
        return d2;
    }

    @Override
    @Deprecated
    public double distance(Vector<Euclidean1D> vector) {
        return this.distance((Point<Euclidean1D>)vector);
    }

    @Override
    public double distance(Point<Euclidean1D> vector1D) {
        vector1D = vector1D;
        double d2 = vector1D.x - this.x;
        return FastMath.abs(d2);
    }

    @Override
    public double distanceInf(Vector<Euclidean1D> vector1D) {
        vector1D = vector1D;
        double d2 = FastMath.abs(vector1D.x - this.x);
        return d2;
    }

    @Override
    public double distanceSq(Vector<Euclidean1D> vector1D) {
        vector1D = vector1D;
        double d2 = vector1D.x - this.x;
        return d2 * d2;
    }

    @Override
    public double dotProduct(Vector<Euclidean1D> vector1D) {
        vector1D = vector1D;
        return this.x * vector1D.x;
    }

    public static double distance(Vector1D vector1D, Vector1D vector1D2) {
        return vector1D.distance(vector1D2);
    }

    public static double distanceInf(Vector1D vector1D, Vector1D vector1D2) {
        return vector1D.distanceInf(vector1D2);
    }

    public static double distanceSq(Vector1D vector1D, Vector1D vector1D2) {
        return vector1D.distanceSq(vector1D2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Vector1D) {
            if (((Vector1D)(object = (Vector1D)object)).isNaN()) {
                return this.isNaN();
            }
            return this.x == ((Vector1D)object).x;
        }
        return false;
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 7785;
        }
        return 997 * MathUtils.hash(this.x);
    }

    public String toString() {
        return Vector1DFormat.getInstance().format(this);
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        return new Vector1DFormat(numberFormat).format(this);
    }
}

