/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Vector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Euclidean1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.IntervalsSet;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.SubOrientedPoint;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Hyperplane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrientedPoint
implements Hyperplane<Euclidean1D> {
    private static final double DEFAULT_TOLERANCE = 1.0E-10;
    private Vector1D location;
    private boolean direct;
    private final double tolerance;

    public OrientedPoint(Vector1D vector1D, boolean bl, double d2) {
        this.location = vector1D;
        this.direct = bl;
        this.tolerance = d2;
    }

    @Deprecated
    public OrientedPoint(Vector1D vector1D, boolean bl) {
        this(vector1D, bl, 1.0E-10);
    }

    public OrientedPoint copySelf() {
        return this;
    }

    @Override
    public double getOffset(Vector<Euclidean1D> vector) {
        return this.getOffset((Point<Euclidean1D>)vector);
    }

    @Override
    public double getOffset(Point<Euclidean1D> point) {
        double d2 = ((Vector1D)point).getX() - this.location.getX();
        if (this.direct) {
            return d2;
        }
        return -d2;
    }

    public SubOrientedPoint wholeHyperplane() {
        return new SubOrientedPoint(this, null);
    }

    public IntervalsSet wholeSpace() {
        return new IntervalsSet(this.tolerance);
    }

    @Override
    public boolean sameOrientationAs(Hyperplane<Euclidean1D> hyperplane) {
        return !(this.direct ^ ((OrientedPoint)hyperplane).direct);
    }

    @Override
    public Point<Euclidean1D> project(Point<Euclidean1D> point) {
        return this.location;
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    public Vector1D getLocation() {
        return this.location;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public void revertSelf() {
        this.direct = !this.direct;
    }
}

