/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Euclidean1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Interval;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.IntervalsSet$SubIntervalsIterator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.OrientedPoint;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.SubOrientedPoint;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.AbstractRegion;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BSPTree;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.BoundaryProjection;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.SubHyperplane;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntervalsSet
extends AbstractRegion<Euclidean1D, Euclidean1D>
implements Iterable<double[]> {
    private static final double DEFAULT_TOLERANCE = 1.0E-10;

    public IntervalsSet(double d2) {
        super(d2);
    }

    public IntervalsSet(double d2, double d3, double d4) {
        super(IntervalsSet.buildTree(d2, d3, d4), d4);
    }

    public IntervalsSet(BSPTree<Euclidean1D> bSPTree, double d2) {
        super(bSPTree, d2);
    }

    public IntervalsSet(Collection<SubHyperplane<Euclidean1D>> collection, double d2) {
        super(collection, d2);
    }

    @Deprecated
    public IntervalsSet() {
        this(1.0E-10);
    }

    @Deprecated
    public IntervalsSet(double d2, double d3) {
        this(d2, d3, 1.0E-10);
    }

    @Deprecated
    public IntervalsSet(BSPTree<Euclidean1D> bSPTree) {
        this(bSPTree, 1.0E-10);
    }

    @Deprecated
    public IntervalsSet(Collection<SubHyperplane<Euclidean1D>> collection) {
        this(collection, 1.0E-10);
    }

    private static BSPTree<Euclidean1D> buildTree(double d2, double d3, double d4) {
        if (Double.isInfinite(d2) && d2 < 0.0) {
            if (Double.isInfinite(d3) && d3 > 0.0) {
                return new BSPTree<Euclidean1D>(Boolean.TRUE);
            }
            SubOrientedPoint subOrientedPoint = new OrientedPoint(new Vector1D(d3), true, d4).wholeHyperplane();
            return new BSPTree<Euclidean1D>(subOrientedPoint, new BSPTree(Boolean.FALSE), new BSPTree(Boolean.TRUE), null);
        }
        SubOrientedPoint subOrientedPoint = new OrientedPoint(new Vector1D(d2), false, d4).wholeHyperplane();
        if (Double.isInfinite(d3) && d3 > 0.0) {
            return new BSPTree<Euclidean1D>(subOrientedPoint, new BSPTree(Boolean.FALSE), new BSPTree(Boolean.TRUE), null);
        }
        SubOrientedPoint subOrientedPoint2 = new OrientedPoint(new Vector1D(d3), true, d4).wholeHyperplane();
        return new BSPTree<Euclidean1D>(subOrientedPoint, new BSPTree(Boolean.FALSE), new BSPTree<Euclidean1D>(subOrientedPoint2, new BSPTree(Boolean.FALSE), new BSPTree(Boolean.TRUE), null), null);
    }

    public IntervalsSet buildNew(BSPTree<Euclidean1D> bSPTree) {
        return new IntervalsSet(bSPTree, this.getTolerance());
    }

    @Override
    protected void computeGeometricalProperties() {
        if (this.getTree(false).getCut() == null) {
            this.setBarycenter(Vector1D.NaN);
            IntervalsSet intervalsSet = this;
            intervalsSet.setSize((Boolean)intervalsSet.getTree(false).getAttribute() != false ? Double.POSITIVE_INFINITY : 0.0);
            return;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        for (Interval interval : this.asList()) {
            d2 += interval.getSize();
            d3 += interval.getSize() * interval.getBarycenter();
        }
        this.setSize(d2);
        if (Double.isInfinite(d2)) {
            this.setBarycenter(Vector1D.NaN);
            return;
        }
        if (d2 >= Precision.SAFE_MIN) {
            this.setBarycenter(new Vector1D(d3 / d2));
            return;
        }
        IntervalsSet intervalsSet = this;
        intervalsSet.setBarycenter(((OrientedPoint)intervalsSet.getTree(false).getCut().getHyperplane()).getLocation());
    }

    public double getInf() {
        BSPTree bSPTree = this.getTree(false);
        double d2 = Double.POSITIVE_INFINITY;
        while (bSPTree.getCut() != null) {
            OrientedPoint orientedPoint = (OrientedPoint)bSPTree.getCut().getHyperplane();
            d2 = orientedPoint.getLocation().getX();
            bSPTree = orientedPoint.isDirect() ? bSPTree.getMinus() : bSPTree.getPlus();
        }
        if (((Boolean)bSPTree.getAttribute()).booleanValue()) {
            return Double.NEGATIVE_INFINITY;
        }
        return d2;
    }

    public double getSup() {
        BSPTree bSPTree = this.getTree(false);
        double d2 = Double.NEGATIVE_INFINITY;
        while (bSPTree.getCut() != null) {
            OrientedPoint orientedPoint = (OrientedPoint)bSPTree.getCut().getHyperplane();
            d2 = orientedPoint.getLocation().getX();
            bSPTree = orientedPoint.isDirect() ? bSPTree.getPlus() : bSPTree.getMinus();
        }
        if (((Boolean)bSPTree.getAttribute()).booleanValue()) {
            return Double.POSITIVE_INFINITY;
        }
        return d2;
    }

    @Override
    public BoundaryProjection<Euclidean1D> projectToBoundary(Point<Euclidean1D> point) {
        double d2 = ((Vector1D)point).getX();
        double d3 = Double.NEGATIVE_INFINITY;
        for (double[] dArray : this) {
            if (d2 < dArray[0]) {
                double d4 = d2 - d3;
                double d5 = dArray[0] - d2;
                if (d4 < d5) {
                    return new BoundaryProjection<Euclidean1D>(point, this.finiteOrNullPoint(d3), d4);
                }
                return new BoundaryProjection<Euclidean1D>(point, this.finiteOrNullPoint(dArray[0]), d5);
            }
            if (d2 <= dArray[1]) {
                double d6 = dArray[0] - d2;
                double d7 = d2 - dArray[1];
                if (d6 < d7) {
                    return new BoundaryProjection<Euclidean1D>(point, this.finiteOrNullPoint(dArray[1]), d7);
                }
                return new BoundaryProjection<Euclidean1D>(point, this.finiteOrNullPoint(dArray[0]), d6);
            }
            d3 = dArray[1];
        }
        return new BoundaryProjection<Euclidean1D>(point, this.finiteOrNullPoint(d3), d2 - d3);
    }

    private Vector1D finiteOrNullPoint(double d2) {
        if (Double.isInfinite(d2)) {
            return null;
        }
        return new Vector1D(d2);
    }

    public List<Interval> asList() {
        ArrayList<Interval> arrayList = new ArrayList<Interval>();
        for (double[] dArray : this) {
            arrayList.add(new Interval(dArray[0], dArray[1]));
        }
        return arrayList;
    }

    private BSPTree<Euclidean1D> getFirstLeaf(BSPTree<Euclidean1D> bSPTree) {
        if (bSPTree.getCut() == null) {
            return bSPTree;
        }
        BSPTree<Euclidean1D> bSPTree2 = null;
        while (bSPTree != null) {
            bSPTree2 = bSPTree;
            bSPTree = this.previousInternalNode(bSPTree);
        }
        return this.leafBefore(bSPTree2);
    }

    private BSPTree<Euclidean1D> getFirstIntervalBoundary() {
        BSPTree<Euclidean1D> bSPTree = this.getTree(false);
        if (bSPTree.getCut() == null) {
            return null;
        }
        bSPTree = this.getFirstLeaf(bSPTree).getParent();
        while (bSPTree != null && !this.isIntervalStart(bSPTree) && !this.isIntervalEnd(bSPTree)) {
            bSPTree = this.nextInternalNode(bSPTree);
        }
        return bSPTree;
    }

    private boolean isIntervalStart(BSPTree<Euclidean1D> bSPTree) {
        if (((Boolean)this.leafBefore(bSPTree).getAttribute()).booleanValue()) {
            return false;
        }
        return (Boolean)this.leafAfter(bSPTree).getAttribute() != false;
    }

    private boolean isIntervalEnd(BSPTree<Euclidean1D> bSPTree) {
        if (!((Boolean)this.leafBefore(bSPTree).getAttribute()).booleanValue()) {
            return false;
        }
        return (Boolean)this.leafAfter(bSPTree).getAttribute() == false;
    }

    private BSPTree<Euclidean1D> nextInternalNode(BSPTree<Euclidean1D> bSPTree) {
        if (this.childAfter(bSPTree).getCut() != null) {
            return this.leafAfter(bSPTree).getParent();
        }
        while (this.isAfterParent(bSPTree)) {
            bSPTree = bSPTree.getParent();
        }
        return bSPTree.getParent();
    }

    private BSPTree<Euclidean1D> previousInternalNode(BSPTree<Euclidean1D> bSPTree) {
        if (this.childBefore(bSPTree).getCut() != null) {
            return this.leafBefore(bSPTree).getParent();
        }
        while (this.isBeforeParent(bSPTree)) {
            bSPTree = bSPTree.getParent();
        }
        return bSPTree.getParent();
    }

    private BSPTree<Euclidean1D> leafBefore(BSPTree<Euclidean1D> bSPTree) {
        bSPTree = this.childBefore(bSPTree);
        while (bSPTree.getCut() != null) {
            bSPTree = this.childAfter(bSPTree);
        }
        return bSPTree;
    }

    private BSPTree<Euclidean1D> leafAfter(BSPTree<Euclidean1D> bSPTree) {
        bSPTree = this.childAfter(bSPTree);
        while (bSPTree.getCut() != null) {
            bSPTree = this.childBefore(bSPTree);
        }
        return bSPTree;
    }

    private boolean isBeforeParent(BSPTree<Euclidean1D> bSPTree) {
        BSPTree<Euclidean1D> bSPTree2 = bSPTree.getParent();
        if (bSPTree2 == null) {
            return false;
        }
        return bSPTree == this.childBefore(bSPTree2);
    }

    private boolean isAfterParent(BSPTree<Euclidean1D> bSPTree) {
        BSPTree<Euclidean1D> bSPTree2 = bSPTree.getParent();
        if (bSPTree2 == null) {
            return false;
        }
        return bSPTree == this.childAfter(bSPTree2);
    }

    private BSPTree<Euclidean1D> childBefore(BSPTree<Euclidean1D> bSPTree) {
        if (this.isDirect(bSPTree)) {
            return bSPTree.getMinus();
        }
        return bSPTree.getPlus();
    }

    private BSPTree<Euclidean1D> childAfter(BSPTree<Euclidean1D> bSPTree) {
        if (this.isDirect(bSPTree)) {
            return bSPTree.getPlus();
        }
        return bSPTree.getMinus();
    }

    private boolean isDirect(BSPTree<Euclidean1D> bSPTree) {
        return ((OrientedPoint)bSPTree.getCut().getHyperplane()).isDirect();
    }

    private double getAngle(BSPTree<Euclidean1D> bSPTree) {
        return ((OrientedPoint)bSPTree.getCut().getHyperplane()).getLocation().getX();
    }

    @Override
    public Iterator<double[]> iterator() {
        return new IntervalsSet$SubIntervalsIterator(this);
    }

    static /* synthetic */ BSPTree access$000(IntervalsSet intervalsSet) {
        return intervalsSet.getFirstIntervalBoundary();
    }

    static /* synthetic */ BSPTree access$100(IntervalsSet intervalsSet, BSPTree bSPTree) {
        return intervalsSet.getFirstLeaf(bSPTree);
    }

    static /* synthetic */ boolean access$200(IntervalsSet intervalsSet, BSPTree bSPTree) {
        return intervalsSet.isIntervalEnd(bSPTree);
    }

    static /* synthetic */ double access$300(IntervalsSet intervalsSet, BSPTree bSPTree) {
        return intervalsSet.getAngle(bSPTree);
    }

    static /* synthetic */ boolean access$400(IntervalsSet intervalsSet, BSPTree bSPTree) {
        return intervalsSet.isIntervalStart(bSPTree);
    }

    static /* synthetic */ BSPTree access$500(IntervalsSet intervalsSet, BSPTree bSPTree) {
        return intervalsSet.nextInternalNode(bSPTree);
    }
}

