/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.euclidean.oned;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.partitioning.Region$Location;

public class Interval {
    private final double lower;
    private final double upper;

    public Interval(double d2, double d3) {
        if (d3 < d2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.ENDPOINTS_NOT_AN_INTERVAL, (Number)d3, d2, true);
        }
        this.lower = d2;
        this.upper = d3;
    }

    public double getInf() {
        return this.lower;
    }

    @Deprecated
    public double getLower() {
        return this.getInf();
    }

    public double getSup() {
        return this.upper;
    }

    @Deprecated
    public double getUpper() {
        return this.getSup();
    }

    public double getSize() {
        return this.upper - this.lower;
    }

    @Deprecated
    public double getLength() {
        return this.getSize();
    }

    public double getBarycenter() {
        return 0.5 * (this.lower + this.upper);
    }

    @Deprecated
    public double getMidPoint() {
        return this.getBarycenter();
    }

    public Region$Location checkPoint(double d2, double d3) {
        if (d2 < this.lower - d3 || d2 > this.upper + d3) {
            return Region$Location.OUTSIDE;
        }
        if (d2 > this.lower + d3 && d2 < this.upper - d3) {
            return Region$Location.INSIDE;
        }
        return Region$Location.BOUNDARY;
    }
}

