/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.enclosing;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Point;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.Space;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.enclosing.Encloser;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.enclosing.EnclosingBall;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.geometry.enclosing.SupportBallGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WelzlEncloser<S extends Space, P extends Point<S>>
implements Encloser<S, P> {
    private final double tolerance;
    private final SupportBallGenerator<S, P> generator;

    public WelzlEncloser(double d2, SupportBallGenerator<S, P> supportBallGenerator) {
        this.tolerance = d2;
        this.generator = supportBallGenerator;
    }

    @Override
    public EnclosingBall<S, P> enclose(Iterable<P> iterable) {
        if (iterable == null || !iterable.iterator().hasNext()) {
            return this.generator.ballOnSupport(new ArrayList());
        }
        return this.pivotingBall(iterable);
    }

    private EnclosingBall<S, P> pivotingBall(Iterable<P> iterable) {
        Serializable serializable = (Point)iterable.iterator().next();
        ArrayList<Point<Object>> arrayList = new ArrayList<Point<Object>>(serializable.getSpace().getDimension() + 1);
        ArrayList<P> arrayList2 = new ArrayList<P>(serializable.getSpace().getDimension() + 1);
        arrayList.add((Point<Object>)serializable);
        ArrayList<Point<Object>> arrayList3 = arrayList;
        serializable = this.moveToFrontBall(arrayList3, arrayList3.size(), arrayList2);
        P p;
        while (!((EnclosingBall)serializable).contains(p = this.selectFarthest(iterable, (EnclosingBall<S, P>)serializable), this.tolerance)) {
            EnclosingBall enclosingBall;
            arrayList2.clear();
            arrayList2.add(p);
            Serializable serializable2 = serializable;
            ArrayList<Point<Object>> arrayList4 = arrayList;
            serializable = this.moveToFrontBall(arrayList4, arrayList4.size(), arrayList2);
            if (enclosingBall.getRadius() < ((EnclosingBall)serializable2).getRadius()) {
                throw new MathInternalError();
            }
            arrayList.add(0, (Point<Object>)p);
            arrayList.subList(((EnclosingBall)serializable).getSupportSize(), arrayList.size()).clear();
        }
        return serializable;
    }

    private EnclosingBall<S, P> moveToFrontBall(List<P> list, int n, List<P> list2) {
        EnclosingBall<S, Point> enclosingBall = this.generator.ballOnSupport(list2);
        if (enclosingBall.getSupportSize() <= enclosingBall.getCenter().getSpace().getDimension()) {
            for (int i2 = 0; i2 < n; ++i2) {
                Point point = (Point)list.get(i2);
                if (enclosingBall.contains(point, this.tolerance)) continue;
                list2.add(point);
                enclosingBall = this.moveToFrontBall(list, i2, list2);
                List<P> list3 = list2;
                list3.remove(list3.size() - 1);
                for (int i3 = i2; i3 > 0; --i3) {
                    list.set(i3, list.get(i3 - 1));
                }
                list.set(0, point);
            }
        }
        return enclosingBall;
    }

    public P selectFarthest(Iterable<P> object, EnclosingBall<S, P> enclosingBall) {
        enclosingBall = enclosingBall.getCenter();
        Point point = null;
        double d2 = -1.0;
        object = object.iterator();
        while (object.hasNext()) {
            double d3;
            Point point2 = (Point)object.next();
            double d4 = point2.distance(enclosingBall);
            if (!(d3 > d2)) continue;
            point = point2;
            d2 = d4;
        }
        return (P)point;
    }
}

