/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.Chromosome;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.ChromosomePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.GeneticAlgorithm;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.ListPopulation;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.Population;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.SelectionPolicy;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.TournamentSelection$1;
import java.util.ArrayList;

public class TournamentSelection
implements SelectionPolicy {
    private int arity;

    public TournamentSelection(int n) {
        this.arity = n;
    }

    public ChromosomePair select(Population population) {
        return new ChromosomePair(this.tournament((ListPopulation)population), this.tournament((ListPopulation)population));
    }

    private Chromosome tournament(ListPopulation iterable) {
        if (((ListPopulation)iterable).getPopulationSize() < this.arity) {
            throw new MathIllegalArgumentException(LocalizedFormats.TOO_LARGE_TOURNAMENT_ARITY, this.arity, ((ListPopulation)iterable).getPopulationSize());
        }
        TournamentSelection tournamentSelection = this;
        TournamentSelection$1 tournamentSelection$1 = new TournamentSelection$1(tournamentSelection, tournamentSelection.arity);
        iterable = new ArrayList<Chromosome>(((ListPopulation)iterable).getChromosomes());
        for (int i2 = 0; i2 < this.arity; ++i2) {
            int n = GeneticAlgorithm.getRandomGenerator().nextInt(iterable.size());
            tournamentSelection$1.addChromosome((Chromosome)iterable.get(n));
            iterable.remove(n);
        }
        return tournamentSelection$1.getFittestChromosome();
    }

    public int getArity() {
        return this.arity;
    }

    public void setArity(int n) {
        this.arity = n;
    }
}

