/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.AbstractListChromosome;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.Chromosome;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.GeneticAlgorithm;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.InvalidRepresentationException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.PermutationChromosome;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RandomKey<T>
extends AbstractListChromosome<Double>
implements PermutationChromosome<T> {
    private final List<Double> sortedRepresentation;
    private final List<Integer> baseSeqPermutation;

    public RandomKey(List<Double> list) {
        super(list);
        list = new ArrayList(this.getRepresentation());
        Collections.sort(list);
        this.sortedRepresentation = Collections.unmodifiableList(list);
        this.baseSeqPermutation = Collections.unmodifiableList(RandomKey.decodeGeneric(RandomKey.baseSequence(this.getLength()), this.getRepresentation(), this.sortedRepresentation));
    }

    public RandomKey(Double[] doubleArray) {
        this(Arrays.asList(doubleArray));
    }

    @Override
    public List<T> decode(List<T> list) {
        return RandomKey.decodeGeneric(list, this.getRepresentation(), this.sortedRepresentation);
    }

    private static <S> List<S> decodeGeneric(List<S> list, List<Double> list2, List<Double> list3) {
        int n = list.size();
        if (list2.size() != n) {
            throw new DimensionMismatchException(list2.size(), n);
        }
        if (list3.size() != n) {
            throw new DimensionMismatchException(list3.size(), n);
        }
        list2 = new ArrayList<Double>(list2);
        ArrayList<S> arrayList = new ArrayList<S>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = list2.indexOf(list3.get(i2));
            arrayList.add(list.get(n2));
            list2.set(n2, null);
        }
        return arrayList;
    }

    @Override
    protected boolean isSame(Chromosome object) {
        if (!(object instanceof RandomKey)) {
            return false;
        }
        object = (RandomKey)object;
        if (this.getLength() != ((AbstractListChromosome)object).getLength()) {
            return false;
        }
        List<Integer> list = this.baseSeqPermutation;
        object = ((RandomKey)object).baseSeqPermutation;
        for (int i2 = 0; i2 < this.getLength(); ++i2) {
            if (list.get(i2) == object.get(i2)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void checkValidity(List<Double> object) {
        object = object.iterator();
        while (object.hasNext()) {
            double d2 = (Double)object.next();
            if (!(d2 < 0.0) && !(d2 > 1.0)) continue;
            throw new InvalidRepresentationException(LocalizedFormats.OUT_OF_RANGE_SIMPLE, d2, 0, 1);
        }
    }

    public static final List<Double> randomPermutation(int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            arrayList.add(GeneticAlgorithm.getRandomGenerator().nextDouble());
        }
        return arrayList;
    }

    public static final List<Double> identityPermutation(int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            arrayList.add((double)i2 / (double)n);
        }
        return arrayList;
    }

    public static <S> List<Double> comparatorPermutation(List<S> list, Comparator<S> comparator) {
        ArrayList<S> arrayList = new ArrayList<S>(list);
        Collections.sort(arrayList, comparator);
        return RandomKey.inducedPermutation(list, arrayList);
    }

    public static <S> List<Double> inducedPermutation(List<S> list, List<S> list2) {
        if (list.size() != list2.size()) {
            throw new DimensionMismatchException(list2.size(), list.size());
        }
        int n = list.size();
        list = new ArrayList<S>(list);
        Double[] doubleArray = new Double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = list.indexOf(list2.get(i2));
            if (n2 == -1) {
                throw new MathIllegalArgumentException(LocalizedFormats.DIFFERENT_ORIG_AND_PERMUTED_DATA, new Object[0]);
            }
            doubleArray[n2] = (double)i2 / (double)n;
            list.set(n2, null);
        }
        return Arrays.asList(doubleArray);
    }

    @Override
    public String toString() {
        return String.format("(f=%s pi=(%s))", this.getFitness(), this.baseSeqPermutation);
    }

    private static List<Integer> baseSequence(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            arrayList.add(i2);
        }
        return arrayList;
    }
}

