/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.AbstractListChromosome;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.Chromosome;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.ChromosomePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.CrossoverPolicy;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.GeneticAlgorithm;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NPointCrossover<T>
implements CrossoverPolicy {
    private final int crossoverPoints;

    public NPointCrossover(int n) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        this.crossoverPoints = n;
    }

    public int getCrossoverPoints() {
        return this.crossoverPoints;
    }

    @Override
    public ChromosomePair crossover(Chromosome chromosome, Chromosome chromosome2) {
        if (!(chromosome instanceof AbstractListChromosome) || !(chromosome2 instanceof AbstractListChromosome)) {
            throw new MathIllegalArgumentException(LocalizedFormats.INVALID_FIXED_LENGTH_CHROMOSOME, new Object[0]);
        }
        return this.mate((AbstractListChromosome)chromosome, (AbstractListChromosome)chromosome2);
    }

    private ChromosomePair mate(AbstractListChromosome<T> abstractListChromosome, AbstractListChromosome<T> abstractListChromosome2) {
        int n = abstractListChromosome.getLength();
        if (n != abstractListChromosome2.getLength()) {
            throw new DimensionMismatchException(abstractListChromosome2.getLength(), n);
        }
        if (this.crossoverPoints >= n) {
            throw new NumberIsTooLargeException(this.crossoverPoints, (Number)n, false);
        }
        List<T> list = abstractListChromosome.getRepresentation();
        List<T> list2 = abstractListChromosome2.getRepresentation();
        ArrayList<T> arrayList = new ArrayList<T>(n);
        ArrayList<T> arrayList2 = new ArrayList<T>(n);
        RandomGenerator randomGenerator = GeneticAlgorithm.getRandomGenerator();
        ArrayList<T> arrayList3 = arrayList;
        ArrayList<T> arrayList4 = arrayList2;
        int n2 = this.crossoverPoints;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.crossoverPoints) {
            int n5 = n3 + 1 + randomGenerator.nextInt(n - n3 - n2);
            while (n3 < n5) {
                arrayList3.add(list.get(n3));
                arrayList4.add(list2.get(n3));
                ++n3;
            }
            ArrayList<T> arrayList5 = arrayList3;
            arrayList3 = arrayList4;
            arrayList4 = arrayList5;
            n3 = n5;
            ++n4;
            --n2;
        }
        for (n4 = n3; n4 < n; ++n4) {
            arrayList3.add(list.get(n4));
            arrayList4.add(list2.get(n4));
        }
        return new ChromosomePair(abstractListChromosome.newFixedLengthChromosome(arrayList), abstractListChromosome2.newFixedLengthChromosome(arrayList2));
    }
}

