/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.Chromosome;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.Population;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListPopulation
implements Population {
    private List<Chromosome> chromosomes;
    private int populationLimit;

    public ListPopulation(int n) {
        this(Collections.emptyList(), n);
    }

    public ListPopulation(List<Chromosome> list, int n) {
        if (list == null) {
            throw new NullArgumentException();
        }
        if (n <= 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.POPULATION_LIMIT_NOT_POSITIVE, n);
        }
        if (list.size() > n) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LIST_OF_CHROMOSOMES_BIGGER_THAN_POPULATION_SIZE, (Number)list.size(), n, false);
        }
        this.populationLimit = n;
        this.chromosomes = new ArrayList<Chromosome>(n);
        this.chromosomes.addAll(list);
    }

    @Deprecated
    public void setChromosomes(List<Chromosome> list) {
        if (list == null) {
            throw new NullArgumentException();
        }
        if (list.size() > this.populationLimit) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LIST_OF_CHROMOSOMES_BIGGER_THAN_POPULATION_SIZE, (Number)list.size(), this.populationLimit, false);
        }
        this.chromosomes.clear();
        this.chromosomes.addAll(list);
    }

    public void addChromosomes(Collection<Chromosome> collection) {
        if (this.chromosomes.size() + collection.size() > this.populationLimit) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LIST_OF_CHROMOSOMES_BIGGER_THAN_POPULATION_SIZE, (Number)this.chromosomes.size(), this.populationLimit, false);
        }
        this.chromosomes.addAll(collection);
    }

    public List<Chromosome> getChromosomes() {
        return Collections.unmodifiableList(this.chromosomes);
    }

    protected List<Chromosome> getChromosomeList() {
        return this.chromosomes;
    }

    @Override
    public void addChromosome(Chromosome chromosome) {
        if (this.chromosomes.size() >= this.populationLimit) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LIST_OF_CHROMOSOMES_BIGGER_THAN_POPULATION_SIZE, (Number)this.chromosomes.size(), this.populationLimit, false);
        }
        this.chromosomes.add(chromosome);
    }

    @Override
    public Chromosome getFittestChromosome() {
        Chromosome chromosome = this.chromosomes.get(0);
        for (Chromosome chromosome2 : this.chromosomes) {
            if (chromosome2.compareTo(chromosome) <= 0) continue;
            chromosome = chromosome2;
        }
        return chromosome;
    }

    @Override
    public int getPopulationLimit() {
        return this.populationLimit;
    }

    public void setPopulationLimit(int n) {
        if (n <= 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.POPULATION_LIMIT_NOT_POSITIVE, n);
        }
        if (n < this.chromosomes.size()) {
            throw new NumberIsTooSmallException(n, (Number)this.chromosomes.size(), true);
        }
        this.populationLimit = n;
    }

    @Override
    public int getPopulationSize() {
        return this.chromosomes.size();
    }

    public String toString() {
        return this.chromosomes.toString();
    }

    @Override
    public Iterator<Chromosome> iterator() {
        return this.getChromosomes().iterator();
    }
}

