/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.ChromosomePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.CrossoverPolicy;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.MutationPolicy;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.Population;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.SelectionPolicy;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.StoppingCondition;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.JDKRandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;

public class GeneticAlgorithm {
    private static RandomGenerator randomGenerator = new JDKRandomGenerator();
    private final CrossoverPolicy crossoverPolicy;
    private final double crossoverRate;
    private final MutationPolicy mutationPolicy;
    private final double mutationRate;
    private final SelectionPolicy selectionPolicy;
    private int generationsEvolved = 0;

    public GeneticAlgorithm(CrossoverPolicy crossoverPolicy, double d2, MutationPolicy mutationPolicy, double d3, SelectionPolicy selectionPolicy) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.CROSSOVER_RATE, (Number)d2, 0, 1);
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.MUTATION_RATE, (Number)d3, 0, 1);
        }
        this.crossoverPolicy = crossoverPolicy;
        this.crossoverRate = d2;
        this.mutationPolicy = mutationPolicy;
        this.mutationRate = d3;
        this.selectionPolicy = selectionPolicy;
    }

    public static synchronized void setRandomGenerator(RandomGenerator randomGenerator) {
        GeneticAlgorithm.randomGenerator = randomGenerator;
    }

    public static synchronized RandomGenerator getRandomGenerator() {
        return randomGenerator;
    }

    public Population evolve(Population population, StoppingCondition stoppingCondition) {
        this.generationsEvolved = 0;
        while (!stoppingCondition.isSatisfied(population)) {
            population = this.nextGeneration(population);
            ++this.generationsEvolved;
        }
        return population;
    }

    public Population nextGeneration(Population population) {
        Population population2 = population.nextGeneration();
        RandomGenerator randomGenerator = GeneticAlgorithm.getRandomGenerator();
        while (population2.getPopulationSize() < population2.getPopulationLimit()) {
            ChromosomePair chromosomePair = this.getSelectionPolicy().select(population);
            if (randomGenerator.nextDouble() < this.getCrossoverRate()) {
                chromosomePair = this.getCrossoverPolicy().crossover(chromosomePair.getFirst(), chromosomePair.getSecond());
            }
            if (randomGenerator.nextDouble() < this.getMutationRate()) {
                chromosomePair = new ChromosomePair(this.getMutationPolicy().mutate(chromosomePair.getFirst()), this.getMutationPolicy().mutate(chromosomePair.getSecond()));
            }
            population2.addChromosome(chromosomePair.getFirst());
            if (population2.getPopulationSize() >= population2.getPopulationLimit()) continue;
            population2.addChromosome(chromosomePair.getSecond());
        }
        return population2;
    }

    public CrossoverPolicy getCrossoverPolicy() {
        return this.crossoverPolicy;
    }

    public double getCrossoverRate() {
        return this.crossoverRate;
    }

    public MutationPolicy getMutationPolicy() {
        return this.mutationPolicy;
    }

    public double getMutationRate() {
        return this.mutationRate;
    }

    public SelectionPolicy getSelectionPolicy() {
        return this.selectionPolicy;
    }

    public int getGenerationsEvolved() {
        return this.generationsEvolved;
    }
}

