/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.Population;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.genetics.StoppingCondition;

public class FixedGenerationCount
implements StoppingCondition {
    private int numGenerations = 0;
    private final int maxGenerations;

    public FixedGenerationCount(int n) {
        if (n <= 0) {
            throw new NumberIsTooSmallException(n, (Number)1, true);
        }
        this.maxGenerations = n;
    }

    public boolean isSatisfied(Population population) {
        if (this.numGenerations < this.maxGenerations) {
            ++this.numGenerations;
            return false;
        }
        return true;
    }

    public int getNumGenerations() {
        return this.numGenerations;
    }
}

